/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl.sld.parsing.filteroperator.spatial;

import java.io.IOException;
import org.gvsig.sldsupport.exception.InvalidSLDObjectException;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.impl.sld.parsing.filteroperator.spatial.EnvelopeElement;
import org.gvsig.sldsupport.impl.util.SLDUtils;
import org.gvsig.sldsupport.impl.util.XmlBuilder;
import org.gvsig.sldsupport.sld.filter.operator.spatial.GMLEnvelope;
import org.gvsig.sldsupport.sld.filter.operator.spatial.SLDBinarySpatialOperator;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class BinarySpatialOperatorElement {
    public static void append(SLDBinarySpatialOperator obj, XmlBuilder xb, String version) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        xb.openTag(obj.getOperatorName());
        xb.writeTag("PropertyName", obj.getPropertyName());
        if (obj.getIsGeometry()) {
            xb.writeRaw(obj.getLiteralGeometry());
        } else {
            EnvelopeElement.append(obj.getEnvelope(), xb, version);
        }
        xb.closeTag();
    }

    public static SLDBinarySpatialOperator parse(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        SLDBinarySpatialOperator resp = new SLDBinarySpatialOperator();
        String txt = parser.getName();
        resp.setOperatorName(txt);
        int tag = 0;
        tag = parser.nextTag();
        String name = parser.getName();
        while (!SLDUtils.isStr(name, resp.getOperatorName()) || tag != 3) {
            switch (tag) {
                case 2: {
                    if (SLDUtils.isStr(name, "PropertyName")) {
                        txt = parser.nextText();
                        resp.setPropertyName(txt);
                        parser.nextTag();
                        break;
                    }
                    if (SLDUtils.isStr(name, "Envelope")) {
                        GMLEnvelope env = EnvelopeElement.parse(parser, version);
                        resp.setIsGeometry(false);
                        resp.setEnvelope(env);
                        break;
                    }
                    throw new SLDReadException("Bad SLD file. Unexpected entity in Binary spatial operator: " + name);
                }
                case 3: {
                    break;
                }
            }
            tag = parser.getEventType();
            name = parser.getName();
        }
        parser.nextTag();
        return resp;
    }
}

