/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl.sld.parsing.symbol;

import java.io.IOException;
import java.util.Map;
import org.gvsig.sldsupport.exception.InvalidSLDObjectException;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.impl.sld.parsing.GeometryElement;
import org.gvsig.sldsupport.impl.sld.parsing.GraphicElement;
import org.gvsig.sldsupport.impl.util.SLDUtils;
import org.gvsig.sldsupport.impl.util.XmlBuilder;
import org.gvsig.sldsupport.sld.graphic.SLDGraphic;
import org.gvsig.sldsupport.sld.symbol.SLDPointSymbol;
import org.gvsig.sldsupport.sld.symbol.misc.SLDGeometry;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class PointSymbolElement {
    public static void append(SLDPointSymbol obj, XmlBuilder xb, Map<String, String> atts) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        SLDGraphic gra;
        String v = obj.getVersion();
        if (v == null && atts != null) {
            v = atts.get("version");
        }
        if (v == null) {
            v = "1.0.0";
        }
        String ent = "";
        ent = v.compareToIgnoreCase("1.0.0") == 0 ? "PointSymbolizer" : "PointSymbol";
        if (atts == null) {
            xb.openTag(ent);
        } else {
            xb.openTag(ent, atts);
        }
        String geoName = obj.getGeometryPropertyName();
        if (geoName != null) {
            GeometryElement.append(new SLDGeometry(geoName), xb, v);
        }
        if ((gra = obj.getGraphic()) != null) {
            GraphicElement.append(gra, xb, v);
        }
        xb.closeTag();
    }

    public static SLDPointSymbol parse(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        String ent_name = parser.getName();
        SLDPointSymbol resp = new SLDPointSymbol();
        resp.setVersion(version);
        int tag = 0;
        tag = parser.nextTag();
        String name = parser.getName();
        Object txt = null;
        while (!SLDUtils.isStr(name, ent_name) || tag != 3) {
            switch (tag) {
                case 2: {
                    if (SLDUtils.isStr(name, "Geometry")) {
                        SLDGeometry geom = GeometryElement.parse(parser, version);
                        resp.setGeometryPropertyName(geom.getPropertyName());
                        break;
                    }
                    if (SLDUtils.isStr(name, "Graphic")) {
                        SLDGraphic gr = GraphicElement.parse(parser, version);
                        resp.setGraphic(gr);
                        break;
                    }
                    throw new SLDReadException("Bad SLD file. Unexpected entity in point symbol: " + name);
                }
                case 3: {
                    break;
                }
            }
            tag = parser.getEventType();
            name = parser.getName();
        }
        parser.nextTag();
        return resp;
    }
}

