/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.fmap.layers;

import org.gvsig.raster.fmap.layers.ILayerState;
import org.gvsig.raster.fmap.layers.NotAvailableStateException;

public class FLyrState
implements ILayerState {
    private boolean open = false;
    private boolean closed = true;
    private boolean awake = false;
    private boolean stopped = false;
    private int lastBeforeStop = -1;

    @Override
    public boolean isAwake() {
        return this.awake;
    }

    @Override
    public void enableAwake() throws NotAvailableStateException {
        if (this.awake) {
            return;
        }
        if (!(this.open || this.closed || this.stopped)) {
            throw new NotAvailableStateException("Awake state not available");
        }
        this.awake = true;
        this.open = false;
        this.closed = false;
        this.stopped = false;
        this.lastBeforeStop = -1;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void enableOpen() throws NotAvailableStateException {
        if (!this.stopped && !this.awake) {
            throw new NotAvailableStateException("Open state not available");
        }
        this.open = true;
        this.awake = false;
        this.closed = false;
        this.stopped = false;
        this.lastBeforeStop = -1;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void enableClosed() throws NotAvailableStateException {
        if (!(this.open || this.awake || this.stopped)) {
            throw new NotAvailableStateException("Closed state not available");
        }
        this.closed = true;
        this.awake = false;
        this.open = false;
        this.stopped = false;
        this.lastBeforeStop = -1;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public void enableStopped() {
        if (this.open || this.awake || this.closed) {
            int n = this.open ? 0 : (this.closed ? 1 : (this.lastBeforeStop = this.awake ? 2 : -1));
            if (this.lastBeforeStop != -1) {
                this.stopped = true;
                this.awake = false;
                this.open = false;
                this.closed = false;
            }
        }
    }

    @Override
    public void disableStopped() {
        if (this.stopped && this.lastBeforeStop != -1) {
            switch (this.lastBeforeStop) {
                case 0: {
                    this.open = true;
                    this.awake = false;
                    this.closed = false;
                    break;
                }
                case 1: {
                    this.closed = true;
                    this.open = false;
                    this.awake = false;
                    break;
                }
                case 2: {
                    this.awake = true;
                    this.open = false;
                    this.closed = false;
                }
            }
            this.stopped = false;
            this.lastBeforeStop = -1;
        }
    }
}

