/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.fmap.layers;

import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Events.MoveEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PanListener;
import org.gvsig.raster.fmap.layers.DefaultFLyrRaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeorefPanListenerImpl
implements PanListener {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(GeorefPanListenerImpl.class);
    private MapControl mapControl;
    private DefaultFLyrRaster lyrRaster = null;
    private String pathToFile = null;

    public GeorefPanListenerImpl(MapControl mapControl) {
        this.mapControl = mapControl;
    }

    public void move(MoveEvent event) {
        ViewPort vp = this.mapControl.getMapContext().getViewPort();
        Point2D from = vp.toMapPoint(event.getFrom());
        Point2D to = vp.toMapPoint(event.getTo());
        Rectangle2D.Double r = new Rectangle2D.Double();
        Rectangle2D extent = vp.getExtent();
        r.x = extent.getX() - (to.getX() - from.getX());
        r.y = extent.getY() - (to.getY() - from.getY());
        r.width = extent.getWidth();
        r.height = extent.getHeight();
        try {
            Envelope env = geomManager.createEnvelope(r.getMinX(), r.getMinY(), r.getMaxX(), r.getMaxY(), 0);
            vp.setEnvelope(env);
        }
        catch (CreateEnvelopeException e) {
            logger.error("Error creating the envelope", (Throwable)e);
        }
    }

    public boolean cancelDrawing() {
        return true;
    }

    public DefaultFLyrRaster getLyrRaster() {
        return this.lyrRaster;
    }

    public void setLyrRaster(DefaultFLyrRaster lyrRaster) {
        this.lyrRaster = lyrRaster;
    }

    public String getPathToFile() {
        return this.pathToFile;
    }

    public void setPathToFile(String pathToFile) {
        this.pathToFile = pathToFile;
    }

    public Image getImageCursor() {
        return null;
    }
}

