/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.osm.swing.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.osm.swing.AddOSMLayerPanel;
import org.gvsig.raster.osm.swing.impl.AddServerPanel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddOSMLayerPanelImpl
extends JPanel
implements AddOSMLayerPanel,
MouseListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String separator = "*";
    private Logger log = LoggerFactory.getLogger(AddOSMLayerPanelImpl.class);
    private File pathToServerList = null;
    private JTextField textSelectedServer = null;
    private JTable tableServerList = null;
    private String propertiesFileName = "osmservers.properties";
    private JPanel buttonsPanel = null;
    private JPanel crsWarningPanel = null;
    private JPanel selectedServerPanel = null;
    private String[] columnNames = null;
    private JButton addServerButton = null;
    private JButton updateServerButton = null;
    private JButton removeServerButton = null;
    private AddServerPanel serverPanel = null;
    private MouseListener mouseListener = null;
    private JLabel crsWarningLabel = null;
    private boolean showCrsWarning = false;

    public AddOSMLayerPanelImpl(File pathToServerList) {
        this(pathToServerList, false);
    }

    public AddOSMLayerPanelImpl(File pathToServerList, boolean showCrsWarning) {
        this.pathToServerList = pathToServerList != null ? pathToServerList : new File(System.getProperty("user.home"));
        this.showCrsWarning = showCrsWarning;
        this.columnNames = new String[]{Messages.getText((String)"name"), Messages.getText((String)"url"), Messages.getText((String)"levels"), Messages.getText((String)"format")};
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.getJPanelSelectedServer(), gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JScrollPane scrollPane = new JScrollPane(this.getJTableServerList());
        this.add((Component)scrollPane, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.getAddServerPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.add((Component)this.getJPanelButtonsPanel(), gridBagConstraints);
        if (this.showCrsWarning) {
            gridBagConstraints.gridy = 4;
            this.add((Component)this.getJPanelCrsWarningPanel(), gridBagConstraints);
        }
    }

    private JPanel getJPanelButtonsPanel() {
        if (this.buttonsPanel == null) {
            FlowLayout fl = new FlowLayout();
            this.buttonsPanel = new JPanel(fl);
            this.updateServerButton = new JButton(Messages.getText((String)"update_server"));
            this.updateServerButton.addActionListener(this);
            this.addServerButton = new JButton(Messages.getText((String)"add_server"));
            this.addServerButton.addActionListener(this);
            this.removeServerButton = new JButton(Messages.getText((String)"remove_server"));
            this.removeServerButton.addActionListener(this);
            this.buttonsPanel.add((Component)this.updateServerButton, fl);
            this.buttonsPanel.add((Component)this.addServerButton, fl);
            this.buttonsPanel.add((Component)this.removeServerButton, fl);
        }
        return this.buttonsPanel;
    }

    private JPanel getJPanelCrsWarningPanel() {
        if (this.crsWarningPanel == null) {
            FlowLayout fl = new FlowLayout();
            this.crsWarningPanel = new JPanel(fl);
            I18nManager i18nManager = ToolsLocator.getI18nManager();
            StringBuilder builder = new StringBuilder();
            builder.append("<html><font color=\"red\">");
            builder.append(i18nManager.getTranslation("_crs_warning"));
            builder.append("</font></body></html>");
            this.crsWarningLabel = new JLabel(Messages.getText((String)builder.toString()));
            this.crsWarningPanel.add((Component)this.crsWarningLabel, fl);
        }
        return this.crsWarningPanel;
    }

    private JPanel getJPanelSelectedServer() {
        if (this.selectedServerPanel == null) {
            this.selectedServerPanel = new JPanel(new BorderLayout());
            this.selectedServerPanel.setBorder(BorderFactory.createTitledBorder(Messages.getText((String)"server")));
            this.selectedServerPanel.add((Component)this.getJTextFieldSelectedServer(), "Center");
        }
        return this.selectedServerPanel;
    }

    private JTextField getJTextFieldSelectedServer() {
        if (this.textSelectedServer == null) {
            this.textSelectedServer = new JTextField();
            this.textSelectedServer.setEditable(false);
        }
        return this.textSelectedServer;
    }

    private JTable getJTableServerList() {
        if (this.tableServerList == null) {
            DefaultTableModel model = null;
            try {
                Object[][] objs = this.loadServerListFromProperties();
                model = new DefaultTableModel(objs, this.columnNames);
                this.tableServerList = new JTable(model);
                this.tableServerList.setAutoResizeMode(4);
                this.tableServerList.getColumnModel().getColumn(2).setMaxWidth(50);
                this.tableServerList.getColumnModel().getColumn(3).setMaxWidth(50);
            }
            catch (FileNotFoundException e) {
                this.log.debug("Properties file to store servers has not been located");
            }
            catch (IOException e) {
                this.log.debug("Error reading properties file which stores servers");
            }
            if (this.tableServerList == null) {
                model = new DefaultTableModel((Object[][])null, this.columnNames);
                this.tableServerList = new JTable(model);
            }
            ListSelectionModel selectionModel = this.tableServerList.getSelectionModel();
            selectionModel.setSelectionMode(0);
            this.tableServerList.addMouseListener(this);
        }
        return this.tableServerList;
    }

    private Object[][] loadServerListFromProperties() throws FileNotFoundException, IOException {
        if (!new File(this.getPropertiesFilePath()).exists()) {
            return null;
        }
        Properties prop = new Properties();
        prop.load(new FileInputStream(this.getPropertiesFilePath()));
        Collection<Object> collect = prop.values();
        if (collect == null) {
            return null;
        }
        Iterator<Object> it = collect.iterator();
        Object[][] result = new Object[collect.size()][4];
        int cont = 0;
        while (it.hasNext()) {
            String value = (String)it.next();
            result[cont] = value.split("\\*");
            ++cont;
        }
        return result;
    }

    private void addServerToProperties(String name, String url, String levels, String format) {
        try {
            if (!new File(this.getPropertiesFilePath()).exists() && !new File(this.getPropertiesFilePath()).createNewFile()) {
                return;
            }
            Properties prop = new Properties();
            prop.load(new FileInputStream(this.getPropertiesFilePath()));
            prop.setProperty(this.getKeyFromName(name), name + separator + url + separator + levels + separator + format);
            prop.store(new FileOutputStream(this.getPropertiesFilePath()), null);
        }
        catch (FileNotFoundException e1) {
            JOptionPane.showMessageDialog(this, Messages.getText((String)"cannot_add_to_file"), Messages.getText((String)"Error"), 0);
            this.log.info(Messages.getText((String)"cannot_add_to_file"), (Throwable)e1);
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(this, Messages.getText((String)"cannot_add_to_file"), Messages.getText((String)"Error"), 0);
            this.log.info(Messages.getText((String)"cannot_add_to_file"), (Throwable)e1);
        }
    }

    private void removeServerFromProperties(String name) {
        try {
            if (!new File(this.getPropertiesFilePath()).exists()) {
                return;
            }
            Properties prop = new Properties();
            prop.load(new FileInputStream(this.getPropertiesFilePath()));
            prop.remove(this.getKeyFromName(name));
            prop.store(new FileOutputStream(this.getPropertiesFilePath()), null);
        }
        catch (FileNotFoundException e1) {
            JOptionPane.showMessageDialog(this, Messages.getText((String)"cannot_remove_from_file"), Messages.getText((String)"Error"), 0);
            this.log.info(Messages.getText((String)"cannot_remove_from_file"), (Throwable)e1);
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(this, Messages.getText((String)"cannot_remove_from_file"), Messages.getText((String)"Error"), 0);
            this.log.info(Messages.getText((String)"cannot_remove_from_file"), (Throwable)e1);
        }
    }

    public String getPropertiesFilePath() {
        return this.pathToServerList.getAbsolutePath() + File.separator + this.propertiesFileName;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this.getJTableServerList() && this.getJTableServerList().getSelectedRow() != -1) {
            int selectedRow = this.getJTableServerList().getSelectedRow();
            String name = (String)this.getJTableServerList().getModel().getValueAt(selectedRow, 0);
            String url = (String)this.getJTableServerList().getModel().getValueAt(selectedRow, 1);
            String levels = (String)this.getJTableServerList().getModel().getValueAt(selectedRow, 2);
            String format = (String)this.getJTableServerList().getModel().getValueAt(selectedRow, 3);
            this.getJTextFieldSelectedServer().setText(name);
            this.getAddServerPanel().getJTextFieldName().setText(name);
            this.getAddServerPanel().getJTextFieldURL().setText(url);
            this.getAddServerPanel().getJTextFieldLevels().setText(levels);
            this.getAddServerPanel().getJTextFieldFormat().setText(format);
            if (this.mouseListener != null) {
                this.mouseListener.mousePressed(e);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        this.mouseListener = listener;
    }

    public JComponent getComponent() {
        return this;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int res;
        int selected;
        if (e.getSource() == this.updateServerButton) {
            if (this.getJTableServerList().getSelectedRow() == -1) {
                JOptionPane.showMessageDialog(this, Messages.getText((String)"row_not_selected"), Messages.getText((String)"Info"), 1);
                return;
            }
            if (this.getAddServerPanel().check()) {
                String name = this.getAddServerPanel().getJTextFieldName().getText();
                String url = this.getAddServerPanel().getJTextFieldURL().getText();
                String levels = this.getAddServerPanel().getJTextFieldLevels().getText();
                String format = this.getAddServerPanel().getJTextFieldFormat().getText();
                int updateRow = this.getJTableServerList().getSelectedRow();
                if (updateRow < 0) {
                    JOptionPane.showMessageDialog(this, Messages.getText((String)"row_not_selected"), Messages.getText((String)"Info"), 1);
                    return;
                }
                int res2 = JOptionPane.showConfirmDialog(this, Messages.getText((String)"update_existing_row"), Messages.getText((String)"Info"), 1);
                if (res2 == 0) {
                    String nameToRemove = (String)this.getJTableServerList().getModel().getValueAt(updateRow, 0);
                    this.removeServerFromProperties(nameToRemove);
                    ((DefaultTableModel)this.getJTableServerList().getModel()).removeRow(updateRow);
                    ((DefaultTableModel)this.getJTableServerList().getModel()).addRow(new Object[]{name, url, levels, format});
                    this.addServerToProperties(name, url, levels, format);
                }
                return;
            }
            JOptionPane.showMessageDialog(this, Messages.getText((String)"format_not_valid"), Messages.getText((String)"Info"), 1);
        }
        if (e.getSource() == this.addServerButton) {
            if (this.getAddServerPanel().check()) {
                String name = this.getAddServerPanel().getJTextFieldName().getText();
                String url = this.getAddServerPanel().getJTextFieldURL().getText();
                String levels = this.getAddServerPanel().getJTextFieldLevels().getText();
                String format = this.getAddServerPanel().getJTextFieldFormat().getText();
                int updateRow = this.existsServerInList(name);
                if (updateRow != -1) {
                    JOptionPane.showMessageDialog(this, Messages.getText((String)"server_exists"), Messages.getText((String)"Info"), 1);
                    return;
                }
                ((DefaultTableModel)this.getJTableServerList().getModel()).addRow(new Object[]{name, url, levels, format});
                this.addServerToProperties(name, url, levels, format);
                return;
            }
            JOptionPane.showMessageDialog(this, Messages.getText((String)"format_not_valid"), Messages.getText((String)"Info"), 1);
        }
        if (e.getSource() == this.removeServerButton && (selected = this.getJTableServerList().getSelectedRow()) != -1 && (res = JOptionPane.showConfirmDialog(this, Messages.getText((String)"remove_existing_row"), Messages.getText((String)"Info"), 1)) == 0) {
            String name = (String)this.getJTableServerList().getModel().getValueAt(selected, 0);
            ((DefaultTableModel)this.getJTableServerList().getModel()).removeRow(selected);
            this.getJTextFieldSelectedServer().setText("");
            this.removeServerFromProperties(name);
        }
    }

    private int existsServerInList(String name) {
        for (int i = 0; i < this.getJTableServerList().getRowCount(); ++i) {
            String value = (String)this.getJTableServerList().getModel().getValueAt(i, 0);
            if (!value.equals(name)) continue;
            return i;
        }
        return -1;
    }

    private String getKeyFromName(String name) {
        return name.replace(' ', '_');
    }

    private AddServerPanel getAddServerPanel() {
        if (this.serverPanel == null) {
            this.serverPanel = new AddServerPanel(separator);
        }
        return this.serverPanel;
    }

    public String getPropertiesFileName() {
        return this.propertiesFileName;
    }

    public boolean areSettingsValid() {
        return this.getJTableServerList().getSelectedRow() != -1 && this.getJTextFieldSelectedServer().getText() != null && !this.getJTextFieldSelectedServer().getText().equals("");
    }

    public String getSelectedFormat() {
        if (this.getSelectedName() == null) {
            return null;
        }
        for (int i = 0; i < this.getJTableServerList().getRowCount(); ++i) {
            String value = (String)this.getJTableServerList().getModel().getValueAt(i, 0);
            if (!value.equals(this.getSelectedName())) continue;
            return (String)this.getJTableServerList().getModel().getValueAt(i, 3);
        }
        return null;
    }

    public String getSelectedLevel() {
        if (this.getSelectedName() == null) {
            return null;
        }
        for (int i = 0; i < this.getJTableServerList().getRowCount(); ++i) {
            String value = (String)this.getJTableServerList().getModel().getValueAt(i, 0);
            if (!value.equals(this.getSelectedName())) continue;
            return (String)this.getJTableServerList().getModel().getValueAt(i, 2);
        }
        return null;
    }

    public String getSelectedName() {
        return this.getJTextFieldSelectedServer().getText();
    }

    public URL getSelectedURL() throws MalformedURLException {
        if (this.getSelectedName() == null) {
            return null;
        }
        for (int i = 0; i < this.getJTableServerList().getRowCount(); ++i) {
            String value = (String)this.getJTableServerList().getModel().getValueAt(i, 0);
            if (!value.equals(this.getSelectedName())) continue;
            return new URL((String)this.getJTableServerList().getModel().getValueAt(i, 1));
        }
        return null;
    }
}

