/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.algorithm;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.algorithm.FileOutputChannelSelectionPanel;
import es.unex.sextante.gui.algorithm.GeneralOptionsChannelSelectionPanel;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.Output3DRasterLayer;
import es.unex.sextante.outputs.OutputRasterLayer;
import es.unex.sextante.outputs.OutputVectorLayer;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JTabbedPane;

public class OutputChannelSelectionDialog
extends JDialog
implements ActionListener {
    public static final int TYPE_RASTER = 0;
    public static final int TYPE_VECTOR = 1;
    public static final int TYPE_TABLE = 2;
    public static final int TYPE_RASTER3D = 3;
    private String m_sOutputChannel;
    private GeneralOptionsChannelSelectionPanel m_GeneralOptionsChannelSelectionPanel;
    private FileOutputChannelSelectionPanel m_FileOutputChannelSelectionPanel;
    private final Output m_Output;

    public OutputChannelSelectionDialog(Output out) {
        super(SextanteGUI.getMainFrame(), true);
        this.m_Output = out;
        this.initGUI();
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void initGUI() {
        String sDesc;
        String[] sExt;
        this.setResizable(false);
        this.setPreferredSize(new Dimension(500, 400));
        this.getContentPane().setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        this.m_GeneralOptionsChannelSelectionPanel = new GeneralOptionsChannelSelectionPanel(this.m_Output, this);
        if (this.m_Output instanceof OutputRasterLayer) {
            sExt = SextanteGUI.getOutputFactory().getRasterLayerOutputExtensions();
            sDesc = Sextante.getText((String)Sextante.getText((String)"Raster_layers"));
            boolean iType = false;
        } else if (this.m_Output instanceof Output3DRasterLayer) {
            sExt = SextanteGUI.getOutputFactory().get3DRasterLayerOutputExtensions();
            sDesc = Sextante.getText((String)Sextante.getText((String)"3D_Raster_layers"));
            int iType = 3;
        } else if (this.m_Output instanceof OutputVectorLayer) {
            sExt = SextanteGUI.getOutputFactory().getVectorLayerOutputExtensions();
            sDesc = Sextante.getText((String)Sextante.getText((String)"Vector_layer"));
            boolean iType = true;
        } else {
            sExt = SextanteGUI.getOutputFactory().getTableOutputExtensions();
            sDesc = Sextante.getText((String)Sextante.getText((String)"Tables"));
            int iType = 2;
        }
        this.m_FileOutputChannelSelectionPanel = new FileOutputChannelSelectionPanel(sDesc, sExt, this);
        tabbedPane.addTab(Sextante.getText((String)"File"), this.m_FileOutputChannelSelectionPanel);
        tabbedPane.addTab(Sextante.getText((String)"General"), this.m_GeneralOptionsChannelSelectionPanel);
        this.getContentPane().add(tabbedPane);
    }

    public String getOutputChannelString() {
        return this.m_sOutputChannel;
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        if (action.getActionCommand().equals("CancelSelection")) {
            this.m_sOutputChannel = null;
            this.setVisible(false);
            this.dispose();
        } else if (action.getActionCommand().equals("ApproveSelection")) {
            this.m_sOutputChannel = this.m_FileOutputChannelSelectionPanel.getSelectedFile();
            this.setVisible(false);
            this.dispose();
        } else if (action.getActionCommand().equals("OVERWRITE")) {
            this.m_sOutputChannel = Sextante.getText((String)"[Overwrite]");
            this.setVisible(false);
            this.dispose();
        } else if (action.getActionCommand().equals("SET_TEMP_FILE")) {
            this.m_sOutputChannel = Sextante.getText((String)"[Save_to_temporary_file]");
            this.setVisible(false);
            this.dispose();
        } else if (action.getActionCommand().equals("DO_NOT_CREATE_OUTPUT")) {
            this.m_sOutputChannel = Sextante.getText((String)"[Do_not_create_output]");
            this.setVisible(false);
            this.dispose();
        }
    }
}

