/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.algorithm;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.swing.Element;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.expressionevaluator.FeatureSymbolTable;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.expressionevaluator.FeatureStoreElement;

public class TableFilterPanel
extends JPanel {
    private JTextField textField;
    private JButton button;
    private FeatureStore m_Store = null;
    private ExpressionPickerController expressionControler;
    private FeatureStoreElement element;

    public TableFilterPanel(FeatureStore m_Store) {
        this.initGUI();
        this.setStore(m_Store);
    }

    public TableFilterPanel() {
        this.initGUI();
    }

    private void initGUI() {
        this.button = new JButton("");
        this.textField = new JTextField("");
        this.textField.setMaximumSize(new Dimension(340, 18));
        TableLayout thisLayout = new TableLayout((double[][])new double[][]{{-1.0, 25.0}, {-1.0}});
        this.setLayout((LayoutManager)thisLayout);
        this.add((Component)this.textField, "0,  0");
        this.add((Component)this.button, "1,  0");
        ExpressionEvaluatorSwingManager swingManager = ExpressionEvaluatorSwingLocator.getManager();
        this.expressionControler = swingManager.createExpressionPickerController((JTextComponent)this.textField, this.button);
        this.element = DALSwingLocator.getSwingManager().createFeatureStoreElement(this.m_Store);
        if (this.element != null) {
            this.expressionControler.getConfig().addElement((Element)this.element);
        }
    }

    public Expression getExpression() {
        return this.expressionControler.get();
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public JButton getButton() {
        return this.button;
    }

    public void setStore(FeatureStore store) {
        this.m_Store = store;
        this.element.setFeatureStore(store);
        if (store != null) {
            Feature sampleFeature = null;
            try {
                sampleFeature = store.getFeatureSelection().first();
                if (sampleFeature == null) {
                    sampleFeature = store.first();
                }
            }
            catch (DataException dataException) {
                // empty catch block
            }
            if (sampleFeature != null) {
                FeatureSymbolTable featureSymbolTable = DALLocator.getDataManager().createFeatureSymbolTable();
                featureSymbolTable.setFeature(sampleFeature);
                this.expressionControler.getConfig().setPreviewSymbolTable((SymbolTable)featureSymbolTable.createParent());
            }
        }
    }

    public void setPhrase(String sText) {
        this.textField.setText(sText);
    }

    public String getPhrase() {
        return this.textField.getText();
    }

    @Override
    public void setToolTipText(String sText) {
        this.textField.setToolTipText(sText);
    }
}

