/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.batch.nonFileBased;

import es.unex.sextante.additionalInfo.AdditionalInfoNumericalValue;
import es.unex.sextante.additionalInfo.AdditionalInfoSelection;
import es.unex.sextante.additionalInfo.AdditionalInfoString;
import es.unex.sextante.additionalInfo.AdditionalInfoVectorLayer;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.Output3DRasterLayer;
import es.unex.sextante.outputs.OutputRasterLayer;
import es.unex.sextante.outputs.OutputTable;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.Parameter3DRasterLayer;
import es.unex.sextante.parameters.ParameterBand;
import es.unex.sextante.parameters.ParameterBoolean;
import es.unex.sextante.parameters.ParameterDataObject;
import es.unex.sextante.parameters.ParameterNumericalValue;
import es.unex.sextante.parameters.ParameterRasterLayer;
import es.unex.sextante.parameters.ParameterSelection;
import es.unex.sextante.parameters.ParameterString;
import es.unex.sextante.parameters.ParameterVectorLayer;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class ParametersTableModel
extends AbstractTableModel {
    private final String[] m_sColumnNames;
    private final ArrayList[] m_Data;
    private final ParametersSet m_Parameters;
    public static final int INIT_ROWS = 2;

    public ParametersTableModel(ParametersSet ps, OutputObjectsSet ooSet) {
        int i;
        this.m_Parameters = ps;
        this.m_sColumnNames = new String[ps.getNumberOfParameters() + ooSet.getOutputDataObjectsCount()];
        for (i = 0; i < ps.getNumberOfParameters(); ++i) {
            this.m_sColumnNames[i] = ps.getParameter(i).getParameterDescription();
        }
        for (i = 0; i < ooSet.getOutputObjectsCount(); ++i) {
            Output out = ooSet.getOutput(i);
            if (!(out instanceof OutputRasterLayer) && !(out instanceof Output3DRasterLayer) && !(out instanceof OutputVectorLayer) && !(out instanceof OutputTable)) continue;
            this.m_sColumnNames[i + ps.getNumberOfParameters()] = out.getDescription();
        }
        this.m_Data = new ArrayList[ps.getNumberOfParameters() + ooSet.getOutputDataObjectsCount()];
        for (i = 0; i < this.m_sColumnNames.length; ++i) {
            this.m_Data[i] = new ArrayList();
            Object def = this.getDefaultValue(i);
            for (int j = 0; j < 2; ++j) {
                this.m_Data[i].add(def);
            }
        }
    }

    @Override
    public int getColumnCount() {
        return this.m_sColumnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.m_Data[0].size();
    }

    @Override
    public String getColumnName(int iCol) {
        return this.m_sColumnNames[iCol];
    }

    public String[] getColumnNames() {
        return this.m_sColumnNames;
    }

    @Override
    public Object getValueAt(int iRow, int iCol) {
        return this.m_Data[iCol].get(iRow);
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int iRow, int iCol) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int iRow, int iCol) {
        this.m_Data[iCol].set(iRow, value);
        this.fireTableCellUpdated(iRow, iCol);
    }

    public void addRow() {
        for (int i = 0; i < this.m_sColumnNames.length; ++i) {
            Object def = this.getDefaultValue(i);
            this.m_Data[i].add(def);
        }
        this.fireTableRowsInserted(this.m_Data[0].size(), this.m_Data[0].size());
    }

    public void removeRow(int iRow) {
        for (int i = 0; i < this.m_sColumnNames.length; ++i) {
            this.m_Data[i].remove(iRow);
        }
        this.fireTableRowsDeleted(iRow, iRow);
    }

    private Object getDefaultValue(int iIndex) {
        if (iIndex < this.m_Parameters.getNumberOfParameters()) {
            Parameter parameter = this.m_Parameters.getParameter(iIndex);
            try {
                if (parameter instanceof ParameterDataObject) {
                    IRasterLayer[] objs = null;
                    if (parameter instanceof ParameterRasterLayer) {
                        objs = SextanteGUI.getInputFactory().getRasterLayers();
                    } else if (parameter instanceof Parameter3DRasterLayer) {
                        objs = SextanteGUI.getInputFactory().get3DRasterLayers();
                    } else if (parameter instanceof ParameterVectorLayer) {
                        AdditionalInfoVectorLayer ai = (AdditionalInfoVectorLayer)((ParameterVectorLayer)parameter).getParameterAdditionalInfo();
                        objs = SextanteGUI.getInputFactory().getVectorLayers(ai.getShapeType());
                    } else if (parameter instanceof ParameterRasterLayer) {
                        objs = SextanteGUI.getInputFactory().getTables();
                    }
                    if (objs != null) {
                        return objs[0];
                    }
                    return "";
                }
                if (parameter instanceof ParameterBand) {
                    return "1";
                }
                if (parameter instanceof ParameterBoolean) {
                    return "true";
                }
                if (parameter instanceof ParameterSelection) {
                    AdditionalInfoSelection ai = (AdditionalInfoSelection)parameter.getParameterAdditionalInfo();
                    return ai.getValues()[0];
                }
                if (parameter instanceof ParameterString) {
                    AdditionalInfoString ai = (AdditionalInfoString)parameter.getParameterAdditionalInfo();
                    return ai.getDefaultString();
                }
                if (parameter instanceof ParameterNumericalValue) {
                    AdditionalInfoNumericalValue ai = (AdditionalInfoNumericalValue)parameter.getParameterAdditionalInfo();
                    return Double.toString(ai.getDefaultValue());
                }
                return "";
            }
            catch (Exception e) {
                return "";
            }
        }
        return Sextante.getText((String)"[Save_to_temporary_file]");
    }
}

