/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.batch.nonFileBased;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.batch.nonFileBased.PointSelectionPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class PointSelectionDialog
extends JDialog {
    private JPanel jPanelMain;
    private JSeparator jSeparator;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private final Point2D m_Point;
    private PointSelectionPanel pointPanel;
    private boolean m_bOK = false;

    public PointSelectionDialog(Frame window, Point2D pt) {
        super(window, "", true);
        this.setResizable(false);
        this.m_Point = pt;
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle(Sextante.getText((String)"point"));
            this.jPanelMain = new JPanel();
            this.getContentPane().add((Component)this.jPanelMain, "Center");
            this.jPanelMain.setPreferredSize(new Dimension(300, 90));
            this.pointPanel = new PointSelectionPanel();
            this.pointPanel.setPreferredSize(new Dimension(250, 20));
            this.jPanelMain.add(this.pointPanel);
            this.jSeparator = new JSeparator();
            this.jPanelMain.add(this.jSeparator);
            this.jSeparator.setPreferredSize(new Dimension(250, 20));
            this.jButtonOK = new JButton();
            this.jPanelMain.add(this.jButtonOK);
            this.jButtonOK.setText(Sextante.getText((String)"OK"));
            this.jButtonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PointSelectionDialog.this.btnOKActionPerformed(evt);
                }
            });
            this.jButtonCancel = new JButton();
            this.jPanelMain.add(this.jButtonCancel);
            this.jButtonCancel.setText(Sextante.getText((String)"Cancel"));
            this.jButtonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PointSelectionDialog.this.btnCancelActionPerformed(evt);
                }
            });
            this.setSize(350, 100);
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        Point2D pt = this.pointPanel.getPoint();
        if (pt == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        this.m_Point.setLocation(pt);
        this.m_bOK = true;
        this.dispose();
        this.setVisible(false);
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.m_bOK = false;
        this.dispose();
        this.setVisible(false);
    }

    public boolean getOK() {
        return this.m_bOK;
    }
}

