/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.cmd;

import es.unex.sextante.additionalInfo.AdditionalInfoBand;
import es.unex.sextante.additionalInfo.AdditionalInfoDataObject;
import es.unex.sextante.additionalInfo.AdditionalInfoFixedTable;
import es.unex.sextante.additionalInfo.AdditionalInfoMultipleInput;
import es.unex.sextante.additionalInfo.AdditionalInfoSelection;
import es.unex.sextante.additionalInfo.AdditionalInfoTableField;
import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IDataObject;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.gui.cmd.CommandLineData;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.exceptions.AlgorithmNotFoundException;
import es.unex.sextante.gui.exceptions.CommandLineException;
import es.unex.sextante.gui.exceptions.OutputExtentNotSetException;
import es.unex.sextante.gui.exceptions.WrongNumberOfParametersException;
import es.unex.sextante.outputs.FileOutputChannel;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.Output3DRasterLayer;
import es.unex.sextante.outputs.OutputRasterLayer;
import es.unex.sextante.outputs.OutputTable;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.outputs.OverwriteOutputChannel;
import es.unex.sextante.parameters.FixedTableModel;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.ParameterBand;
import es.unex.sextante.parameters.ParameterBoolean;
import es.unex.sextante.parameters.ParameterDataObject;
import es.unex.sextante.parameters.ParameterFixedTable;
import es.unex.sextante.parameters.ParameterMultipleInput;
import es.unex.sextante.parameters.ParameterNumericalValue;
import es.unex.sextante.parameters.ParameterPoint;
import es.unex.sextante.parameters.ParameterRasterLayer;
import es.unex.sextante.parameters.ParameterSelection;
import es.unex.sextante.parameters.ParameterString;
import es.unex.sextante.parameters.ParameterTable;
import es.unex.sextante.parameters.ParameterTableField;
import es.unex.sextante.parameters.ParameterVectorLayer;
import es.unex.sextante.parameters.RasterLayerAndBand;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Parser {
    public static GeoAlgorithm getAlgorithm(String sAlgName, String[] args) throws CommandLineException {
        GeoAlgorithm alg;
        GeoAlgorithm algorithm = Sextante.getAlgorithmFromCommandLineName((String)sAlgName);
        if (algorithm == null) {
            throw new AlgorithmNotFoundException();
        }
        try {
            alg = algorithm.getNewInstance();
        }
        catch (Exception e) {
            throw new CommandLineException("Could not instantiate algorithm");
        }
        int iParamCount = alg.getNumberOfParameters() + alg.getNumberOfOutputObjects();
        if (args == null || args.length != iParamCount) {
            throw new WrongNumberOfParametersException();
        }
        ParametersSet ps = alg.getParameters();
        for (int j = 0; j < 2; ++j) {
            String sValue;
            int i;
            for (i = 0; i < alg.getNumberOfParameters(); ++i) {
                Parameter param = ps.getParameter(i);
                if (Parser.setParameter(alg, param, sValue = args[i].trim()) || j != 1) continue;
                throw new CommandLineException("Invalid parameter: " + sValue);
            }
            OutputObjectsSet ooSet = alg.getOutputObjects();
            for (i = 0; i < ooSet.getOutputObjectsCount(); ++i) {
                Output out = ooSet.getOutput(i);
                if (!(out instanceof Output3DRasterLayer) && !(out instanceof OutputRasterLayer) && !(out instanceof OutputVectorLayer) && !(out instanceof OutputTable)) continue;
                sValue = args[i + alg.getNumberOfParameters()].trim();
                if (sValue.equals("@")) {
                    if (out instanceof OutputVectorLayer) {
                        OutputVectorLayer ovl = (OutputVectorLayer)out;
                        if (ovl.canOverwrite()) {
                            try {
                                Parameter paramToOverwrite = alg.getParameters().getParameter(((OutputVectorLayer)out).getInputLayerToOverwrite());
                                IVectorLayer layerToOverwrite = paramToOverwrite.getParameterValueAsVectorLayer();
                                out.setOutputChannel((IOutputChannel)new OverwriteOutputChannel(layerToOverwrite));
                            }
                            catch (Exception e) {
                                out.setOutputChannel((IOutputChannel)new FileOutputChannel(null));
                            }
                        } else {
                            out.setOutputChannel((IOutputChannel)new FileOutputChannel(null));
                        }
                    }
                } else if (sValue.equals("#")) {
                    out.setOutputChannel((IOutputChannel)new FileOutputChannel(null));
                } else {
                    out.setOutputChannel((IOutputChannel)new FileOutputChannel(sValue.trim()));
                }
                ++i;
            }
        }
        if (Parser.adjustOutputExtent(alg)) {
            return alg;
        }
        throw new OutputExtentNotSetException();
    }

    private static boolean adjustOutputExtent(GeoAlgorithm alg) {
        if (!alg.getUserCanDefineAnalysisExtent()) {
            return true;
        }
        if (CommandLineData.getAutoExtent()) {
            if (!alg.adjustOutputExtent()) {
                return false;
            }
        } else {
            AnalysisExtent ge = CommandLineData.getAnalysisExtent();
            if (ge != null) {
                alg.setAnalysisExtent(ge);
            } else {
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean setParameter(GeoAlgorithm alg, Parameter param, String sValue) {
        try {
            AdditionalInfoBand ai;
            String sParentName;
            if (param instanceof ParameterDataObject) {
                if (!sValue.equals("#")) {
                    IDataObject obj = SextanteGUI.getInputFactory().getInputFromName(sValue);
                    if (obj == null) return false;
                    if (param instanceof ParameterVectorLayer) {
                        if (param.setParameterValue((Object)obj)) return param.isParameterValueCorrect();
                        return false;
                    } else if (param instanceof ParameterRasterLayer) {
                        param.setParameterValue((Object)obj);
                        return param.isParameterValueCorrect();
                    } else {
                        if (!(param instanceof ParameterTable)) return param.isParameterValueCorrect();
                        param.setParameterValue((Object)obj);
                        return param.isParameterValueCorrect();
                    }
                } else {
                    AdditionalInfoDataObject ai2 = (AdditionalInfoDataObject)param.getParameterAdditionalInfo();
                    if (ai2.getIsMandatory()) {
                        return false;
                    }
                    param.setParameterValue(null);
                }
                return param.isParameterValueCorrect();
            }
            if (param instanceof ParameterNumericalValue) {
                if (sValue.equals("#")) return param.isParameterValueCorrect();
                param.setParameterValue((Object)new Double(Double.parseDouble(sValue)));
                return param.isParameterValueCorrect();
            }
            if (param instanceof ParameterString) {
                if (sValue.equals("#")) return param.isParameterValueCorrect();
                param.setParameterValue((Object)sValue);
                return param.isParameterValueCorrect();
            }
            if (param instanceof ParameterString) {
                param.setParameterValue((Object)sValue);
                return param.isParameterValueCorrect();
            }
            if (param instanceof ParameterFixedTable) {
                return Parser.setParameterFixedTable(param, sValue);
            }
            if (param instanceof ParameterBoolean) {
                boolean bValue;
                if (sValue.equals("#")) return param.isParameterValueCorrect();
                if (sValue.equals("true")) {
                    bValue = true;
                } else {
                    if (!sValue.equals("false")) return false;
                    bValue = false;
                }
                param.setParameterValue((Object)new Boolean(bValue));
                return param.isParameterValueCorrect();
            }
            if (param instanceof ParameterSelection) {
                if (sValue.equals("#")) return param.isParameterValueCorrect();
                int iIndex = Integer.parseInt(sValue);
                AdditionalInfoSelection ai3 = (AdditionalInfoSelection)param.getParameterAdditionalInfo();
                if (iIndex < 0 || iIndex > ai3.getValues().length - 1) {
                    return false;
                }
                param.setParameterValue((Object)new Integer(Integer.parseInt(sValue)));
                return param.isParameterValueCorrect();
            }
            if (param instanceof ParameterMultipleInput) {
                if (!sValue.equals("#")) {
                    return Parser.setParameterMultipleInput(param, sValue);
                }
                AdditionalInfoMultipleInput ai4 = (AdditionalInfoMultipleInput)param.getParameterAdditionalInfo();
                if (ai4.getIsMandatory()) {
                    return false;
                }
                param.setParameterValue(new ArrayList());
                return param.isParameterValueCorrect();
            }
            if (param instanceof ParameterPoint) {
                StringTokenizer st = new StringTokenizer(sValue, ",");
                if (st.countTokens() != 2) {
                    return false;
                }
                double x = Double.parseDouble(st.nextToken());
                double y = Double.parseDouble(st.nextToken());
                param.setParameterValue((Object)new Point2D.Double(x, y));
                return param.isParameterValueCorrect();
            }
            if (param instanceof ParameterTableField) {
                String[] sNames;
                AdditionalInfoTableField ai5;
                String sParentName2;
                ParametersSet ps = alg.getParameters();
                Parameter parent = ps.getParameter(sParentName2 = (ai5 = (AdditionalInfoTableField)param.getParameterAdditionalInfo()).getParentParameterName());
                if (parent == null) {
                    return false;
                }
                if (parent instanceof ParameterVectorLayer) {
                    IVectorLayer vect = parent.getParameterValueAsVectorLayer();
                    sNames = vect.getFieldNames();
                } else {
                    if (!(parent instanceof ParameterTable)) return false;
                    ITable table = parent.getParameterValueAsTable();
                    sNames = table.getFieldNames();
                }
                int iIndex = -1;
                try {
                    iIndex = Integer.parseInt(sValue);
                }
                catch (NumberFormatException nfe) {
                    for (int i = 0; i < sNames.length; ++i) {
                        if (!sValue.equals(sNames[i])) continue;
                        iIndex = i;
                        break;
                    }
                }
                if (iIndex < 0 || iIndex >= sNames.length) return false;
                param.setParameterValue((Object)new Integer(iIndex));
                return param.isParameterValueCorrect();
            }
            if (!(param instanceof ParameterBand)) return param.isParameterValueCorrect();
            ParametersSet ps = alg.getParameters();
            Parameter parent = ps.getParameter(sParentName = (ai = (AdditionalInfoBand)param.getParameterAdditionalInfo()).getParentParameterName());
            if (parent == null) {
                return false;
            }
            if (!(parent instanceof ParameterRasterLayer)) return false;
            IRasterLayer raster = parent.getParameterValueAsRasterLayer();
            int iIndex = Integer.parseInt(sValue);
            if (iIndex <= 0 || iIndex > raster.getBandsCount()) return false;
            param.setParameterValue((Object)new Integer(iIndex - 1));
            return param.isParameterValueCorrect();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean setParameterFixedTable(Parameter param, String sValue) {
        int iToken = 0;
        StringTokenizer st = new StringTokenizer(sValue, ",");
        try {
            AdditionalInfoFixedTable ai = (AdditionalInfoFixedTable)param.getParameterAdditionalInfo();
            int iCols = ai.getColsCount();
            int iRows = st.countTokens() / iCols;
            boolean bIsNumberOfRowsFixed = ai.isNumberOfRowsFixed();
            FixedTableModel tableModel = new FixedTableModel(ai.getCols(), iRows, bIsNumberOfRowsFixed);
            if (bIsNumberOfRowsFixed ? iRows != ai.getRowsCount() : st.countTokens() % iCols != 0) {
                return false;
            }
            while (st.hasMoreTokens()) {
                int iRow = (int)Math.floor((double)iToken / (double)iCols);
                int iCol = iToken % iCols;
                String sToken = st.nextToken().trim();
                tableModel.setValueAt((Object)sToken, iRow, iCol);
                ++iToken;
            }
            param.setParameterValue((Object)tableModel);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean setParameterMultipleInput(Parameter param, String sValue) {
        ArrayList<IDataObject> array = new ArrayList<IDataObject>();
        StringTokenizer st = new StringTokenizer(sValue, ",");
        IDataObject obj = null;
        try {
            AdditionalInfoMultipleInput ai = (AdditionalInfoMultipleInput)param.getParameterAdditionalInfo();
            int iType = ai.getDataType();
            while (st.hasMoreTokens()) {
                String sToken = st.nextToken().trim();
                if (iType == 1) {
                    obj = SextanteGUI.getInputFactory().getInputFromName(sToken);
                } else if (iType == 5) {
                    obj = SextanteGUI.getInputFactory().getInputFromName(sToken);
                } else if (iType == 3) {
                    obj = SextanteGUI.getInputFactory().getInputFromName(sToken);
                    if (((IVectorLayer)obj).getShapeType() != 1) {
                        return false;
                    }
                } else if (iType == 4) {
                    obj = SextanteGUI.getInputFactory().getInputFromName(sToken);
                    if (((IVectorLayer)obj).getShapeType() != 2) {
                        return false;
                    }
                } else if (iType == 2) {
                    obj = SextanteGUI.getInputFactory().getInputFromName(sToken);
                    if (((IVectorLayer)obj).getShapeType() != 2) {
                        return false;
                    }
                } else if (iType == 6) {
                    obj = SextanteGUI.getInputFactory().getInputFromName(sToken);
                } else {
                    if (iType != 7) return false;
                    obj = SextanteGUI.getInputFactory().getInputFromName(sToken);
                    sToken = st.nextToken().trim();
                    int iBand = Integer.parseInt(sToken) - 1;
                    if (obj != null) {
                        if (iBand < 0 || iBand >= ((IRasterLayer)obj).getBandsCount()) return false;
                        obj = new RasterLayerAndBand((IRasterLayer)obj, iBand);
                    }
                }
                if (obj == null) {
                    return false;
                }
                array.add(obj);
            }
            param.setParameterValue(array);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

