/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.help;

import es.unex.sextante.gui.help.ImageAndDescription;
import java.io.IOException;
import java.util.ArrayList;
import org.kxml2.io.KXmlSerializer;

public class HelpElement {
    private String m_sName = "";
    private ArrayList m_Images = new ArrayList();
    private String m_sDescription = "";
    private String m_sText = "";
    private int m_iType = 0;
    public static final int TYPE_ADDITIONAL_INFO = 0;
    public static final int TYPE_INPUT = 1;
    public static final int TYPE_OUTPUT = 2;
    public static final int TYPE_PARAMETER = 3;
    public static final String ELEMENT = "element";
    public static final String NAME = "name";
    public static final String TEXT = "text";
    public static final String TYPE = "type";
    public static final String DESCRIPTION = "description";

    public HelpElement(String sName, String sDescription, int iType) {
        this.m_sName = sName;
        this.m_sDescription = sDescription;
        this.m_iType = iType;
    }

    public HelpElement() {
    }

    public ArrayList getImages() {
        return this.m_Images;
    }

    public void setImages(ArrayList images) {
        this.m_Images = images;
    }

    public String getText() {
        return this.m_sText;
    }

    public String getTextAsFormattedHTML() {
        boolean bList = false;
        boolean bListElement = false;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.m_sText.length(); ++i) {
            char c = this.m_sText.charAt(i);
            if (c == '*') {
                if (!bList) {
                    sb.append("<ul>");
                }
                sb.append("<li>");
                bListElement = true;
                bList = true;
                continue;
            }
            if (c == '\n') {
                sb.append("<br>");
                bListElement = false;
                continue;
            }
            if (bList && !bListElement) {
                sb.append("</ul>");
                bList = false;
            }
            sb.append(c);
        }
        sb.append("\n");
        if (bList) {
            sb.append("</ul>");
        }
        return sb.toString();
    }

    public String getTextForTooltip() {
        int MAX_CHARS = 60;
        int iChars = 0;
        boolean bList = false;
        boolean bListElement = false;
        StringBuffer sb = new StringBuffer("<html>");
        for (int i = 0; i < this.m_sText.length(); ++i) {
            char c = this.m_sText.charAt(i);
            if (c == '*') {
                if (!bList) {
                    sb.append("<ul>");
                }
                sb.append("<li>");
                bListElement = true;
                bList = true;
                continue;
            }
            if (c == '\n') {
                sb.append("<br>");
                bListElement = false;
                continue;
            }
            if (c == ' ') {
                sb.append(c);
                if (iChars > 60) {
                    iChars = 0;
                    sb.append("<br>");
                    continue;
                }
                ++iChars;
                continue;
            }
            if (bList && !bListElement) {
                sb.append("</ul>");
                bList = false;
            }
            sb.append(c);
        }
        sb.append("\n</html>");
        if (bList) {
            sb.append("</ul>");
        }
        return sb.toString();
    }

    public void setText(String text) {
        this.m_sText = text;
    }

    public String getDescription() {
        return this.m_sDescription;
    }

    public void setDescription(String description) {
        this.m_sDescription = description;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String name) {
        this.m_sName = name;
    }

    public int getType() {
        return this.m_iType;
    }

    public void setType(int type) {
        this.m_iType = type;
    }

    public String toString() {
        return this.m_sDescription;
    }

    public void serialize(KXmlSerializer serializer) throws IOException {
        serializer.text("\n");
        serializer.text("\t\t");
        serializer.startTag(null, ELEMENT);
        serializer.attribute(null, NAME, this.m_sName);
        serializer.attribute(null, TEXT, this.m_sText);
        serializer.attribute(null, DESCRIPTION, this.m_sDescription);
        serializer.attribute(null, TYPE, Integer.toString(this.m_iType));
        for (int i = 0; i < this.m_Images.size(); ++i) {
            ((ImageAndDescription)this.m_Images.get(i)).serialize(serializer);
        }
        serializer.text("\n");
        serializer.text("\t\t");
        serializer.endTag(null, ELEMENT);
    }
}

