/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.modeler;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.exceptions.ModelIOException;
import es.unex.sextante.gui.modeler.ModelAlgorithm;
import es.unex.sextante.gui.modeler.ModelCodeCreator;
import es.unex.sextante.gui.modeler.ModelerPanel;
import es.unex.sextante.modeler.elements.ModelElement3DRasterLayer;
import es.unex.sextante.modeler.elements.ModelElementFactory;
import es.unex.sextante.modeler.elements.ModelElementNumericalValue;
import es.unex.sextante.modeler.elements.ModelElementRasterLayer;
import es.unex.sextante.modeler.elements.ModelElementTable;
import es.unex.sextante.modeler.elements.ModelElementVectorLayer;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.Output3DRasterLayer;
import es.unex.sextante.outputs.OutputRasterLayer;
import es.unex.sextante.outputs.OutputTable;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.parameters.FixedTableModel;
import es.unex.sextante.parameters.Parameter;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;

public class ModelAlgorithmIO {
    private static String encoding = "ISO-8859-1";
    private static final String MODEL = "model";
    private static final String NAME = "name";
    private static final String GROUP = "group";
    private static final String CLASS = "class";
    private static final String MODEL_FILE = "model_file";
    private static final String WPS_URL = "wps_url";
    private static final String WPS_PROCESS_IDENTIFIER = "wps_process_id";
    private static final String GRASS_PROCESS_IDENTIFIER = "grass_process_id";
    private static final String DESCRIPTION = "description";
    private static final String RED = "red";
    private static final String GREEN = "green";
    private static final String BLUE = "blue";
    private static final String ALPHA = "alpha";
    private static final String ALGORITHM = "algorithm";
    private static final String DATA_OBJECT = "data_object";
    private static final String ASSIGNMENT = "assignment";
    private static final String ASSIGNEDTO = "assigned_to";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String INPUT = "input";
    private static final String COORDS = "coords";
    private static final String OUTPUT = "output";
    private static final String ALG_CMD_LINE_NAME = "alg_cmd_line_name";

    public static boolean saveAsJava(ModelAlgorithm alg, File file) {
        try {
            FileWriter writer = new FileWriter(file);
            BufferedWriter out = new BufferedWriter(writer);
            out.write(ModelCodeCreator.getJavaCode(alg));
            out.close();
            writer.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean save(ModelerPanel panel, File file) {
        FileWriter writer = null;
        ModelAlgorithm modelAlg = panel.getAlgorithm();
        try {
            String sKey2;
            int i;
            writer = new FileWriter(file);
            KXmlSerializer serializer = new KXmlSerializer();
            serializer.setOutput((Writer)writer);
            serializer.startDocument(encoding, new Boolean(true));
            serializer.text("\n\t");
            serializer.startTag(null, MODEL);
            serializer.attribute(null, NAME, modelAlg.getName());
            serializer.attribute(null, GROUP, modelAlg.getGroup());
            ArrayList algKeys = modelAlg.getAlgorithmKeys();
            ArrayList algs2 = modelAlg.getAlgorithms();
            ParametersSet ps = modelAlg.getParameters();
            HashMap dao = panel.getDataObjects();
            ArrayList assignmentsArray = modelAlg.getInputAssignments();
            for (i = 0; i < algs2.size(); ++i) {
                GeoAlgorithm alg = (GeoAlgorithm)algs2.get(i);
                serializer.text("\n");
                serializer.text("\t\t");
                serializer.startTag(null, ALGORITHM);
                sKey2 = (String)algKeys.get(i);
                serializer.attribute(null, KEY, sKey2);
                serializer.attribute(null, ALG_CMD_LINE_NAME, alg.getCommandLineName());
                serializer.attribute(null, DESCRIPTION, alg.getDescription());
                serializer.attribute(null, RED, Integer.toString(alg.getColorR()));
                serializer.attribute(null, GREEN, Integer.toString(alg.getColorG()));
                serializer.attribute(null, BLUE, Integer.toString(alg.getColorB()));
                serializer.attribute(null, ALPHA, Integer.toString(alg.getColorAlpha()));
                serializer.attribute(null, COORDS, ModelAlgorithmIO.getCoordsAsString(panel.getModelGraphPanel().getCoords(), sKey2));
                HashMap assignments = (HashMap)assignmentsArray.get(i);
                Set set = assignments.keySet();
                for (String sKey2 : set) {
                    serializer.text("\n");
                    serializer.text("\t\t\t");
                    serializer.startTag(null, ASSIGNMENT);
                    serializer.attribute(null, KEY, sKey2);
                    String sAssignment = (String)assignments.get(sKey2);
                    if (sAssignment == null) {
                        sAssignment = "null";
                    }
                    serializer.attribute(null, ASSIGNEDTO, sAssignment);
                    serializer.endTag(null, ASSIGNMENT);
                }
                serializer.text("\n");
                serializer.text("\t\t");
                serializer.endTag(null, ALGORITHM);
            }
            int iCount = ps.getNumberOfParameters();
            for (i = 0; i < iCount; ++i) {
                sKey2 = ps.getParameter(i).getParameterName();
                String sCoords = ModelAlgorithmIO.getCoordsAsString(panel.getModelGraphPanel().getCoords(), sKey2);
                ps.getParameter(i).serialize(serializer, sCoords);
            }
            Set set = dao.keySet();
            for (String sKey3 : set) {
                if (sKey3.indexOf("INPUT") == 0) continue;
                ObjectAndDescription oad = (ObjectAndDescription)dao.get(sKey3);
                serializer.text("\n");
                serializer.text("\t\t");
                serializer.startTag(null, DATA_OBJECT);
                serializer.attribute(null, KEY, sKey3);
                String sValue = ModelAlgorithmIO.getValueAsString(oad.getObject());
                serializer.attribute(null, VALUE, sValue);
                serializer.attribute(null, DESCRIPTION, oad.getDescription());
                serializer.endTag(null, DATA_OBJECT);
            }
            OutputObjectsSet ooSet = modelAlg.getOutputObjects();
            for (int j = 0; j < ooSet.getOutputObjectsCount(); ++j) {
                Output out = ooSet.getOutput(j);
                serializer.text("\n");
                serializer.text("\t\t");
                serializer.startTag(null, OUTPUT);
                serializer.attribute(null, KEY, out.getName());
                serializer.attribute(null, CLASS, out.getClass().toString());
                serializer.attribute(null, DESCRIPTION, out.getDescription());
                serializer.endTag(null, OUTPUT);
            }
            serializer.text("\n");
            serializer.text("\t");
            serializer.endTag(null, MODEL);
            serializer.text("\n");
            ((Writer)writer).close();
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        try {
            ((Writer)writer).close();
        }
        catch (IOException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        return true;
    }

    private static String getCoordsAsString(HashMap coords, String sKey) {
        Rectangle2D rect = (Rectangle2D)coords.get(sKey);
        if (rect == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer("");
        sb.append(Integer.toString((int)rect.getMinX()));
        sb.append(",");
        sb.append(Integer.toString((int)rect.getMinY()));
        sb.append(",");
        sb.append(Integer.toString((int)rect.getWidth()));
        sb.append(",");
        sb.append(Integer.toString((int)rect.getHeight()));
        return sb.toString();
    }

    private static String getValueAsString(Object ob) {
        if (ob.getClass().equals(ArrayList.class)) {
            ArrayList array = (ArrayList)ob;
            StringBuffer s = new StringBuffer();
            for (int i = 0; i < array.size(); ++i) {
                s.append((String)array.get(i));
                if (i >= array.size() - 1) continue;
                s.append(",");
            }
            return s.toString();
        }
        return ob.toString();
    }

    public static ModelAlgorithm open(File file, HashMap dao, ArrayList inputKeys, HashMap coords) {
        ModelAlgorithm model = new ModelAlgorithm();
        KXmlParser parser = new KXmlParser();
        ParametersSet ps = model.getParameters();
        GeoAlgorithm alg = null;
        String sAlgName = null;
        String sAlgDescription = null;
        String sAlgRed = null;
        String sAlgGreen = null;
        String sAlgBlue = null;
        String sAlgAlpha = null;
        Object sInputRed = null;
        Object sInputGreen = null;
        Object sInputBlue = null;
        Object sInputAlpha = null;
        OutputObjectsSet ooSet = model.getOutputObjects();
        model.setFilename(file.getAbsolutePath());
        try {
            parser.setInput((InputStream)new FileInputStream(file), encoding);
            int tag = parser.nextTag();
            boolean bOut = false;
            String sColorRed = null;
            String sColorGreen = null;
            String sColorBlue = null;
            String sColorAlpha = null;
            if (parser.getEventType() != 1) {
                while (tag != 1 && !bOut) {
                    switch (tag) {
                        case 2: {
                            String sDescription;
                            String sValue;
                            String sKey;
                            String sCoords;
                            if (parser.getName().compareTo(MODEL) == 0) {
                                String sName = parser.getAttributeValue("", NAME);
                                model.setName(sName);
                                String sGroup = parser.getAttributeValue("", GROUP);
                                model.setGroup(sGroup);
                                break;
                            }
                            if (parser.getName().compareTo(ALGORITHM) == 0) {
                                alg = ModelAlgorithmIO.getAlgorithm(parser.getAttributeValue("", ALG_CMD_LINE_NAME));
                                sAlgName = parser.getAttributeValue("", KEY);
                                sCoords = parser.getAttributeValue("", COORDS);
                                if (alg == null) {
                                    throw new ModelIOException();
                                }
                                sAlgDescription = parser.getAttributeValue("", DESCRIPTION);
                                if (sAlgDescription != null) {
                                    alg.setDescription(sAlgDescription);
                                } else {
                                    alg.setDescription(alg.getName());
                                }
                                sAlgRed = parser.getAttributeValue("", RED);
                                if (sAlgRed != null) {
                                    alg.setColorR(Integer.parseInt(sAlgRed));
                                }
                                if ((sAlgGreen = parser.getAttributeValue("", GREEN)) != null) {
                                    alg.setColorG(Integer.parseInt(sAlgGreen));
                                }
                                if ((sAlgBlue = parser.getAttributeValue("", BLUE)) != null) {
                                    alg.setColorB(Integer.parseInt(sAlgBlue));
                                }
                                if ((sAlgAlpha = parser.getAttributeValue("", ALPHA)) != null) {
                                    alg.setColorAlpha(Integer.parseInt(sAlgAlpha));
                                }
                                model.addAlgorithm(alg, sAlgName);
                                if (sCoords.equals("null")) break;
                                coords.put(sAlgName, ModelAlgorithmIO.getCoordsFromString(sCoords));
                                break;
                            }
                            if (parser.getName().compareTo(DATA_OBJECT) == 0) {
                                sKey = parser.getAttributeValue("", KEY);
                                sValue = parser.getAttributeValue("", VALUE);
                                sDescription = parser.getAttributeValue("", DESCRIPTION);
                                ModelAlgorithmIO.addDataObject(sKey, sValue, sDescription, dao);
                                break;
                            }
                            if (parser.getName().compareTo(OUTPUT) == 0) {
                                sKey = parser.getAttributeValue("", KEY);
                                sValue = parser.getAttributeValue("", CLASS);
                                sDescription = parser.getAttributeValue("", DESCRIPTION);
                                ModelAlgorithmIO.addOutputObject(sKey, sValue, sDescription, ooSet, dao);
                                break;
                            }
                            if (parser.getName().compareTo(INPUT) == 0) {
                                sCoords = parser.getAttributeValue("", COORDS);
                                Rectangle2D rect = null;
                                if (!sCoords.equals("null")) {
                                    rect = ModelAlgorithmIO.getCoordsFromString(sCoords);
                                }
                                sColorRed = parser.getAttributeValue("", RED);
                                sColorGreen = parser.getAttributeValue("", GREEN);
                                sColorBlue = parser.getAttributeValue("", BLUE);
                                sColorAlpha = parser.getAttributeValue("", ALPHA);
                                Parameter param = Parameter.deserialize((KXmlParser)parser);
                                if (param == null) {
                                    return null;
                                }
                                if (sColorRed != null) {
                                    param.setColorR(Integer.parseInt(sColorRed));
                                }
                                if (sColorGreen != null) {
                                    param.setColorG(Integer.parseInt(sColorGreen));
                                }
                                if (sColorBlue != null) {
                                    param.setColorB(Integer.parseInt(sColorBlue));
                                }
                                if (sColorAlpha != null) {
                                    param.setColorAlpha(Integer.parseInt(sColorAlpha));
                                }
                                ps.addParameter(param);
                                inputKeys.add(param.getParameterName());
                                ObjectAndDescription oad = new ObjectAndDescription(param.getParameterDescription(), (Object)ModelElementFactory.getParameterAsModelElement((Parameter)param));
                                dao.put(param.getParameterName(), oad);
                                if (rect == null) break;
                                coords.put(param.getParameterName(), ModelAlgorithmIO.getCoordsFromString(sCoords));
                                break;
                            }
                            if (parser.getName().compareTo(ASSIGNMENT) != 0) break;
                            sKey = parser.getAttributeValue("", KEY);
                            String sAssignment = parser.getAttributeValue("", ASSIGNEDTO);
                            if (sAssignment.equals("null")) {
                                sAssignment = null;
                            }
                            model.addInputAsignment(sKey, sAssignment, sAlgName);
                            break;
                        }
                        case 3: {
                            if (parser.getName().compareTo(MODEL) != 0) break;
                            bOut = true;
                            break;
                        }
                    }
                    if (bOut) continue;
                    tag = parser.next();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Sextante.addErrorToLog((Throwable)e);
            return null;
        }
        return model;
    }

    private static void addOutputObject(String sKey, String sValue, String sDescription, OutputObjectsSet ooSet, HashMap dao) {
        OutputRasterLayer out = null;
        if (sValue.equals(OutputRasterLayer.class.toString())) {
            out = new OutputRasterLayer();
        } else if (sValue.equals(Output3DRasterLayer.class.toString())) {
            out = new Output3DRasterLayer();
        } else if (sValue.equals(OutputVectorLayer.class.toString())) {
            out = new OutputVectorLayer();
            ObjectAndDescription oad = (ObjectAndDescription)dao.get(sKey);
            if (oad != null) {
                ModelElementVectorLayer mevl = (ModelElementVectorLayer)oad.getObject();
                ((OutputVectorLayer)out).setShapeType(mevl.getShapeType());
            }
        } else if (sValue.equals(OutputTable.class.toString())) {
            out = new OutputTable();
        } else {
            return;
        }
        out.setDescription(sDescription);
        out.setName(sKey);
        ooSet.add((Output)out);
    }

    public static ModelAlgorithm open(File file, ModelerPanel panel) {
        HashMap dao = panel.getDataObjects();
        ArrayList inputKeys = panel.getInputKeys();
        HashMap coords = panel.getModelGraphPanel().getCoords();
        panel.getModelGraphPanel().resetCoords();
        ModelAlgorithm model = ModelAlgorithmIO.open(file, dao, inputKeys, coords);
        panel.getModelGraphPanel().setAlgorithm(model);
        return model;
    }

    private static Rectangle2D getCoordsFromString(String sCoords) {
        Rectangle2D.Double rect = new Rectangle2D.Double();
        String[] coords = sCoords.split("\\,");
        ((Rectangle2D)rect).setRect(Double.parseDouble(coords[0]), Double.parseDouble(coords[1]), Double.parseDouble(coords[2]), Double.parseDouble(coords[3]));
        return rect;
    }

    private static void addDataObject(String sKey, String sValue, String sDescription, HashMap dao) {
        if (sKey.indexOf("INNERPARAM") == 0) {
            if (sDescription.equals("Numerical Value")) {
                if (sValue.indexOf(".") != -1) {
                    dao.put(sKey, new ObjectAndDescription(sDescription, (Object)new Double(Double.parseDouble(sValue))));
                } else {
                    dao.put(sKey, new ObjectAndDescription(sDescription, (Object)new Integer(Integer.parseInt(sValue))));
                }
            }
            if (sDescription.equals("String") || sDescription.equals("Field") || sDescription.equals("Filepath")) {
                dao.put(sKey, new ObjectAndDescription(sDescription, (Object)sValue));
            } else if (sDescription.equals("Selection") || sDescription.equals("Band")) {
                dao.put(sKey, new ObjectAndDescription(sDescription, (Object)new Integer(Integer.parseInt(sValue))));
            } else if (sDescription.equals("Multiple Input")) {
                ArrayList<String> array = new ArrayList<String>();
                String[] sElements = sValue.split("\\,");
                for (int i = 0; i < sElements.length; ++i) {
                    array.add(sElements[i]);
                }
                dao.put(sKey, new ObjectAndDescription(sDescription, array));
            } else if (sDescription.equals("Fixed Table")) {
                String[] sRows = sValue.split("\\,");
                int iRows = sRows.length;
                String[] data2 = sRows[0].split("\\|");
                int iCols = data2.length;
                String[] sColNames = new String[iCols];
                for (int i = 0; i < iCols; ++i) {
                    sColNames[i] = Integer.toString(i + 1);
                }
                FixedTableModel ftm = new FixedTableModel(sColNames, iRows, false);
                for (int i = 0; i < iRows; ++i) {
                    String sRow = sRows[i].replaceAll("\\[", "");
                    sRow = sRow.replaceAll("\\]", "");
                    data2 = sRow.split("\\|");
                    for (int j = 0; j < iCols; ++j) {
                        ftm.setValueAt((Object)data2[j], i, j);
                    }
                }
                dao.put(sKey, new ObjectAndDescription(sDescription, (Object)ftm));
            } else if (sDescription.equals("Point")) {
                String[] sCoords = sValue.split("\\,");
                double x = Double.parseDouble(sCoords[0]);
                double y = Double.parseDouble(sCoords[1]);
                dao.put(sKey, new ObjectAndDescription(sDescription, (Object)new Point2D.Double(x, y)));
            } else if (sDescription.equals("Boolean")) {
                dao.put(sKey, new ObjectAndDescription(sDescription, (Object)new Boolean(sValue.equals("true"))));
            }
        } else if (sKey.indexOf("INPUT") != 0) {
            String[] sTokens = sValue.split(",");
            if (sTokens[0].equals(ModelElementRasterLayer.class.toString())) {
                ModelElementRasterLayer merl = new ModelElementRasterLayer();
                merl.setNumberOfBands(Integer.parseInt(sTokens[1]));
                dao.put(sKey, new ObjectAndDescription(sDescription, (Object)merl));
            } else if (sTokens[0].equals(ModelElementTable.class.toString())) {
                dao.put(sKey, new ObjectAndDescription(sDescription, (Object)new ModelElementTable()));
            } else if (sTokens[0].equals(ModelElement3DRasterLayer.class.toString())) {
                dao.put(sKey, new ObjectAndDescription(sDescription, (Object)new ModelElement3DRasterLayer()));
            } else if (sTokens[0].equals(ModelElementNumericalValue.class.toString())) {
                dao.put(sKey, new ObjectAndDescription(sDescription, (Object)new ModelElementNumericalValue()));
            } else if (sTokens[0].equals(ModelElementVectorLayer.class.toString())) {
                ModelElementVectorLayer mevl = new ModelElementVectorLayer();
                mevl.setShapeType(Integer.parseInt(sTokens[1]));
                dao.put(sKey, new ObjectAndDescription(sDescription, (Object)mevl));
            }
        }
    }

    private static GeoAlgorithm getAlgorithm(String sAlgorithmCommandLineName) {
        try {
            return Sextante.getAlgorithmFromCommandLineName((String)sAlgorithmCommandLineName).getNewInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static GeoAlgorithm loadModelAsAlgorithm(String sFilename) {
        File file = new File(sFilename);
        try {
            if (file.getName().endsWith(MODEL)) {
                HashMap dao = new HashMap();
                ArrayList inputKeys = new ArrayList();
                HashMap coords = new HashMap();
                ModelAlgorithm alg = ModelAlgorithmIO.open(file, dao, inputKeys, coords);
                if (alg != null) {
                    alg.getInputs().clear();
                    Set set = dao.keySet();
                    for (String sKey : set) {
                        ObjectAndDescription oad = (ObjectAndDescription)dao.get(sKey);
                        alg.getInputs().put(sKey, oad.getObject());
                    }
                }
                return alg;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static GeoAlgorithm[] loadModelsAsAlgorithms(String modelsFolder) {
        File folder;
        String[] contents = null;
        ArrayList<ModelAlgorithm> algsArray = new ArrayList<ModelAlgorithm>();
        try {
            folder = new File(modelsFolder);
            contents = folder.list();
        }
        catch (Exception e) {
            return new GeoAlgorithm[0];
        }
        if (contents != null) {
            int i;
            for (i = 0; i < contents.length; ++i) {
                File file = new File(folder, contents[i]);
                try {
                    HashMap coords;
                    ArrayList inputKeys;
                    HashMap dao;
                    ModelAlgorithm alg;
                    if (!file.getName().endsWith(MODEL) || (alg = ModelAlgorithmIO.open(file, dao = new HashMap(), inputKeys = new ArrayList(), coords = new HashMap())) == null) continue;
                    alg.getInputs().clear();
                    Set set = dao.keySet();
                    for (String sKey : set) {
                        ObjectAndDescription oad = (ObjectAndDescription)dao.get(sKey);
                        alg.getInputs().put(sKey, oad.getObject());
                    }
                    algsArray.add(alg);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            GeoAlgorithm[] algs2 = new GeoAlgorithm[algsArray.size()];
            for (i = 0; i < algsArray.size(); ++i) {
                algs2[i] = (GeoAlgorithm)algsArray.get(i);
            }
            return algs2;
        }
        return new GeoAlgorithm[0];
    }
}

