/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.modeler;

import es.unex.sextante.additionalInfo.AdditionalInfo;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.exceptions.WrongParameterIDException;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.modeler.AlgorithmDialog;
import es.unex.sextante.gui.modeler.GeoAlgorithmModelerParametersPanel;
import es.unex.sextante.gui.modeler.ModelAlgorithm;
import es.unex.sextante.gui.modeler.ModelerPanel;
import es.unex.sextante.gui.modeler.parameters.ParameterPanel;
import es.unex.sextante.gui.modeler.parameters.ParameterPanelFactory;
import es.unex.sextante.modeler.elements.ModelElementFactory;
import es.unex.sextante.parameters.Parameter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jgraph.JGraph;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultGraphSelectionModel;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphSelectionModel;

public class ModelGraphPanel
extends JScrollPane {
    private ModelAlgorithm m_Algorithm;
    private final HashMap m_DataObjects;
    private final ArrayList m_InputKeys;
    private JGraph jGraph;
    private DefaultGraphSelectionModel SelectionModel;
    private final Icon m_InputIcon;
    private final Icon m_ProcessIcon;
    private int m_iInputs;
    private final ModelerPanel m_ModelerPanel;
    private JPopupMenu popupMenu;
    private DefaultGraphCell m_ActiveCell = null;
    private final HashMap m_Coords;
    private final JDialog m_Parent;
    private JMenuItem menuItemEdit;
    private static final double d_Opacity = 0.66;

    public ModelGraphPanel(ModelAlgorithm algorithm, HashMap dataObjects, ArrayList inputKeys, ModelerPanel modelerPanel, JDialog parent) {
        this.m_DataObjects = dataObjects;
        this.m_InputKeys = inputKeys;
        this.m_Algorithm = algorithm;
        this.m_ModelerPanel = modelerPanel;
        this.m_Coords = new HashMap();
        this.m_Parent = parent;
        this.m_InputIcon = new ImageIcon(this.getClass().getClassLoader().getResource("images/list-add.png"));
        this.m_ProcessIcon = new ImageIcon(this.getClass().getClassLoader().getResource("images/module2.png"));
        this.setWheelScrollingEnabled(false);
        this.initGUI();
    }

    private void initGUI() {
        this.popupMenu = new JPopupMenu("Menu");
        this.menuItemEdit = new JMenuItem(Sextante.getText((String)"Edit"));
        this.menuItemEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Object ob = ModelGraphPanel.this.m_ActiveCell.getUserObject();
                ModelGraphPanel.this.editCell((ObjectAndDescription)ob);
            }
        });
        this.popupMenu.add(this.menuItemEdit);
        JMenuItem menuItem = new JMenuItem(Sextante.getText((String)"Remove"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Object ob = ModelGraphPanel.this.m_ActiveCell.getUserObject();
                String sKey = (String)((ObjectAndDescription)ob).getObject();
                boolean removed = ModelGraphPanel.this.m_ModelerPanel.removeElement(sKey);
                ModelGraphPanel.this.m_ModelerPanel.setHasChanged(removed);
            }
        });
        this.popupMenu.add(menuItem);
        this.updateGraph();
    }

    @Override
    public void update(Graphics g) {
        super.update(g);
    }

    public void updateGraph() {
        String sKey;
        int i;
        this.m_iInputs = 0;
        this.initGraph();
        for (i = 0; i < this.m_InputKeys.size(); ++i) {
            sKey = (String)this.m_InputKeys.get(i);
            this.addInput(sKey);
        }
        ArrayList algKeys = this.m_Algorithm.getAlgorithmKeys();
        for (i = 0; i < algKeys.size(); ++i) {
            sKey = (String)algKeys.get(i);
            this.addAlgorithm(sKey);
        }
        if (this.m_ModelerPanel.getGridEnabled()) {
            this.jGraph.setGridEnabled(true);
            this.jGraph.setGridVisible(true);
            this.jGraph.setGridSize(this.m_ModelerPanel.getGridSize());
        }
        this.jGraph.setScale(this.m_ModelerPanel.getScale());
        this.setViewportView((Component)this.jGraph);
    }

    public JGraph getGraph() {
        return this.jGraph;
    }

    private void initGraph() {
        DefaultGraphModel model = new DefaultGraphModel();
        this.jGraph = new JGraph((GraphModel)model);
        this.jGraph.setCloneable(false);
        this.jGraph.setInvokesStopCellEditing(true);
        this.jGraph.setJumpToDefaultPort(true);
        this.jGraph.setConnectable(false);
        this.jGraph.setDisconnectable(false);
        this.jGraph.setEditable(false);
        this.jGraph.setAntiAliased(true);
        this.jGraph.setSizeable(true);
        this.jGraph.setEnabled(true);
        this.SelectionModel = new DefaultGraphSelectionModel(this.jGraph);
        this.SelectionModel.setSelectionMode(1);
        this.jGraph.setSelectionModel((GraphSelectionModel)this.SelectionModel);
        this.jGraph.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    ModelGraphPanel.this.showPopupMenu(e);
                    return;
                }
                if (e.getClickCount() == 2) {
                    ModelGraphPanel.this.editCell(e);
                    return;
                }
                int x = e.getX();
                int y = e.getY();
                DefaultGraphCell cell = (DefaultGraphCell)ModelGraphPanel.this.jGraph.getFirstCellForLocation((double)x, (double)y);
                if (cell != null) {
                    ObjectAndDescription oad = (ObjectAndDescription)cell.getUserObject();
                    if (oad != null) {
                        String sKey = (String)oad.getObject();
                        Object usrObj = ModelGraphPanel.this.m_ModelerPanel.getObjectFromKey(sKey);
                        if (usrObj instanceof GeoAlgorithm || usrObj instanceof ObjectAndDescription) {
                            ModelGraphPanel.this.m_ModelerPanel.toggleEditButtons(true, oad);
                            ModelGraphPanel.this.jGraph.scrollCellToVisible((Object)cell);
                        }
                    }
                } else {
                    ModelGraphPanel.this.m_ModelerPanel.toggleEditButtons(false, null);
                }
            }
        });
        this.jGraph.addMouseWheelListener((MouseWheelListener)new MouseAdapter(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int notches = e.getWheelRotation();
                if (notches < 0) {
                    ModelGraphPanel.this.m_ModelerPanel.zoomPlus();
                } else {
                    ModelGraphPanel.this.m_ModelerPanel.zoomMinus();
                }
            }
        });
        this.jGraph.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                block5: {
                    DefaultGraphCell cell;
                    block4: {
                        if (e.getKeyCode() == 127) break block4;
                        if (e.getKeyCode() != 8) break block5;
                    }
                    if ((cell = (DefaultGraphCell)ModelGraphPanel.this.jGraph.getSelectionCell()) != null) {
                        ObjectAndDescription oad = (ObjectAndDescription)cell.getUserObject();
                        String sKey = (String)oad.getObject();
                        boolean removed = ModelGraphPanel.this.m_ModelerPanel.removeElement(sKey);
                        ModelGraphPanel.this.m_ModelerPanel.setHasChanged(removed);
                    }
                }
            }
        });
        this.jGraph.getModel().addGraphModelListener(new GraphModelListener(){

            public void graphChanged(GraphModelEvent e) {
                ModelGraphPanel.this.m_ModelerPanel.setHasChanged(true);
            }
        });
    }

    void storeCoords() {
        if (this.jGraph == null) {
            return;
        }
        GraphModel model = this.jGraph.getModel();
        this.m_Coords.clear();
        for (int i = 0; i < model.getRootCount(); ++i) {
            try {
                DefaultGraphCell cell = (DefaultGraphCell)model.getRootAt(i);
                ObjectAndDescription oad = (ObjectAndDescription)cell.getUserObject();
                String sCellKey = (String)oad.getObject();
                cell.getAttributes();
                Rectangle2D rect = GraphConstants.getBounds((Map)cell.getAttributes());
                this.m_Coords.put(sCellKey, rect);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void showPopupMenu(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.m_ActiveCell = (DefaultGraphCell)this.jGraph.getFirstCellForLocation((double)x, (double)y);
        if (this.m_ActiveCell == null) {
            return;
        }
        Object ob = this.m_ActiveCell.getUserObject();
        if (ob != null) {
            this.popupMenu.show(e.getComponent(), x, y);
        }
    }

    private void editCell(MouseEvent e) {
        int y;
        int x = e.getX();
        DefaultGraphCell cell = (DefaultGraphCell)this.jGraph.getFirstCellForLocation((double)x, (double)(y = e.getY()));
        if (cell != null) {
            try {
                ObjectAndDescription oad = (ObjectAndDescription)cell.getUserObject();
                this.editCell(oad);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void editCell(ObjectAndDescription oad) {
        block11: {
            try {
                ParametersSet params;
                Parameter param;
                ParameterPanel paramPanel;
                String sDescription = oad.getDescription();
                String sKey = (String)oad.getObject();
                Object usrObj = this.m_ModelerPanel.getObjectFromKey(sKey);
                if (usrObj instanceof GeoAlgorithm) {
                    GeoAlgorithm alg = (GeoAlgorithm)usrObj;
                    GeoAlgorithmModelerParametersPanel paramPanel2 = null;
                    Class<? extends GeoAlgorithmModelerParametersPanel> paramPanelClass = SextanteGUI.getModelerParametersPanel(alg.getCommandLineName());
                    if (paramPanelClass == null) {
                        paramPanelClass = SextanteGUI.getGUIFactory().getDefaultModelerParametersPanel();
                    }
                    try {
                        paramPanel2 = paramPanelClass.newInstance();
                    }
                    catch (Exception e) {
                        try {
                            paramPanel2 = SextanteGUI.getGUIFactory().getDefaultModelerParametersPanel().newInstance();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    AlgorithmDialog dialog = this.m_Parent == null ? new AlgorithmDialog(alg, sKey, sDescription, this.m_Algorithm, paramPanel2, this.m_DataObjects) : new AlgorithmDialog(alg, sKey, sDescription, this.m_Algorithm, paramPanel2, this.m_DataObjects, this.m_Parent);
                    dialog.pack();
                    dialog.setTitle(Sextante.getText((String)"modeler_edit_algorithm") + " (" + alg.getName() + ")");
                    dialog.setVisible(true);
                    if (dialog.getDialogReturn() == 1) {
                        this.m_ModelerPanel.setHasChanged(true);
                        this.m_ModelerPanel.updatePanel(true);
                    }
                    break block11;
                }
                if (usrObj instanceof ObjectAndDescription && (paramPanel = this.getParameterPanel(param = (params = this.m_ModelerPanel.getAlgorithm().getParameters()).getParameter(sKey))) != null) {
                    paramPanel.setColor(new Color(param.getColorR(), param.getColorG(), param.getColorB(), param.getColorAlpha()));
                    paramPanel.getColorComboBox().getComboBox().setBackground(new Color(param.getColorR(), param.getColorG(), param.getColorB(), param.getColorAlpha()));
                    paramPanel.updateOptions();
                    paramPanel.setParameter(param);
                    paramPanel.pack();
                    paramPanel.setTitle(Sextante.getText((String)"modeler_edit_parameter"));
                    paramPanel.setVisible(true);
                    Parameter newParam = paramPanel.getParameter();
                    if (newParam != null) {
                        param.setColorR(paramPanel.getColor().getRed());
                        param.setColorG(paramPanel.getColor().getGreen());
                        param.setColorB(paramPanel.getColor().getBlue());
                        param.setColorAlpha(paramPanel.getColor().getAlpha());
                        AdditionalInfo ai = newParam.getParameterAdditionalInfo();
                        param.setParameterAdditionalInfo(ai);
                        param.setParameterDescription(newParam.getParameterDescription());
                        oad = new ObjectAndDescription(param.getParameterDescription(), (Object)ModelElementFactory.getParameterAsModelElement((Parameter)newParam));
                        this.m_DataObjects.put(sKey, oad);
                        this.m_ModelerPanel.setHasChanged(true);
                        this.m_ModelerPanel.updatePanel(true);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private ParameterPanel getParameterPanel(Parameter param) {
        return ParameterPanelFactory.getParameterPanel(param, this.m_ModelerPanel, this.m_Parent);
    }

    public void addInput(String sKey) {
        try {
            ObjectAndDescription oad = (ObjectAndDescription)this.m_ModelerPanel.getObjectFromKey(sKey);
            if (oad != null) {
                Rectangle2D box = this.getBoundingBox();
                double x = box.getMaxX() + 20.0;
                double y = 20.0;
                double w = 45.0;
                double h = 45.0;
                Rectangle2D rect = (Rectangle2D)this.m_Coords.get(sKey);
                if (rect != null) {
                    x = rect.getMinX();
                    y = rect.getMinY();
                    w = rect.getWidth();
                    h = rect.getHeight();
                }
                ParametersSet params = this.m_ModelerPanel.getAlgorithm().getParameters();
                Parameter param = params.getParameter(sKey);
                int R = param.getColorR();
                int G = param.getColorG();
                int B = param.getColorB();
                int Alpha = param.getColorAlpha();
                DefaultGraphCell cell = this.createInputVertex(new ObjectAndDescription(oad.getDescription(), (Object)sKey), x, y, w, h, R, G, B, Alpha);
                this.jGraph.getGraphLayoutCache().insert((Object)cell);
                ++this.m_iInputs;
                this.m_ModelerPanel.repaint();
            }
        }
        catch (ClassCastException oad) {
        }
        catch (WrongParameterIDException e) {
            e.printStackTrace();
        }
    }

    public void addAlgorithm(String sKey) {
        Object obj = this.m_ModelerPanel.getObjectFromKey(sKey);
        if (obj instanceof GeoAlgorithm) {
            GeoAlgorithm alg = (GeoAlgorithm)obj;
            ObjectAndDescription oad = new ObjectAndDescription(alg.getDescription(), (Object)sKey);
            Rectangle2D box = this.getBoundingBox();
            double x = box.getMaxX() + 20.0;
            double y = box.getMaxY() + 20.0;
            double w = 45.0;
            double h = 45.0;
            if (!this.isAlgorithmAlreadyAdded(sKey)) {
                Rectangle2D rect = (Rectangle2D)this.m_Coords.get(sKey);
                if (rect != null) {
                    x = rect.getMinX();
                    y = rect.getMinY();
                    w = rect.getWidth();
                    h = rect.getHeight();
                }
                DefaultGraphCell cell = this.createProcessVertex(oad, x, y, w, h, alg.getColorR(), alg.getColorG(), alg.getColorB(), alg.getColorAlpha());
                this.jGraph.getGraphLayoutCache().insert((Object)cell);
                ArrayList dependences = this.m_ModelerPanel.getDependences(sKey);
                for (int i = 0; i < dependences.size(); ++i) {
                    sKey = (String)dependences.get(i);
                    this.addAlgorithm(sKey);
                    DefaultGraphCell parentCell = this.getCellFromKey(sKey);
                    DefaultEdge edge = this.createEdge(cell, parentCell);
                    this.jGraph.getGraphLayoutCache().insert((Object)edge);
                }
            }
        }
    }

    private Rectangle2D getBoundingBox() {
        double dMaxX = 0.0;
        double dMaxY = 0.0;
        Set set = this.m_Coords.keySet();
        for (String sKey : set) {
            Rectangle2D rect = (Rectangle2D)this.m_Coords.get(sKey);
            dMaxX = Math.max(rect.getMaxX(), dMaxX);
            dMaxY = Math.max(rect.getMaxY(), dMaxY);
        }
        return new Rectangle2D.Double(0.0, 0.0, dMaxX, dMaxY);
    }

    private boolean isAlgorithmAlreadyAdded(String sKey) {
        DefaultGraphCell cell = this.getCellFromKey(sKey);
        return cell != null;
    }

    private DefaultGraphCell getCellFromKey(String sKey) {
        GraphModel model = this.jGraph.getModel();
        for (int i = 0; i < model.getRootCount(); ++i) {
            try {
                DefaultGraphCell cell = (DefaultGraphCell)model.getRootAt(i);
                ObjectAndDescription oad = (ObjectAndDescription)cell.getUserObject();
                String sCellKey = (String)oad.getObject();
                if (!sKey.equals(sCellKey)) continue;
                return cell;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private DefaultEdge createEdge(DefaultGraphCell cell, DefaultGraphCell parentCell) {
        DefaultEdge edge = new DefaultEdge();
        edge.setSource((Object)parentCell.getChildAt(0));
        edge.setTarget((Object)cell.getChildAt(0));
        GraphConstants.setLineEnd((Map)edge.getAttributes(), (int)1);
        GraphConstants.setEndFill((Map)edge.getAttributes(), (boolean)true);
        return edge;
    }

    private DefaultGraphCell createInputVertex(ObjectAndDescription oad, double x, double y, double w, double h, int R, int G, int B, int Alpha) {
        return this.createVertex(oad, x, y, w, h, this.m_InputIcon, R, G, B, Alpha);
    }

    private DefaultGraphCell createProcessVertex(ObjectAndDescription oad, double x, double y, double w, double h, int R, int G, int B, int Alpha) {
        GeoAlgorithm alg = (GeoAlgorithm)this.m_ModelerPanel.getObjectFromKey((String)oad.getObject());
        return this.createVertex(oad, x, y, w, h, SextanteGUI.getAlgorithmIcon(alg), R, G, B, Alpha);
    }

    private DefaultGraphCell createVertex(Object obj, double x, double y, double w, double h, Icon icon, int R, int G, int B, int Alpha) {
        DefaultGraphCell cell = new DefaultGraphCell(obj);
        GraphConstants.setBounds((Map)cell.getAttributes(), (Rectangle2D)new Rectangle2D.Double(x, y, w, h));
        GraphConstants.setResize((Map)cell.getAttributes(), (boolean)false);
        GraphConstants.setIcon((Map)cell.getAttributes(), (Icon)icon);
        GraphConstants.setAutoSize((Map)cell.getAttributes(), (boolean)false);
        GraphConstants.setBorder((Map)cell.getAttributes(), (Border)BorderFactory.createEtchedBorder());
        GraphConstants.setBorderColor((Map)cell.getAttributes(), (Color)Color.black);
        GraphConstants.setBackground((Map)cell.getAttributes(), (Color)new Color(R, G, B, (int)((double)Alpha * 0.66)));
        if (R < 50 && G < 50 && B < 50) {
            GraphConstants.setForeground((Map)cell.getAttributes(), (Color)Color.white);
        } else {
            GraphConstants.setForeground((Map)cell.getAttributes(), (Color)Color.black);
        }
        GraphConstants.setOpaque((Map)cell.getAttributes(), (boolean)true);
        GraphConstants.setInset((Map)cell.getAttributes(), (int)10);
        GraphConstants.setMoveable((Map)cell.getAttributes(), (boolean)true);
        GraphConstants.setSizeable((Map)cell.getAttributes(), (boolean)true);
        cell.addPort();
        return cell;
    }

    public void removeCell(String sKey) {
        GraphModel model = this.jGraph.getModel();
        for (int i = 0; i < model.getRootCount(); ++i) {
            int j;
            DefaultGraphCell cell;
            String sCellKey;
            Object obj = model.getRootAt(i);
            if (!(obj instanceof DefaultGraphCell) || !(sCellKey = (String)((ObjectAndDescription)(cell = (DefaultGraphCell)obj).getUserObject()).getObject()).equals(sKey)) continue;
            ArrayList listEdges = new ArrayList();
            int numChildren = model.getChildCount((Object)cell);
            for (j = 0; j < numChildren; ++j) {
                Object port = model.getChild((Object)cell, j);
                if (!model.isPort(port)) continue;
                Iterator iter = model.edges(port);
                while (iter.hasNext()) {
                    listEdges.add(iter.next());
                }
            }
            Object[] elementsToRemove = new Object[listEdges.size() + 1];
            for (j = 0; j < listEdges.size(); ++j) {
                elementsToRemove[j] = listEdges.get(j);
            }
            elementsToRemove[j] = cell;
            model.remove(elementsToRemove);
            return;
        }
    }

    public void setAlgorithm(ModelAlgorithm alg) {
        this.m_Algorithm = alg;
    }

    public void resetCoords() {
        this.initGraph();
        this.m_Coords.clear();
    }

    public HashMap getCoords() {
        return this.m_Coords;
    }
}

