/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.modeler;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.core.IAlgorithmProvider;
import es.unex.sextante.gui.core.IToolboxRightButtonAction;
import es.unex.sextante.gui.core.NameAndIcon;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.core.ToolboxAction;
import es.unex.sextante.gui.grass.GrassAlgorithmProvider;
import es.unex.sextante.gui.help.HelpIO;
import es.unex.sextante.gui.modeler.CreateModelToolboxAction;
import es.unex.sextante.gui.modeler.DeleteModelAction;
import es.unex.sextante.gui.modeler.EditModelAction;
import es.unex.sextante.gui.modeler.ModelAlgorithm;
import es.unex.sextante.gui.modeler.ModelAlgorithmIO;
import es.unex.sextante.gui.settings.Setting;
import es.unex.sextante.gui.settings.SextanteModelerSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;

public class ModelerAlgorithmProvider
implements IAlgorithmProvider {
    private HashMap<String, GeoAlgorithm> m_Algs;
    private static final ImageIcon MODEL_ICON = new ImageIcon(GrassAlgorithmProvider.class.getClassLoader().getResource("images/model.png"));

    @Override
    public HashMap<String, GeoAlgorithm> getAlgorithms() {
        return this.m_Algs;
    }

    @Override
    public HashMap<String, Class> getCustomModelerParameterPanels() {
        return new HashMap<String, Class>();
    }

    @Override
    public HashMap<String, Class> getCustomParameterPanels() {
        return new HashMap<String, Class>();
    }

    @Override
    public ImageIcon getIcon() {
        return MODEL_ICON;
    }

    @Override
    public String getName() {
        return Sextante.getText((String)"Models");
    }

    @Override
    public void initialize() {
        this.m_Algs = new HashMap();
        String sFolder = SextanteGUI.getSettingParameterValue("ModelsFolder");
        GeoAlgorithm[] algs2 = ModelAlgorithmIO.loadModelsAsAlgorithms(sFolder);
        for (int i = 0; i < algs2.length; ++i) {
            this.m_Algs.put(algs2[i].getCommandLineName(), algs2[i]);
        }
    }

    @Override
    public Setting getSettings() {
        return new SextanteModelerSettings();
    }

    @Override
    public void update() {
        this.initialize();
    }

    @Override
    public String getAlgorithmHelp(GeoAlgorithm alg) {
        String sModelFilename = ((ModelAlgorithm)alg).getFilename();
        String sFilename = sModelFilename.substring(sModelFilename.lastIndexOf(File.separator));
        sFilename = sFilename + ".xml";
        String sPath = SextanteGUI.getSettingParameterValue("ModelsFolder");
        String sFullPath = sPath + File.separator + sFilename;
        return HelpIO.getHelpAsHTMLCode(alg, sFullPath);
    }

    @Override
    public String getAlgorithmHelpFilename(GeoAlgorithm alg, boolean bForceCurrentLocale) {
        String sModelFilename = ((ModelAlgorithm)alg).getFilename();
        String sFilename = sModelFilename.substring(sModelFilename.lastIndexOf(File.separator));
        sFilename = sFilename + ".xml";
        String sPath = SextanteGUI.getSettingParameterValue("ModelsFolder");
        String sFullPath = sPath + File.separator + sFilename;
        return sFullPath;
    }

    @Override
    public boolean canEditHelp() {
        return true;
    }

    @Override
    public HashMap<NameAndIcon, ArrayList<ToolboxAction>> getToolboxActions() {
        HashMap<NameAndIcon, ArrayList<ToolboxAction>> map = new HashMap<NameAndIcon, ArrayList<ToolboxAction>>();
        NameAndIcon nai = new NameAndIcon(this.getName(), MODEL_ICON);
        ArrayList<CreateModelToolboxAction> list = new ArrayList<CreateModelToolboxAction>();
        list.add(new CreateModelToolboxAction());
        map.put(nai, list);
        return map;
    }

    @Override
    public IToolboxRightButtonAction[] getToolboxRightButtonActions() {
        return new IToolboxRightButtonAction[]{new EditModelAction(), new DeleteModelAction()};
    }
}

