/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.modeler.parameters;

import es.unex.sextante.additionalInfo.AdditionalInfo;
import es.unex.sextante.additionalInfo.AdditionalInfoTableField;
import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.gui.modeler.ModelAlgorithm;
import es.unex.sextante.gui.modeler.ModelerPanel;
import es.unex.sextante.gui.modeler.parameters.ParameterPanel;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.ParameterTable;
import es.unex.sextante.parameters.ParameterTableField;
import es.unex.sextante.parameters.ParameterVectorLayer;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class TableFieldPanel
extends ParameterPanel {
    private JLabel jLabelType;
    private JComboBox jComboBoxParent;

    public TableFieldPanel(JDialog parent, ModelerPanel panel) {
        super(parent, panel);
    }

    public TableFieldPanel(ModelerPanel panel) {
        super(panel);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        super.setTitle(Sextante.getText((String)"modeler_add_par_field"));
        super.setPreferredSize(new Dimension(400, 200));
        try {
            TableLayout thisLayout = new TableLayout((double[][])new double[][]{{-3.0, 5.0, -1.0}, {-3.0}});
            thisLayout.setHGap(5);
            thisLayout.setVGap(5);
            this.jPanelMiddle.setLayout((LayoutManager)thisLayout);
            this.jLabelType = new JLabel();
            this.jPanelMiddle.add((Component)this.jLabelType, "0, 0");
            this.jLabelType.setText(Sextante.getText((String)"Parent_layer_or_table"));
            this.jComboBoxParent = new JComboBox();
            this.jPanelMiddle.add((Component)this.jComboBoxParent, "2, 0");
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    @Override
    public void updateOptions() {
        ParameterVectorLayer param;
        int i;
        super.updateOptions();
        ParametersSet ps = this.m_ModelerPanel.getAlgorithm().getParameters();
        ArrayList layers = ps.getParametersOfType(ParameterVectorLayer.class);
        ArrayList tables = ps.getParametersOfType(ParameterTable.class);
        ObjectAndDescription[] oad = new ObjectAndDescription[layers.size() + tables.size()];
        for (i = 0; i < layers.size(); ++i) {
            param = (ParameterVectorLayer)layers.get(i);
            oad[i] = new ObjectAndDescription(param.getParameterDescription() + Sextante.getText((String)"[layer]"), (Object)param.getParameterName());
        }
        for (i = 0; i < tables.size(); ++i) {
            param = (ParameterTable)tables.get(i);
            oad[i + layers.size()] = new ObjectAndDescription(param.getParameterDescription() + Sextante.getText((String)"[table]"), (Object)param.getParameterName());
        }
        DefaultComboBoxModel<ObjectAndDescription> jComboBoxTypeModel = new DefaultComboBoxModel<ObjectAndDescription>(oad);
        this.jComboBoxParent.setModel(jComboBoxTypeModel);
    }

    @Override
    protected boolean prepareParameter() {
        String sDescription = this.jTextFieldDescription.getText();
        if (sDescription.length() != 0) {
            String sName = (String)((ObjectAndDescription)this.jComboBoxParent.getSelectedItem()).getObject();
            AdditionalInfoTableField addInfo = new AdditionalInfoTableField(sName, true);
            this.m_Parameter = new ParameterTableField();
            this.m_Parameter.setParameterAdditionalInfo((AdditionalInfo)addInfo);
            this.m_Parameter.setParameterDescription(this.jTextFieldDescription.getText());
            this.m_Parameter.setColorR(this.m_Color.getRed());
            this.m_Parameter.setColorG(this.m_Color.getGreen());
            this.m_Parameter.setColorB(this.m_Color.getBlue());
            this.m_Parameter.setColorAlpha(this.m_Color.getAlpha());
            return true;
        }
        JOptionPane.showMessageDialog(null, Sextante.getText((String)"Invalid_description"), Sextante.getText((String)"Warning"), 2);
        return false;
    }

    @Override
    public void setParameter(Parameter param) {
        super.setParameter(param);
        try {
            AdditionalInfoTableField ai = (AdditionalInfoTableField)param.getParameterAdditionalInfo();
            ComboBoxModel model = this.jComboBoxParent.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                ObjectAndDescription item = (ObjectAndDescription)model.getElementAt(i);
                String sName = (String)item.getObject();
                if (!sName.equals(ai.getParentParameterName())) continue;
                this.jComboBoxParent.setSelectedIndex(i);
                break;
            }
        }
        catch (NullParameterAdditionalInfoException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getParameterDescription() {
        return Sextante.getText((String)"Field");
    }

    @Override
    public boolean parameterCanBeAdded() {
        ModelAlgorithm alg = this.m_ModelerPanel.getAlgorithm();
        if (alg != null) {
            return alg.requiresIndividualVectorLayers() || alg.requiresTables();
        }
        return false;
    }
}

