/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.saga;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.saga.SagaAlgorithm;
import es.unex.sextante.gui.saga.SagaAlgorithmProvider;
import es.unex.sextante.gui.saga.SagaExecutionException;
import es.unex.sextante.gui.saga.StreamGobbler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class SagaUtils {
    public static final String SAGACMD_USE_START_PARAMETER = "SAGACMD_USE_START_PARAMETER";
    private static SagaAlgorithm m_Alg;
    private static StringBuffer m_sMessages;

    public static int installSaga() throws SagaExecutionException {
        SagaUtils.deleteDescriptionFiles();
        SagaUtils.createLibrariesListFile();
        SagaUtils.createLibrariesDescriptionFiles();
        return SagaUtils.createAlgorithmsDescriptionFiles();
    }

    public static void deleteDescriptionFiles() {
        File file = new File(SagaUtils.getSagaDescriptionFolder());
        String[] files = file.list();
        if (files != null) {
            for (String element : files) {
                new File(file.getAbsoluteFile() + File.separator + element).delete();
            }
        }
    }

    public static void createLibrariesListFile() throws SagaExecutionException {
        String[] sCommands = new String[]{" > " + SagaUtils.getSagaDescriptionFolder() + File.separator + "sagalibs.txt"};
        SagaUtils.createSagaBatchJobFileFromSagaCommands(sCommands);
        SagaUtils.executeSaga(null);
    }

    private static void createLibrariesDescriptionFiles() throws SagaExecutionException {
        ArrayList<String> commands = new ArrayList<String>();
        String sFile = SagaUtils.getSagaDescriptionFolder() + File.separator + "sagalibs.txt";
        BufferedReader input = null;
        try {
            input = new BufferedReader(new FileReader(sFile));
            String sLine = null;
            while ((sLine = input.readLine()) != null) {
                if (!sLine.startsWith("-")) continue;
                String sLibraryName = sLine.substring(1, sLine.lastIndexOf(".")).trim();
                commands.add(sLibraryName + " > " + SagaUtils.getSagaDescriptionFolder() + File.separator + "lib_" + sLibraryName + ".txt");
            }
            input.close();
            SagaUtils.createSagaBatchJobFileFromSagaCommands(commands.toArray(new String[0]));
            SagaUtils.executeSaga(null);
        }
        catch (Exception e) {
            throw new SagaExecutionException();
        }
    }

    private static int createAlgorithmsDescriptionFiles() throws SagaExecutionException {
        int iAlg = 0;
        ArrayList<String> commands = new ArrayList<String>();
        File file = new File(SagaUtils.getSagaDescriptionFolder());
        String[] files = file.list();
        if (files != null) {
            for (String sFilename : files) {
                if (!sFilename.startsWith("lib")) continue;
                int iAlgsInLibrary = 0;
                String sLibraryName = sFilename.substring(4, sFilename.length() - 4);
                file = new File(SagaUtils.getSagaDescriptionFolder() + File.separator + sFilename);
                BufferedReader input = null;
                try {
                    input = new BufferedReader(new FileReader(file.getAbsolutePath()));
                    String sLine = null;
                    while ((sLine = input.readLine()) != null) {
                        String[] sTokens = sLine.split("\t");
                        if (sTokens.length <= 0 || !SagaUtils.isNumber(sTokens[0].trim())) continue;
                        commands.add(sLibraryName + " " + Integer.toString(iAlgsInLibrary) + " >" + SagaUtils.getSagaDescriptionFolder() + File.separator + "alg_" + sLibraryName + "_" + Integer.toString(iAlg) + ".txt 2>&1");
                        ++iAlgsInLibrary;
                        ++iAlg;
                    }
                    input.close();
                }
                catch (Exception e) {
                    throw new SagaExecutionException();
                }
            }
        }
        if (commands.size() != 0) {
            SagaUtils.createSagaBatchJobFileFromSagaCommands(commands.toArray(new String[0]));
            SagaUtils.executeSaga(null);
        }
        return iAlg;
    }

    private static boolean isNumber(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String getSagaDescriptionFolder() {
        String sPath = SextanteGUI.getSextanteInstallPath() + File.separator + "saga" + File.separator + "description";
        File file = new File(sPath);
        if (!file.exists()) {
            file.mkdir();
        }
        return sPath;
    }

    public static String getBatchJobFilename() {
        String sFile = Sextante.isUnix() || Sextante.isMacOSX() ? "saga_batch_job.sh" : "saga_batch_job.bat";
        sFile = SextanteGUI.getUserFolder() + File.separator + sFile;
        return sFile;
    }

    public static void createSagaBatchJobFileFromSagaCommands(String[] sCommands) {
        String sFilename = SagaUtils.getBatchJobFilename();
        String sSagaFolder = SextanteGUI.getSettingParameterValue("SagaFolder");
        try {
            BufferedWriter output = new BufferedWriter(new FileWriter(sFilename));
            if (Sextante.isWindows()) {
                output.write("set SAGA=" + sSagaFolder + "\n");
                output.write("set SAGA_MLB=" + sSagaFolder + File.separator + "modules" + "\n");
                output.write("PATH=PATH;%SAGA%;%SAGA_MLB%\n");
            } else {
                output.write("export SAGA_MLB=" + sSagaFolder + File.separator + "modules" + "\n");
                output.write("PATH=$PATH:" + sSagaFolder + File.separator + "modules" + "\n");
                output.write("export PATH");
            }
            String value = SextanteGUI.getSettingParameterValue(SAGACMD_USE_START_PARAMETER);
            boolean b = false;
            if (value != null) {
                b = Boolean.parseBoolean(value);
            }
            for (int i = 0; i < sCommands.length; ++i) {
                if (b) {
                    output.write("saga_cmd " + sCommands[i] + "> dummy.txt \n");
                    continue;
                }
                output.write("saga_cmd " + sCommands[i] + "\n");
            }
            output.write("exit");
            output.close();
        }
        catch (IOException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public static int executeSaga(SagaAlgorithm alg) throws SagaExecutionException {
        m_Alg = alg;
        ArrayList<String> list = new ArrayList<String>();
        ProcessBuilder pb = new ProcessBuilder(list);
        if (Sextante.isUnix() || Sextante.isMacOSX()) {
            SagaUtils.setExecutable(SagaUtils.getBatchJobFilename());
            list.add(SagaUtils.getBatchJobFilename());
        } else {
            boolean b;
            list.add("cmd.exe");
            list.add("/C");
            String value = SextanteGUI.getSettingParameterValue(SAGACMD_USE_START_PARAMETER);
            if (value == null || (b = Boolean.parseBoolean(value))) {
                // empty if block
            }
            list.add(SagaUtils.getBatchJobFilename());
        }
        m_sMessages = new StringBuffer();
        try {
            Process process = pb.start();
            StreamGobbler errorGobbler = new StreamGobbler(process.getErrorStream());
            StreamGobbler outputGobbler = new StreamGobbler(process.getInputStream());
            errorGobbler.start();
            outputGobbler.start();
            int iReturn = process.waitFor();
            SagaAlgorithmProvider.addMessage(m_sMessages.toString(), "SAGA execution");
            return iReturn;
        }
        catch (Exception e) {
            throw new SagaExecutionException();
        }
    }

    public static void setExecutable(String pathname) throws SagaExecutionException {
        String version = System.getProperty("java.version").substring(0, 3);
        Float f = Float.valueOf(version);
        if (f.floatValue() < 1.6f) {
            if (Sextante.isUnix() || Sextante.isMacOSX()) {
                try {
                    Runtime.getRuntime().exec("chmod +x " + pathname);
                }
                catch (IOException e) {
                    throw new SagaExecutionException();
                }
            }
        } else if (Sextante.isUnix() || Sextante.isMacOSX()) {
            new File(pathname).setExecutable(true);
        }
    }

    public static void processLine(String line) {
        if (m_Alg == null) {
            return;
        }
        line = line.replace("%", "").trim();
        try {
            int i = Integer.parseInt(line);
            m_Alg.updateProgress(i, 100);
        }
        catch (Exception e) {
            m_sMessages.append(line + "\n");
        }
    }
}

