/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.settings;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.settings.AlgorithmGroupsConfigurationTableModel;
import es.unex.sextante.gui.toolbox.AlgorithmGroupConfiguration;
import es.unex.sextante.gui.toolbox.AlgorithmGroupsOrganizer;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class AlgorithmGroupsConfigurationDialog
extends JDialog {
    private HashMap<String, AlgorithmGroupConfiguration> m_Map;
    private JButton jButtonCancel;
    private JButton jButtonRestore;
    private JTable jTable;
    private JScrollPane jScrollPane;
    private JButton jButtonOK;
    private boolean m_bIsDefaultSettings;

    public AlgorithmGroupsConfigurationDialog() {
        super(SextanteGUI.getMainFrame(), true);
        this.initGUI();
    }

    private void initGUI() {
        AlgorithmGroupsConfigurationTableModel jTableModel;
        this.m_Map = AlgorithmGroupsOrganizer.getGrouppingMap();
        TableLayout thisLayout = new TableLayout((double[][])new double[][]{{3.0, -3.0, -1.0, 90.0, 6.0, 90.0, 3.0}, {3.0, -1.0, 3.0, 30.0, 3.0}});
        thisLayout.setHGap(5);
        thisLayout.setVGap(5);
        this.getContentPane().setLayout((LayoutManager)thisLayout);
        this.jButtonRestore = new JButton();
        this.getContentPane().add((Component)this.jButtonRestore, "1, 3");
        this.jButtonRestore.setText(Sextante.getText((String)"RestoreDefault"));
        this.jButtonRestore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlgorithmGroupsConfigurationDialog.this.jButtonRestoreActionPerformed(evt);
            }
        });
        this.jButtonCancel = new JButton();
        this.getContentPane().add((Component)this.jButtonCancel, "3, 3");
        this.jButtonCancel.setText(Sextante.getText((String)"Cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlgorithmGroupsConfigurationDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK = new JButton();
        this.getContentPane().add((Component)this.jButtonOK, "5, 3");
        this.jButtonOK.setText(Sextante.getText((String)"OK"));
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlgorithmGroupsConfigurationDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jScrollPane = new JScrollPane();
        this.getContentPane().add((Component)this.jScrollPane, "1, 1, 5, 1");
        if (this.m_Map.size() == 0) {
            jTableModel = new AlgorithmGroupsConfigurationTableModel(this);
            this.m_bIsDefaultSettings = true;
        } else {
            jTableModel = new AlgorithmGroupsConfigurationTableModel(this.m_Map, this);
        }
        this.jTable = new JTable();
        this.jTable.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane.setViewportView(this.jTable);
        this.jTable.setModel(jTableModel);
        TableColumn column = null;
        for (int i = 0; i < 5; ++i) {
            column = this.jTable.getColumnModel().getColumn(i);
            column.setPreferredWidth(100);
            if (i == 2 || i == 4) {
                column.setPreferredWidth(50);
            }
            if (i != 1) continue;
            column.setPreferredWidth(150);
        }
        this.setTitle(Sextante.getText((String)"Toolbox") + " - " + Sextante.getText((String)"ConfigureAlgGroups"));
        this.setSize(800, 500);
        this.setLocationRelativeTo(null);
    }

    public HashMap<String, AlgorithmGroupConfiguration> getGrouppingsMap() {
        return this.m_Map;
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.m_Map.clear();
        if (!this.m_bIsDefaultSettings) {
            for (int i = 0; i < this.jTable.getRowCount(); ++i) {
                AlgorithmGroupConfiguration conf = new AlgorithmGroupConfiguration();
                conf.setGroup(this.jTable.getValueAt(i, 2).toString());
                conf.setSubgroup(this.jTable.getValueAt(i, 3).toString());
                conf.setShow((Boolean)this.jTable.getValueAt(i, 4));
                this.m_Map.put(this.jTable.getValueAt(i, 0).toString(), conf);
            }
        }
        this.dispose();
        this.setVisible(false);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.m_Map = null;
        this.dispose();
        this.setVisible(false);
    }

    private void jButtonRestoreActionPerformed(ActionEvent evt) {
        this.m_Map.clear();
        AlgorithmGroupsConfigurationTableModel jTableModel = new AlgorithmGroupsConfigurationTableModel(this);
        this.jTable.setModel(jTableModel);
        this.m_bIsDefaultSettings = true;
    }

    public void hasBeenModified() {
        this.m_bIsDefaultSettings = false;
    }
}

