/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.toolbox;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.toolbox.AlgorithmGroupConfiguration;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlgorithmGroupsOrganizer {
    private static final Logger LOG = LoggerFactory.getLogger(AlgorithmGroupsOrganizer.class);
    private static HashMap<String, AlgorithmGroupConfiguration> m_Map = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readConfigFile() {
        BufferedReader input = null;
        String fname = "(unknow)";
        try {
            fname = AlgorithmGroupsOrganizer.getConfigFile();
            File ffile = new File(fname);
            if (!ffile.exists()) {
                return;
            }
            FileReader freader = new FileReader(fname);
            input = new BufferedReader(freader);
            String sLine = null;
            while ((sLine = input.readLine()) != null) {
                String[] sTokens = sLine.split("@");
                String sName = "(unknow)";
                try {
                    sName = sTokens[0];
                    AlgorithmGroupConfiguration conf = AlgorithmGroupConfiguration.fromString(sTokens[1]);
                    if (conf == null) continue;
                    AlgorithmGroupsOrganizer.getGrouppingMap().put(sName, conf);
                }
                catch (Exception e) {
                    LOG.warn("Can't read configuration of '" + sName + "'.", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Can't read config file '" + fname + "'.", (Throwable)e);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSettings() {
        Writer output = null;
        try {
            output = new BufferedWriter(new FileWriter(AlgorithmGroupsOrganizer.getConfigFile()));
            Set<String> set = AlgorithmGroupsOrganizer.getGrouppingMap().keySet();
            for (String sKey : set) {
                AlgorithmGroupConfiguration conf = AlgorithmGroupsOrganizer.getGrouppingMap().get(sKey);
                output.write(sKey + "@" + conf.toString() + "\n");
            }
        }
        catch (IOException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    Sextante.addErrorToLog((Throwable)e);
                }
            }
        }
    }

    public static HashMap<String, AlgorithmGroupConfiguration> getGrouppingMap() {
        if (m_Map == null) {
            m_Map = new HashMap();
            AlgorithmGroupsOrganizer.readConfigFile();
        }
        return m_Map;
    }

    private static String getConfigFile() {
        String sPath = SextanteGUI.getSextanteHomePath();
        sPath = sPath + File.separator + "sextante_alg_groups.settings";
        return sPath;
    }

    public static void setConfiguration(HashMap<String, AlgorithmGroupConfiguration> map) {
        m_Map = map;
    }

    public static AlgorithmGroupConfiguration getGroupConfiguration(GeoAlgorithm alg) {
        return AlgorithmGroupsOrganizer.getGrouppingMap().get(alg.getCommandLineName());
    }

    public static void restore() {
        AlgorithmGroupsOrganizer.getGrouppingMap().clear();
    }
}

