/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.toolbox;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.dataObjects.ILayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.OutputRasterLayer;
import es.unex.sextante.outputs.OutputVectorLayer;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class OutputRenderingSettingsDialog
extends JDialog {
    private HashMap<String, Object> m_Settings = new HashMap();
    private final JLabel[] jLabel = new JLabel[10];
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private final JComboBox[] jComboBox = new JComboBox[10];
    private final GeoAlgorithm m_Alg;

    public OutputRenderingSettingsDialog(GeoAlgorithm alg) {
        this.m_Alg = alg;
        this.initGUI();
        this.setLocationRelativeTo(null);
    }

    public HashMap<String, Object> getSettings() {
        return this.m_Settings;
    }

    private void initGUI() {
        try {
            TableLayout thisLayout = new TableLayout((double[][])new double[][]{{6.0, -1.0, -1.0, 10.0, -1.0, -1.0, 6.0}, {6.0, -3.0, -3.0, -3.0, -3.0, -3.0, -3.0, -3.0, -3.0, -3.0, -3.0, -1.0, -3.0, 6.0}});
            thisLayout.setHGap(5);
            thisLayout.setVGap(5);
            this.getContentPane().setLayout((LayoutManager)thisLayout);
            int iRow = 1;
            OutputObjectsSet outputs = this.m_Alg.getOutputObjects();
            for (int i = 0; i < outputs.getOutputObjectsCount(); ++i) {
                Output out = outputs.getOutput(i);
                if (out instanceof OutputRasterLayer) {
                    this.jLabel[iRow - 1] = new JLabel(out.getDescription());
                    this.getContentPane().add((Component)this.jLabel[iRow - 1], "1," + Integer.toString(iRow) + ",2," + Integer.toString(iRow));
                    DefaultComboBoxModel<IRasterLayer> jComboBoxModel = new DefaultComboBoxModel<IRasterLayer>(SextanteGUI.getInputFactory().getRasterLayers());
                    this.jComboBox[iRow - 1] = new JComboBox();
                    this.getContentPane().add((Component)this.jComboBox[iRow - 1], "4," + Integer.toString(iRow) + ",5," + Integer.toString(iRow));
                    this.jComboBox[iRow - 1].setModel(jComboBoxModel);
                    ++iRow;
                }
                if (!(out instanceof OutputVectorLayer)) continue;
                this.jLabel[iRow - 1] = new JLabel(out.getDescription());
                this.getContentPane().add((Component)this.jLabel[iRow - 1], "1," + Integer.toString(iRow) + ",2," + Integer.toString(iRow));
                int type = ((OutputVectorLayer)out).getShapeType();
                DefaultComboBoxModel<Object> jComboBoxModel = new DefaultComboBoxModel<Object>(this.getVectorLayers(type));
                this.jComboBox[iRow - 1] = new JComboBox();
                this.getContentPane().add((Component)this.jComboBox[iRow - 1], "4," + Integer.toString(iRow) + ",5," + Integer.toString(iRow));
                this.jComboBox[iRow - 1].setModel(jComboBoxModel);
                ++iRow;
            }
            this.jButtonOK = new JButton();
            this.getContentPane().add((Component)this.jButtonOK, "4, 12");
            this.jButtonOK.setText("OK");
            this.jButtonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    OutputRenderingSettingsDialog.this.createSettings();
                    OutputRenderingSettingsDialog.this.dispose();
                    OutputRenderingSettingsDialog.this.setVisible(false);
                }
            });
            this.jButtonCancel = new JButton();
            this.getContentPane().add((Component)this.jButtonCancel, "5, 12");
            this.jButtonCancel.setText("Cancel");
            this.jButtonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    OutputRenderingSettingsDialog.this.m_Settings = null;
                    OutputRenderingSettingsDialog.this.dispose();
                    OutputRenderingSettingsDialog.this.setVisible(false);
                }
            });
            this.setSize(504, 218);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Object[] getVectorLayers(int type) {
        if (type != -1) {
            return SextanteGUI.getInputFactory().getVectorLayers(-1);
        }
        return SextanteGUI.getInputFactory().getVectorLayers(type);
    }

    protected void createSettings() {
        int iCombo = 0;
        OutputObjectsSet outputs = this.m_Alg.getOutputObjects();
        for (int i = 0; i < outputs.getOutputObjectsCount(); ++i) {
            Object layer;
            Output out = outputs.getOutput(i);
            if (out instanceof OutputRasterLayer && (layer = this.jComboBox[iCombo].getSelectedItem()) != null) {
                this.m_Settings.put(out.getName(), SextanteGUI.getDataRenderer().getRenderingDataFromLayer((ILayer)layer));
                ++iCombo;
            }
            if (!(out instanceof OutputVectorLayer) || (layer = this.jComboBox[iCombo].getSelectedItem()) == null) continue;
            this.m_Settings.put(out.getName(), SextanteGUI.getDataRenderer().getRenderingDataFromLayer((ILayer)layer));
            ++iCombo;
        }
    }
}

