/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.toolbox;

import es.unex.sextante.core.IGeoAlgorithmFilter;
import es.unex.sextante.gui.toolbox.AlgorithmsPanel;
import es.unex.sextante.gui.toolbox.IToolboxDialog;
import es.unex.sextante.gui.toolbox.TextSearchPanel;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class ToolboxPanel
extends JPanel {
    private AlgorithmsPanel algoritmhsPanel;
    private TextSearchPanel jTextSearchPanel;
    private final IToolboxDialog m_Parent;
    private int m_iCount;
    private final IGeoAlgorithmFilter m_Filter;
    private final ImageIcon m_BackgroundImage;

    public ToolboxPanel(IToolboxDialog parent, IGeoAlgorithmFilter filter, ImageIcon img) {
        if (img == null) {
            URL res = this.getClass().getClassLoader().getResource("images/sextante_toolbox.gif");
            img = res != null ? new ImageIcon(res) : null;
        }
        this.m_Parent = parent;
        this.m_Filter = filter;
        this.m_BackgroundImage = img;
        this.initialize();
    }

    public void initialize() {
        this.setSize(new Dimension(400, 500));
        TableLayout thisLayout = new TableLayout((double[][])new double[][]{{-1.0}, {-1.0, -3.0}});
        thisLayout.setHGap(5);
        thisLayout.setVGap(5);
        this.setLayout((LayoutManager)thisLayout);
        this.algoritmhsPanel = this.createAlgorithmsPanel(this.m_BackgroundImage, this.m_Filter, this.m_Parent);
        this.add((Component)this.algoritmhsPanel, "0, 0");
        this.jTextSearchPanel = new TextSearchPanel(this, this.m_Parent.getDialog());
        this.add((Component)this.jTextSearchPanel, "0, 1");
        this.fillTreesWithAllAlgorithms();
    }

    protected AlgorithmsPanel createAlgorithmsPanel(ImageIcon img, IGeoAlgorithmFilter filter, IToolboxDialog parent) {
        return new AlgorithmsPanel(parent, filter, img);
    }

    private void collapseAll() {
        this.algoritmhsPanel.collapseAll();
    }

    public void fillTreesWithAllAlgorithms() {
        this.fillTreesWithSelectedAlgorithms(null, false);
        this.collapseAll();
    }

    public void fillTreesWithSelectedAlgorithms(String string, boolean bIncludeHelpFile) {
        this.m_iCount = this.algoritmhsPanel.fillTree(string, bIncludeHelpFile);
    }

    public int getAlgorithmsCount() {
        return this.m_iCount;
    }
}

