/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl.openfile;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gvsig.gui.beans.Messages;
import org.gvsig.gui.beans.swing.JFileChooser;
import org.gvsig.raster.swing.openfile.FileFilter;

public class FileTextField
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextField tf_fileName = null;
    private JButton bt_chooseFile = null;
    private File selectedFile = null;
    private JFileChooser jfc;
    private String JFC_ID = null;
    public static final int ACTION_EVENT_FIELD_DISABLED = 0;
    public static final int ACTION_EVENT_FIELD_ENABLED = 1;
    public static final int ACTION_EVENT_VALUE_CHANGED = 1;

    public FileTextField() {
        this.JFC_ID = this.getClass().getName();
        this.initializeUI();
    }

    public FileTextField(String id) {
        this.JFC_ID = id;
        this.initializeUI();
    }

    private void initializeUI() {
        this.jfc = new JFileChooser(this.JFC_ID, (String)null);
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 0, 0, 4);
        this.add((Component)this.getNameField(), constraints);
        this.getChooseFileButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int action;
                if (e.getSource() == FileTextField.this.getChooseFileButton() && (action = FileTextField.this.jfc.showDialog((Component)FileTextField.this, Messages.getText((String)"Open"))) == 0) {
                    FileTextField.this.setSelectedFile(FileTextField.this.jfc.getSelectedFile());
                    FileTextField.this.setEnabled(true);
                }
            }
        });
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.getChooseFileButton(), constraints);
    }

    private JTextField getNameField() {
        if (this.tf_fileName == null) {
            this.tf_fileName = new JTextField();
            this.tf_fileName.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    FileTextField.this.updateSelectedFile();
                }
            });
        }
        return this.tf_fileName;
    }

    private JButton getChooseFileButton() {
        if (this.bt_chooseFile == null) {
            this.bt_chooseFile = new JButton("...");
        }
        return this.bt_chooseFile;
    }

    public void setSelectedFile(File file) {
        File oldFile = this.selectedFile;
        this.selectedFile = this.normalizeExtension(file);
        this.getNameField().setText(this.selectedFile.toString());
        if (file.isDirectory()) {
            this.jfc.setLastPath(file);
        } else {
            this.jfc.setSelectedFile(file);
            this.jfc.setLastPath(file.getParentFile());
        }
        this.fireValueChanged(oldFile, file);
    }

    public File getSelectedFile() {
        return this.updateSelectedFile();
    }

    private File normalizeExtension(File file) {
        javax.swing.filechooser.FileFilter filter = this.jfc.getFileFilter();
        if (!filter.accept(file)) {
            String path = file.getPath();
            if (filter instanceof FileFilter) {
                FileFilter ourFilter = (FileFilter)filter;
                path = path.endsWith(".") ? path + ourFilter.getDefaultExtension() : path + "." + ourFilter.getDefaultExtension();
                file = new File(path);
            }
        }
        return file;
    }

    private File updateSelectedFile() {
        File oldFile = this.selectedFile;
        String text = this.getNameField().getText();
        if (oldFile != null && !oldFile.getPath().equals(text) || oldFile == null && !text.equals("")) {
            File newFile;
            this.selectedFile = newFile = this.normalizeExtension(new File(this.getNameField().getText()));
            this.fireValueChanged(oldFile, newFile);
        }
        return this.selectedFile;
    }

    protected void fireValueChanged(File oldValue, File newValue) {
        this.firePropertyChange("selectedFileChanged", oldValue, newValue);
    }

    protected void fireEnabledChanged(boolean oldValue, boolean newValue) {
        this.firePropertyChange("enabled", oldValue, newValue);
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean oldValue = this.isEnabled();
        super.setEnabled(enabled);
        this.getNameField().setEnabled(enabled);
        this.getChooseFileButton().setEnabled(enabled);
        this.fireEnabledChanged(oldValue, enabled);
    }

    public javax.swing.filechooser.FileFilter getFileFilter() {
        return this.jfc.getFileFilter();
    }

    public int getFileSelectionMode() {
        return this.jfc.getFileSelectionMode();
    }

    public boolean removeChoosableFileFilter(FileFilter f) {
        return this.jfc.removeChoosableFileFilter((javax.swing.filechooser.FileFilter)f);
    }

    public void setFileFilter(FileFilter filter) {
        this.jfc.setFileFilter((javax.swing.filechooser.FileFilter)filter);
    }

    public void addChoosableFileFilter(FileFilter filter) {
        this.jfc.addChoosableFileFilter((javax.swing.filechooser.FileFilter)filter);
    }

    public FileFilter getAcceptAllFileFilter() {
        return (FileFilter)this.jfc.getAcceptAllFileFilter();
    }

    public boolean isAcceptAllFileFilterUsed() {
        return this.jfc.isAcceptAllFileFilterUsed();
    }

    public void resetChoosableFileFilters() {
        this.jfc.resetChoosableFileFilters();
    }

    public void setAcceptAllFileFilterUsed(boolean b) {
        this.jfc.setAcceptAllFileFilterUsed(b);
    }
}

