/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl.pagedtable;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.gui.util.StatusComponent;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.swing.impl.pagedtable.Pager;
import org.gvsig.raster.swing.impl.pagedtable.TableControllerListener;

public class MoveRowsPanel
extends JPanel
implements Observer {
    private static final long serialVersionUID = -4496318143555472677L;
    private int HEIGHT_BUTTONS = 19;
    private JButton bUp = null;
    private JButton bDown = null;
    private String pathToImagesForTest = "/src/main/resources/images/";
    private StatusComponent statusComponent = null;

    public MoveRowsPanel(TableControllerListener tableListener) {
        tableListener.setMoveRowsPanel(this);
        this.initialize(tableListener);
    }

    private void initialize(TableControllerListener tableListener) {
        this.statusComponent = new StatusComponent((JComponent)this);
        this.setLayout(new FlowLayout(1, 0, 0));
        this.add(this.getBUp());
        this.add(this.getBDown());
        this.getBUp().addActionListener(tableListener);
        this.getBDown().addActionListener(tableListener);
    }

    public JButton getBUp() {
        if (this.bUp == null) {
            this.bUp = new JButton("");
            this.bUp.setEnabled(true);
            this.bUp.setPreferredSize(new Dimension(22, this.HEIGHT_BUTTONS));
            this.bUp.setIcon(this.loadIcon("up-16x16"));
            this.bUp.setActionCommand("");
            this.bUp.setToolTipText(Messages.getText((String)"subir"));
        }
        return this.bUp;
    }

    public JButton getBDown() {
        if (this.bDown == null) {
            this.bDown = new JButton("");
            this.bDown.setEnabled(true);
            this.bDown.setPreferredSize(new Dimension(22, this.HEIGHT_BUTTONS));
            this.bDown.setIcon(this.loadIcon("down-16x16"));
            this.bDown.setActionCommand("");
            this.bDown.setToolTipText(Messages.getText((String)"bajar"));
        }
        return this.bDown;
    }

    private ImageIcon loadIcon(String iconName) {
        ImageIcon icon = null;
        try {
            icon = IconThemeHelper.getImageIcon((String)iconName);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (icon == null) {
            icon = new ImageIcon(System.getProperty("user.dir") + this.pathToImagesForTest + iconName + ".png", "");
        }
        if (icon == null) {
            icon = new ImageIcon(System.getProperty("user.dir") + this.pathToImagesForTest + iconName + ".gif", "");
        }
        return icon;
    }

    public void disableAllControls() {
        this.statusComponent.setEnabled(false);
    }

    public void restoreControlsValue() {
        this.statusComponent.setEnabled(true);
    }

    private void checkArrows(Pager pager) {
        if (!this.statusComponent.isEnabled()) {
            return;
        }
        int[] selectedRows = pager.getSelectedRows();
        if (selectedRows != null && pager.getEntriesCount() > 1) {
            if (selectedRows[0] == 0) {
                this.getBUp().setEnabled(false);
                this.getBDown().setEnabled(true);
            } else if (selectedRows[0] == pager.getEntriesCount() - 1) {
                this.getBUp().setEnabled(true);
                this.getBDown().setEnabled(false);
            } else {
                this.getBUp().setEnabled(true);
                this.getBDown().setEnabled(true);
            }
        } else {
            this.getBUp().setEnabled(false);
            this.getBDown().setEnabled(false);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof Pager && arg instanceof Integer) {
            Pager pager = (Pager)o;
            this.checkArrows(pager);
        }
    }
}

