/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl.roi;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.i18n.Messages;

public class ROIButtonsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel toolsPanel = null;
    private JPanel tableButtonsPanel = null;
    private JButton newButton = null;
    private JButton deleteButton = null;
    private JButton exportButton = null;
    private JButton importButton = null;
    private JButton removeFileButton = null;
    private JToggleButton pointToolButton = null;
    private JToggleButton lineToolButton = null;
    private JToggleButton polygonToolButton = null;

    public ROIButtonsPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.getTableButtonsPanel(), gbc);
        this.add((Component)this.getToolsPanel(), gbc);
        this.getPolygonToolButton().setSelected(true);
        this.setToolsEnabled(false);
    }

    public JPanel getToolsPanel() {
        if (this.toolsPanel == null) {
            this.toolsPanel = new JPanel();
            FlowLayout fl = new FlowLayout(2);
            fl.setHgap(2);
            fl.setVgap(0);
            this.toolsPanel.setLayout(fl);
            this.toolsPanel.add(this.getPointToolButton());
            this.toolsPanel.add(this.getLineToolButton());
            this.toolsPanel.add(this.getPolygonToolButton());
            this.toolsPanel.add(this.getRemoveFileButton());
            this.toolsPanel.add(this.getExportButton());
            this.toolsPanel.add(this.getImportButton());
        }
        return this.toolsPanel;
    }

    public JPanel getTableButtonsPanel() {
        if (this.tableButtonsPanel == null) {
            this.tableButtonsPanel = new JPanel();
            FlowLayout fl = new FlowLayout(0);
            fl.setHgap(2);
            fl.setVgap(0);
            this.tableButtonsPanel.setLayout(fl);
            this.tableButtonsPanel.add(this.getNewButton());
            this.tableButtonsPanel.add(this.getDeleteButton());
        }
        return this.tableButtonsPanel;
    }

    public void setToolsEnabled(boolean b) {
        this.getPointToolButton().setEnabled(b);
        this.getLineToolButton().setEnabled(b);
        this.getPolygonToolButton().setEnabled(b);
    }

    public JButton getDeleteButton() {
        if (this.deleteButton == null) {
            this.deleteButton = new JButton(Messages.getText((String)"borrar"));
        }
        return this.deleteButton;
    }

    public JButton getNewButton() {
        if (this.newButton == null) {
            this.newButton = new JButton(Messages.getText((String)"nuevo"));
        }
        return this.newButton;
    }

    public JToggleButton getPointToolButton() {
        if (this.pointToolButton == null) {
            this.pointToolButton = new JToggleButton();
            ImageIcon icon = null;
            try {
                icon = IconThemeHelper.getImageIcon((String)"point-icon");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (icon == null) {
                icon = new ImageIcon(System.getProperty("user.dir") + "/src/main/resources/images/point-icon.png", "");
            }
            this.pointToolButton.setIcon(icon);
        }
        return this.pointToolButton;
    }

    public JToggleButton getLineToolButton() {
        if (this.lineToolButton == null) {
            this.lineToolButton = new JToggleButton();
            ImageIcon icon = null;
            try {
                icon = IconThemeHelper.getImageIcon((String)"line-icon");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (icon == null) {
                icon = new ImageIcon(System.getProperty("user.dir") + "/src/main/resources/images/line-icon.png", "");
            }
            this.lineToolButton.setIcon(icon);
        }
        return this.lineToolButton;
    }

    public JToggleButton getPolygonToolButton() {
        if (this.polygonToolButton == null) {
            this.polygonToolButton = new JToggleButton();
            ImageIcon icon = null;
            try {
                icon = IconThemeHelper.getImageIcon((String)"polygon-icon");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (icon == null) {
                icon = new ImageIcon(System.getProperty("user.dir") + "/src/main/resources/images/polygon-icon.png", "");
            }
            this.polygonToolButton.setIcon(icon);
        }
        return this.polygonToolButton;
    }

    public JButton getRemoveFileButton() {
        if (this.removeFileButton == null) {
            this.removeFileButton = new JButton();
            ImageIcon icon = null;
            try {
                icon = IconThemeHelper.getImageIcon((String)"delall");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (icon == null) {
                icon = new ImageIcon(System.getProperty("user.dir") + "/src/main/resources/images/delall.png", "");
            }
            this.removeFileButton.setIcon(icon);
            this.removeFileButton.setToolTipText(Messages.getText((String)"delete_roi_file"));
        }
        return this.removeFileButton;
    }

    public JButton getImportButton() {
        if (this.importButton == null) {
            this.importButton = new JButton();
            ImageIcon icon = null;
            try {
                icon = IconThemeHelper.getImageIcon((String)"tfwload-icon");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (icon == null) {
                icon = new ImageIcon(System.getProperty("user.dir") + "/src/main/resources/images/tfwload-icon.png", "");
            }
            this.importButton.setIcon(icon);
            this.importButton.setToolTipText(Messages.getText((String)"cargar_rois"));
        }
        return this.importButton;
    }

    public JButton getExportButton() {
        if (this.exportButton == null) {
            this.exportButton = new JButton();
            ImageIcon icon = null;
            try {
                icon = IconThemeHelper.getImageIcon((String)"layer-saveas");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (icon == null) {
                icon = new ImageIcon(System.getProperty("user.dir") + "/src/main/resources/images/layer-saveas.png", "");
            }
            this.exportButton.setIcon(icon);
            this.exportButton.setToolTipText(Messages.getText((String)"salvar_rois"));
        }
        return this.exportButton;
    }
}

