/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.prov.kml;

import org.gvsig.compat.CompatLibrary;
import org.gvsig.gpe.lib.api.GPELibrary;
import org.gvsig.gpe.lib.api.exceptions.ParserNotRegisteredException;
import org.gvsig.gpe.lib.api.exceptions.WriterHandlerNotRegisteredException;
import org.gvsig.gpe.lib.spi.GPEProviderLocator;
import org.gvsig.gpe.lib.spi.GPEProviderManager;
import org.gvsig.gpe.prov.kml.parser.GPEKml2_2_Parser;
import org.gvsig.gpe.prov.kml.parser.GPEKmz2_2_Parser;
import org.gvsig.gpe.prov.kml.writer.GPEKml21WriterHandlerImplementor;
import org.gvsig.tools.library.AbstractLibrary;
import org.gvsig.tools.library.LibraryException;
import org.gvsig.tools.locator.Locator;
import org.gvsig.tools.locator.ReferenceNotRegisteredException;
import org.gvsig.xmlpull.lib.api.XmlPullLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KmlLibrary
extends AbstractLibrary {
    private static final Logger logger = LoggerFactory.getLogger(KmlLibrary.class);

    public void doRegistration() {
        this.registerAsServiceOf(GPELibrary.class);
        this.require(CompatLibrary.class);
        this.require(XmlPullLibrary.class);
    }

    protected void doInitialize() throws LibraryException {
    }

    protected void doPostInitialize() throws LibraryException {
        GPEProviderManager gpeProviderManager = GPEProviderLocator.getGPEProviderManager();
        if (gpeProviderManager == null) {
            throw new ReferenceNotRegisteredException("GPEProviderManager", (Locator)GPEProviderLocator.getInstance());
        }
        try {
            gpeProviderManager.addGpeParser("KML", "Parser for KML 2.2", GPEKml2_2_Parser.class);
            gpeProviderManager.addGpeParser("KMZ", "Parser for KMZ 2.2", GPEKmz2_2_Parser.class);
        }
        catch (ParserNotRegisteredException e) {
            logger.error("Impossible to register a KML parser");
        }
        try {
            gpeProviderManager.addGpeWriterHandlerImplementor("KML", "Writer for KML", GPEKml21WriterHandlerImplementor.class);
        }
        catch (WriterHandlerNotRegisteredException e) {
            logger.error("Impossible to register a KML writer");
        }
    }
}

