/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.splitline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.prov.splitline.operation.SplitLineOperation;
import org.gvsig.vectorediting.lib.prov.splitline.operation.SplitLineOperationUtils;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class SplitLineEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private final EditingServiceParameter selection;
    private final EditingServiceParameter point;
    private final FeatureStore featureStore;
    private Map<EditingServiceParameter, Object> values;
    private List<Feature> selectedFeatures;

    public SplitLineEditingProvider(DynObject parameters, ProviderServices services) {
        super(services);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.selection = new DefaultEditingServiceParameter("selection", "selection", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.SELECTION});
        this.point = new DefaultEditingServiceParameter("indicate_new_point", "indicate_new_point", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.selection) == null) {
            return this.selection;
        }
        if (this.values.get(this.point) == null) {
            return this.point;
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        if (this.values != null) {
            DefaultDrawingStatus drawingStatus = new DefaultDrawingStatus();
            EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
            ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
            ISymbol auxiliaryLineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
            try {
                EditingProviderServices editingProviderService = this.getProviderServices();
                int subtype = editingProviderService.getSubType(this.featureStore);
                for (Feature feature : this.selectedFeatures) {
                    Curve[] splittedCurves;
                    ISymbol previewSymbol = this.getPreviewSymbol(feature);
                    Geometry lineToSplit = this.getLineToSplit(feature.getDefaultGeometry());
                    Point projectedPoint = this.getNearestPoint(lineToSplit, mousePosition);
                    Line line = editingProviderService.createLine(mousePosition, projectedPoint, subtype);
                    drawingStatus.addStatus((Geometry)projectedPoint, auxiliaryPointSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)line, auxiliaryLineSymbolEditing, "");
                    for (Curve splittedCurve : splittedCurves = this.splitCurve((Curve)lineToSplit, projectedPoint)) {
                        drawingStatus.addStatus((Geometry)splittedCurve, previewSymbol, "");
                    }
                }
            }
            catch (Exception e) {
                throw new DrawServiceException((Throwable)e);
            }
            return drawingStatus;
        }
        return null;
    }

    private Geometry getLineToSplit(Geometry geometry) {
        Curve line = null;
        GeometryType geoType = geometry.getGeometryType();
        if (geoType.isTypeOf(2)) {
            line = (Curve)geometry;
        } else if (geoType.isTypeOf(8)) {
            line = (MultiCurve)geometry;
        }
        return line;
    }

    private Point getNearestPoint(Geometry lineToSplit, Point point) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return (Point)lineToSplit.closestPoints((Geometry)point)[0];
    }

    public void stop() throws StopServiceException {
        if (this.values != null) {
            this.values.clear();
        }
        this.selectedFeatures = Collections.EMPTY_LIST;
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.selection);
        parameters.add(this.point);
        return parameters;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter parameter = this.next();
        this.validateAndInsertValue(parameter, value);
    }

    private void validateAndInsertValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        if (this.values != null && value != null) {
            if (value instanceof FeatureSelection) {
                FeatureSelection feautureSelection = (FeatureSelection)value;
                if (feautureSelection.getSelectedCount() == 1L) {
                    try {
                        for (Feature feature : feautureSelection) {
                            Geometry geometry = feature.getDefaultGeometry();
                            GeometryType geoType = geometry.getGeometryType();
                            if (geoType.isTypeOf(2)) {
                                if (this.isAnArcClosed((Curve)geometry)) {
                                    throw new InvalidEntryException(null);
                                }
                                this.values.put(this.selection, value);
                                this.selectedFeatures = this.getSelectedFeaturesCopy(feautureSelection);
                                continue;
                            }
                            if (!geoType.isTypeOf(8)) continue;
                            MultiCurve multiCurve = (MultiCurve)geometry;
                            for (int i = 0; i < multiCurve.getPrimitivesNumber(); ++i) {
                                if (!this.isAnArcClosed((Curve)multiCurve.getPrimitiveAt(i))) continue;
                                throw new InvalidEntryException(null);
                            }
                            this.values.put(this.selection, value);
                            this.selectedFeatures = this.getSelectedFeaturesCopy(feautureSelection);
                        }
                        return;
                    }
                    catch (BaseException e) {
                        throw new InvalidEntryException((Throwable)e);
                    }
                }
            } else if (value instanceof Point) {
                this.values.put(parameter, value);
                return;
            }
        }
        throw new InvalidEntryException(null);
    }

    private boolean isAnArcClosed(Curve curve) {
        Point lastPoint;
        Point firstPoint;
        return curve instanceof Arc && (firstPoint = curve.getVertex(0)).equals(lastPoint = curve.getVertex(curve.getNumVertices() - 1));
    }

    public Geometry finish() throws FinishServiceException {
        return null;
    }

    public void finishAndStore() throws FinishServiceException {
        if (this.values != null) {
            EditingProviderServices editingProviderService = this.getProviderServices();
            Point pointValue = (Point)this.values.get(this.point);
            try {
                for (Feature feature : this.selectedFeatures) {
                    MultiCurve multiCurve;
                    List<Geometry> result;
                    Geometry lineToSplit = this.getLineToSplit(feature.getDefaultGeometry());
                    GeometryType geomType = lineToSplit.getGeometryType();
                    Point projectedPoint = this.getNearestPoint(lineToSplit, pointValue);
                    if (geomType.isTypeOf(2)) {
                        Curve[] splittedCurves = this.splitCurve((Curve)lineToSplit, projectedPoint);
                        editingProviderService.deleteFeatureFromFeatureStore(feature, this.featureStore);
                        EditableFeature eFeature = editingProviderService.getFeatureCopyWithoutUniqueIndex(this.featureStore, feature);
                        eFeature.setDefaultGeometry((Geometry)splittedCurves[0]);
                        editingProviderService.insertFeatureIntoFeatureStore((Feature)eFeature, this.featureStore);
                        eFeature = editingProviderService.getFeatureCopyWithoutUniqueIndex(this.featureStore, feature);
                        eFeature.setDefaultGeometry((Geometry)splittedCurves[1]);
                        editingProviderService.insertFeatureIntoFeatureStore((Feature)eFeature, this.featureStore);
                        continue;
                    }
                    if (!geomType.isTypeOf(8) || (result = this.splitMultiCurve(multiCurve = (MultiCurve)lineToSplit, projectedPoint)) == null || result.size() <= 0) continue;
                    editingProviderService.deleteFeatureFromFeatureStore(feature, this.featureStore);
                    for (Geometry geometry : result) {
                        EditableFeature eFeature = editingProviderService.getFeatureCopyWithoutUniqueIndex(this.featureStore, feature);
                        eFeature.setDefaultGeometry(geometry);
                        editingProviderService.insertFeatureIntoFeatureStore((Feature)eFeature, this.featureStore);
                    }
                }
                this.featureStore.getFeatureSelection().deselectAll();
                this.selectedFeatures = Collections.EMPTY_LIST;
            }
            catch (BaseException e) {
                throw new FinishServiceException((Throwable)e);
            }
        }
    }

    private List<Geometry> splitMultiCurve(MultiCurve multiCurveToSplit, Point projectedPoint) throws GeometryOperationNotSupportedException, GeometryOperationException, LocatorException, DataException, GeometryException {
        ArrayList<Geometry> result = new ArrayList<Geometry>();
        Curve curveToSplit = null;
        for (int i = 0; i < multiCurveToSplit.getPrimitivesNumber(); ++i) {
            if (!this.intersects(multiCurveToSplit.getCurveAt(i), projectedPoint)) continue;
            curveToSplit = multiCurveToSplit.getCurveAt(i);
        }
        Curve[] splitedCurves = this.splitCurve(curveToSplit, projectedPoint);
        result.addAll(Arrays.asList(splitedCurves));
        EditingProviderServices editingProviderService = this.getProviderServices();
        int subtype = editingProviderService.getSubType(this.featureStore);
        MultiCurve multiCurve = GeometryLocator.getGeometryManager().createMultiCurve(subtype);
        for (int i = 0; i < multiCurveToSplit.getPrimitivesNumber(); ++i) {
            if (this.intersects(multiCurveToSplit.getCurveAt(i), projectedPoint)) continue;
            multiCurve.addCurve(multiCurveToSplit.getCurveAt(i));
        }
        if (multiCurve.getPrimitivesNumber() > 0) {
            result.add((Geometry)multiCurve);
        }
        return result;
    }

    private Curve[] splitCurve(Curve curveToSplit, Point projectedPoint) throws DataException, LocatorException, GeometryOperationNotSupportedException, GeometryOperationException, GeometryException {
        SplitLineOperation operation = SplitLineOperationUtils.getOperation((Primitive)curveToSplit);
        if (operation != null) {
            return operation.split((Geometry)curveToSplit, projectedPoint);
        }
        return null;
    }

    private boolean intersects(Curve curve, Point projectedPoint) throws GeometryOperationNotSupportedException, GeometryOperationException {
        double tolerance = 1.0;
        return curve.buffer(tolerance).intersects((Geometry)projectedPoint);
    }

    public void start() throws StartServiceException, InvalidEntryException {
        this.values = new HashMap<EditingServiceParameter, Object>();
        this.selectedFeatures = Collections.EMPTY_LIST;
        if (this.featureStore != null) {
            FeatureSelection selected = null;
            try {
                selected = (FeatureSelection)this.featureStore.getFeatureSelection().clone();
            }
            catch (DataException e) {
                throw new StartServiceException((Throwable)e);
            }
            catch (CloneNotSupportedException ex) {
                LOGGER.debug("Can't init selection", (Throwable)ex);
            }
            if (selected != null && selected.getSelectedCount() == 1L) {
                this.values.put(this.selection, selected);
                this.selectedFeatures = this.getSelectedFeaturesCopy(selected);
            }
        }
    }

    public String getName() {
        return "modify-split-line";
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }
}

