/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.splitline.operation;

import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.vectorediting.lib.prov.splitline.operation.SplitLineOperation;
import org.gvsig.vectorediting.lib.prov.splitline.operation.SplitLineOperationUtils;

public class ArcSplitLineOperation
implements SplitLineOperation {
    @Override
    public Curve[] split(Geometry geometry, Point projectedPoint) throws CreateGeometryException, GeometryOperationNotSupportedException, GeometryOperationException {
        GeometryManager geoManager = GeometryLocator.getGeometryManager();
        int subtype = geometry.getGeometryType().getSubType();
        Arc arcToSplit = (Arc)geometry;
        Point center = arcToSplit.getCenterPoint();
        if (arcToSplit.getInitPoint().equals(arcToSplit.getEndPoint()) && center == null) {
            center = geoManager.createPoint(arcToSplit.getEnvelope().getCenter(0), arcToSplit.getEnvelope().getCenter(1), subtype);
        }
        Point firstPoint = arcToSplit.getInitPoint();
        Point endPoint = arcToSplit.getEndPoint();
        double startAngle = SplitLineOperationUtils.getAngle(center, firstPoint);
        double splitAngle = SplitLineOperationUtils.getAngle(center, projectedPoint);
        double endAngle = SplitLineOperationUtils.getAngle(center, endPoint);
        double radius = center.distance((Geometry)firstPoint);
        Arc arcSplitted1 = (Arc)geoManager.create(12, subtype);
        Arc arcSplitted2 = (Arc)geoManager.create(12, subtype);
        arcSplitted1.setPointsStartEnd(center, radius, startAngle, splitAngle);
        arcSplitted2.setPointsStartEnd(center, radius, splitAngle, endAngle);
        return new Curve[]{arcSplitted1, arcSplitted2};
    }
}

