/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.newlayer.app.extension;

import java.util.Iterator;
import java.util.Set;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.newlayer.NewLayerLocator;
import org.gvsig.newlayer.NewLayerManager;
import org.gvsig.newlayer.NewLayerProviderFactory;
import org.gvsig.newlayer.app.extension.preferences.NewLayerPreferencesPage;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.extensionpoint.ExtensionBuilder;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.service.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewLayerPreferencesExtension
extends Extension {
    private static final Logger LOG = LoggerFactory.getLogger(NewLayerPreferencesExtension.class);
    public static final String PREFERENCE_DISABLED_PROVIDERS = "disabledProviders";
    public static final String PREFERENCE_ENABLED_PROVIDERS = "enabledProviders";

    public void initialize() {
        Set enabledProviders;
        NewLayerManager providerManager = NewLayerLocator.getManager();
        DynObject preferences = this.getPlugin().getPluginProperties();
        Set disabledProviders = (Set)preferences.getDynValue(PREFERENCE_DISABLED_PROVIDERS);
        if (disabledProviders != null) {
            Iterator iterator = disabledProviders.iterator();
            while (iterator.hasNext()) {
                String providerName = null;
                try {
                    providerName = (String)iterator.next();
                    NewLayerProviderFactory factory = providerManager.getNewLayerProviderFactory(providerName);
                    providerManager.enableProvider(factory, Boolean.FALSE);
                }
                catch (ServiceException e) {
                    LOG.warn("Disabled NewLayer provider " + providerName + " is not available", (Throwable)e);
                }
            }
        }
        if ((enabledProviders = (Set)preferences.getDynValue(PREFERENCE_ENABLED_PROVIDERS)) != null) {
            Iterator iterator = enabledProviders.iterator();
            while (iterator.hasNext()) {
                String providerName = null;
                try {
                    providerName = (String)iterator.next();
                    NewLayerProviderFactory factory = providerManager.getNewLayerProviderFactory(providerName);
                    providerManager.enableProvider(factory, Boolean.TRUE);
                }
                catch (ServiceException e) {
                    LOG.warn("Enabled NewLayer provider " + providerName + " is not available", (Throwable)e);
                }
            }
        }
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint ep = extensionPoints.add("AplicationPreferences", "");
        IconThemeHelper.registerIcon((String)"preferences", (String)"newlayer-preferences", (Object)((Object)this));
        ep.append("NewLayerPreferencesPage", "", (ExtensionBuilder)new NewLayerPreferencesPage());
    }

    public void execute(String actionCommand) {
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return false;
    }
}

