/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.duplicate;

import java.awt.geom.AffineTransform;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.Aggregate;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiSurface;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.SymbologyManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.text.ISimpleTextSymbol;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class DuplicateEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private final EditingServiceParameter selection;
    private final EditingServiceParameter firstPoint;
    private final EditingServiceParameter secondPoint;
    private final EditingServiceParameter equidistantCopies;
    private final FeatureStore featureStore;
    private Map<EditingServiceParameter, Object> values;
    private List<Feature> selectedFeatures;

    public DuplicateEditingProvider(DynObject parameters, ProviderServices services) {
        super(services);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.selection = new DefaultEditingServiceParameter("selection", "selection", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.SELECTION});
        this.firstPoint = new DefaultEditingServiceParameter("first_point", "first_point", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.secondPoint = new DefaultEditingServiceParameter("second_point", "second_point", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.equidistantCopies = new DefaultEditingServiceParameter("equidistant_copies", "equidistant_copies", true, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE});
        this.equidistantCopies.setDefaultValue((Object)1);
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.selection) == null) {
            return this.selection;
        }
        if (this.values.get(this.firstPoint) == null) {
            return this.firstPoint;
        }
        if (this.values.get(this.secondPoint) == null) {
            return this.secondPoint;
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        int subtype;
        DefaultDrawingStatus drawingStatus = new DefaultDrawingStatus();
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        try {
            subtype = editingProviderServices.getSubType(this.featureStore);
        }
        catch (DataException e2) {
            throw new DrawServiceException((Throwable)e2);
        }
        ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
        ISymbol auxiliarylineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
        ISymbol polygonSymbolEditing = editingProviderManager.getSymbol("polygon-symbol-editing");
        ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
        if (this.values != null) {
            int equidistantCopiesValue;
            FeatureSelection featureSelection = (FeatureSelection)this.values.get(this.selection);
            Point firstPointValue = (Point)this.values.get(this.firstPoint);
            Number equidistantCopiesNumberValue = (Number)this.values.get(this.equidistantCopies);
            int n = equidistantCopiesValue = equidistantCopiesNumberValue != null ? equidistantCopiesNumberValue.intValue() : ((Number)this.equidistantCopies.getDefaultValue()).intValue();
            if (featureSelection != null && firstPointValue != null) {
                drawingStatus.addStatus((Geometry)firstPointValue, auxiliaryPointSymbolEditing, "");
                Point offset = GeometryUtils.createPoint((double)(mousePosition.getX() - firstPointValue.getX()), (double)(mousePosition.getY() - firstPointValue.getY()));
                Disposable it = null;
                try {
                    Point pos = null;
                    for (Feature feature : this.selectedFeatures) {
                        Point antPos = firstPointValue;
                        Geometry geometry = feature.getDefaultGeometry().cloneGeometry();
                        ISymbol previewSymbol = this.getPreviewSymbol(feature);
                        for (int c = 1; c <= equidistantCopiesValue; ++c) {
                            pos = GeometryUtils.createPoint((double)(firstPointValue.getX() + (double)c * offset.getX()), (double)(firstPointValue.getY() + (double)c * offset.getY()));
                            AffineTransform at = this.getMoveAffineTransform(firstPointValue, pos);
                            geometry.transform(at);
                            ISymbol symbol = null;
                            if (geometry instanceof Curve || geometry instanceof MultiCurve) {
                                symbol = lineSymbolEditing;
                            } else if (geometry instanceof Surface || geometry instanceof MultiSurface) {
                                symbol = polygonSymbolEditing;
                            } else if (geometry instanceof Point || geometry instanceof MultiPoint) {
                                symbol = auxiliaryPointSymbolEditing;
                            }
                            if (geometry instanceof Aggregate) {
                                int primitivesNumber = ((Aggregate)geometry).getPrimitivesNumber();
                                for (int i = 0; i < primitivesNumber; ++i) {
                                    drawingStatus.addStatus((Geometry)((Aggregate)geometry).getPrimitiveAt(i), symbol, "");
                                    drawingStatus.addStatus((Geometry)((Aggregate)geometry).getPrimitiveAt(i), previewSymbol, "");
                                }
                            } else {
                                drawingStatus.addStatus(geometry, symbol, "");
                                drawingStatus.addStatus(geometry, previewSymbol, "");
                            }
                            antPos = pos;
                        }
                    }
                    if (pos != null) {
                        Line auxLine = GeometryUtils.createLine((Point)firstPointValue, pos, (int)subtype);
                        drawingStatus.addStatus((Geometry)auxLine, auxiliarylineSymbolEditing, "");
                    }
                    Point pointText = GeometryUtils.createPoint((double)(firstPointValue.getX() + 0.5 * offset.getX()), (double)(firstPointValue.getY() + 0.5 * offset.getY()));
                    ISimpleTextSymbol textSymbol = this.getTextSymbol();
                    drawingStatus.addStatus((Geometry)pointText, (ISymbol)textSymbol, new DecimalFormat("#.0#").format(Math.sqrt(Math.pow(offset.getX(), 2.0) + Math.pow(offset.getY(), 2.0))));
                }
                catch (BaseException e) {
                    throw new DrawServiceException((Throwable)e);
                }
                finally {
                    DisposeUtils.disposeQuietly(it);
                }
            }
        }
        return drawingStatus;
    }

    private AffineTransform getMoveAffineTransform(Point p1, Point p2) throws GeometryOperationNotSupportedException, GeometryOperationException {
        AffineTransform translate = AffineTransform.getTranslateInstance(p2.getX() - p1.getX(), p2.getY() - p1.getY());
        return translate;
    }

    public void stop() throws StopServiceException {
        if (this.values != null) {
            this.values.clear();
        }
        this.selectedFeatures = Collections.EMPTY_LIST;
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.selection);
        parameters.add(this.firstPoint);
        parameters.add(this.secondPoint);
        parameters.add(this.equidistantCopies);
        return parameters;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter parameter = this.next();
        this.validateAndInsertValue(parameter, value);
    }

    private void validateAndInsertValue(EditingServiceParameter parameter, Object value) {
        int intValue;
        if (parameter == this.selection) {
            if (value instanceof FeatureSelection && ((FeatureSelection)value).getSelectedCount() > 0L) {
                this.values.put(this.selection, value);
                this.selectedFeatures = this.getSelectedFeaturesCopy((FeatureSelection)value);
            }
        } else if (parameter == this.firstPoint || parameter == this.secondPoint) {
            if (value instanceof Point) {
                this.values.put(parameter, value);
            }
        } else if (parameter == this.equidistantCopies && value instanceof Number && (intValue = ((Number)value).intValue()) >= 1) {
            this.values.put(parameter, ((Number)value).intValue());
        }
    }

    public Geometry finish() throws FinishServiceException {
        return null;
    }

    public void finishAndStore() throws FinishServiceException {
        if (this.values != null) {
            Point p1 = (Point)this.values.get(this.firstPoint);
            Point p2 = (Point)this.values.get(this.secondPoint);
            Number equidistantCopiesNumberValue = (Number)this.values.get(this.equidistantCopies);
            int equidistantCopiesValue = equidistantCopiesNumberValue != null ? equidistantCopiesNumberValue.intValue() : ((Number)this.equidistantCopies.getDefaultValue()).intValue();
            try {
                for (Feature feature : this.selectedFeatures) {
                    EditingProviderServices editingProviderServices = this.getProviderServices();
                    Point offset = GeometryUtils.createPoint((double)(p2.getX() - p1.getX()), (double)(p2.getY() - p1.getY()));
                    for (int c = 1; c <= equidistantCopiesValue; ++c) {
                        EditableFeature editable = editingProviderServices.getFeatureCopyWithoutUniqueIndex(this.featureStore, feature);
                        Geometry geometry = feature.getDefaultGeometry().cloneGeometry();
                        Point pos = GeometryUtils.createPoint((double)(p1.getX() + (double)c * offset.getX()), (double)(p1.getY() + (double)c * offset.getY()));
                        geometry.transform(this.getMoveAffineTransform(p1, pos));
                        editable.setDefaultGeometry(geometry);
                        editingProviderServices.insertFeatureIntoFeatureStore((Feature)editable, this.featureStore);
                    }
                }
            }
            catch (BaseException e) {
                throw new FinishServiceException((Throwable)e);
            }
        }
    }

    public void start() throws StartServiceException, InvalidEntryException {
        this.values = new HashMap<EditingServiceParameter, Object>();
        this.selectedFeatures = Collections.EMPTY_LIST;
        if (this.featureStore != null) {
            FeatureSelection selected = null;
            try {
                selected = (FeatureSelection)this.featureStore.getFeatureSelection().clone();
            }
            catch (DataException e) {
                throw new StartServiceException((Throwable)e);
            }
            catch (CloneNotSupportedException ex) {
                LOGGER.debug("Can't init selection", (Throwable)ex);
            }
            if (selected != null && selected.getSelectedCount() > 0L) {
                this.values.put(this.selection, selected);
                this.selectedFeatures = this.getSelectedFeaturesCopy(selected);
            }
        }
    }

    public void restart() throws StartServiceException, InvalidEntryException, StopServiceException {
        this.values.put(this.secondPoint, null);
    }

    public String getName() {
        return "modify-duplicate";
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }

    private ISimpleTextSymbol getTextSymbol() {
        SymbologyManager symbologyManager = SymbologyLocator.getSymbologyManager();
        ISimpleTextSymbol textSymbol = symbologyManager.createSimpleTextSymbol();
        textSymbol.setFontSize(10.0);
        return textSymbol;
    }

    public boolean isEnabled(EditingServiceParameter parameter) {
        if (parameter == this.equidistantCopies) {
            return true;
        }
        return true;
    }
}

