/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.duplicate;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.Aggregate;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiSurface;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.EditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class MeasureEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    protected final EditingServiceParameter selection;
    protected final EditingServiceParameter insertionPointParameter;
    protected final EditingServiceParameter geometryBaseParameter;
    private final EditingServiceParameter measureParameter;
    protected final EditingServiceParameter alignParameter;
    protected final EditingServiceParameter rotateFieldParameter;
    protected final EditingServiceParameter deleteOriginalGeometriesParameter;
    protected final FeatureStore featureStore;
    protected final MapContext mapContext;
    protected Map<EditingServiceParameter, Object> values;

    public MeasureEditingProvider(DynObject parameters, ProviderServices services) {
        super(services);
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.mapContext = (MapContext)parameters.getDynValue("mapContext");
        this.selection = new DefaultEditingServiceParameter("selection", "selection", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.SELECTION});
        this.insertionPointParameter = new DefaultEditingServiceParameter("_insertion_point", "_insertion_point", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.geometryBaseParameter = new DefaultEditingServiceParameter("_geometry_base", "_geometry_base", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.measureParameter = new DefaultEditingServiceParameter("_measure", "_measure", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE}).setDataType(7);
        DefaultEditingServiceParameterOptions alignOptions2 = new DefaultEditingServiceParameterOptions().add("_align", (Object)true, i18nManager.getTranslation("_yes")).add("_dont_align", (Object)false, i18nManager.getTranslation("_no"));
        String alignConsoleMsg = editingProviderServices.makeConsoleMessage("_align", (EditingServiceParameterOptions)alignOptions2);
        this.alignParameter = new DefaultEditingServiceParameter("_align", alignConsoleMsg, (EditingServiceParameterOptions)alignOptions2, (Object)i18nManager.getTranslation("_no"), true, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.OPTION}).setDataType(1);
        DefaultEditingServiceParameterOptions rotateFieldOptions2 = new DefaultEditingServiceParameterOptions();
        Iterable attrs = this.featureStore.getDefaultFeatureTypeQuietly().getAllAttributeDescriptors();
        for (FeatureAttributeDescriptor attr : attrs) {
            if (!attr.getDataType().isNumeric()) continue;
            rotateFieldOptions2.add(attr.getLabel(), (Object)attr.getName(), attr.getShortLabel());
        }
        this.rotateFieldParameter = new DefaultEditingServiceParameter("_rotate_field", "_rotate_field", (EditingServiceParameterOptions)rotateFieldOptions2, null, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.OPTION});
        DefaultEditingServiceParameterOptions deleteOriginalGeometriesOptions2 = new DefaultEditingServiceParameterOptions().add("delete_original_geometries", (Object)true, i18nManager.getTranslation("_yes")).add("keep_original_geometries", (Object)false, i18nManager.getTranslation("_no"));
        String consoleMsg = editingProviderServices.makeConsoleMessage("delete_original_geometries_question", (EditingServiceParameterOptions)deleteOriginalGeometriesOptions2);
        this.deleteOriginalGeometriesParameter = new DefaultEditingServiceParameter(i18nManager.getTranslation("delete_original_geometries"), consoleMsg, (EditingServiceParameterOptions)deleteOriginalGeometriesOptions2, (Object)false, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.OPTION}).setDataType(1);
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.selection) == null) {
            return this.selection;
        }
        if (this.values.get(this.insertionPointParameter) == null) {
            return this.insertionPointParameter;
        }
        if (this.values.get(this.geometryBaseParameter) == null) {
            return this.geometryBaseParameter;
        }
        if (this.values.get(this.measureParameter) == null) {
            return this.measureParameter;
        }
        if (this.values.get(this.alignParameter) == null) {
            return this.alignParameter;
        }
        if (((Boolean)this.values.get(this.alignParameter)).booleanValue() && this.isPointType() && this.values.get(this.rotateFieldParameter) == null) {
            return this.rotateFieldParameter;
        }
        if (this.values.get(this.deleteOriginalGeometriesParameter) == null) {
            return this.deleteOriginalGeometriesParameter;
        }
        return null;
    }

    protected boolean isPointType() {
        return this.featureStore.getDefaultFeatureTypeQuietly().getDefaultGeometryAttribute().getGeomType().getType() == 1;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        int subtype;
        DefaultDrawingStatus drawingStatus = new DefaultDrawingStatus();
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        try {
            subtype = editingProviderServices.getSubType(this.featureStore);
        }
        catch (DataException e2) {
            throw new DrawServiceException((Throwable)e2);
        }
        ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
        ISymbol auxiliarylineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
        ISymbol polygonSymbolEditing = editingProviderManager.getSymbol("polygon-symbol-editing");
        ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
        if (this.values != null) {
            FeatureSelection featureSelection = (FeatureSelection)this.values.get(this.selection);
            Point insertionPointValue = (Point)this.values.get(this.insertionPointParameter);
            if (featureSelection != null && insertionPointValue != null) {
                drawingStatus.addStatus((Geometry)insertionPointValue, auxiliaryPointSymbolEditing, "");
                try {
                    Line auxLine = geometryManager.createLine(subtype);
                }
                catch (CreateGeometryException e1) {
                    throw new DrawServiceException((Throwable)e1);
                }
                MultiLine geometryBaseValue = (MultiLine)this.values.get(this.geometryBaseParameter);
                if (geometryBaseValue != null) {
                    for (Geometry geometry : geometryBaseValue) {
                        List<PointAndRotation> pointsAndRotation;
                        Line line = (Line)geometry;
                        try {
                            pointsAndRotation = this.getPointsAndRotations(line);
                        }
                        catch (Exception ex) {
                            throw new DrawServiceException((Throwable)ex);
                        }
                        if (pointsAndRotation == null) continue;
                        for (PointAndRotation pointAndRotation : pointsAndRotation) {
                            DisposableIterator it = null;
                            try {
                                it = featureSelection.fastIterator();
                                while (it.hasNext()) {
                                    Feature feature = (Feature)it.next();
                                    ISymbol previewSymbol = this.getPreviewSymbol(feature);
                                    Geometry geom = feature.getDefaultGeometry().cloneGeometry();
                                    AffineTransform at = this.getMoveAffineTransform(insertionPointValue, pointAndRotation.getPoint());
                                    geom.transform(at);
                                    Boolean alignValue = (Boolean)this.values.get(this.alignParameter);
                                    if (alignValue != null && alignValue.equals(Boolean.TRUE)) {
                                        AffineTransform rotateTransform = this.getRotateAffineTransform(pointAndRotation.getPoint(), pointAndRotation.getAngle());
                                        geom.transform(rotateTransform);
                                    }
                                    ISymbol symbol = null;
                                    if (geom instanceof Curve || geom instanceof MultiCurve) {
                                        symbol = lineSymbolEditing;
                                    } else if (geom instanceof Surface || geom instanceof MultiSurface) {
                                        symbol = polygonSymbolEditing;
                                    } else if (geom instanceof Point || geom instanceof MultiPoint) {
                                        symbol = auxiliaryPointSymbolEditing;
                                    }
                                    if (geom instanceof Aggregate) {
                                        int primitivesNumber = ((Aggregate)geometry).getPrimitivesNumber();
                                        for (int i = 0; i < primitivesNumber; ++i) {
                                            drawingStatus.addStatus((Geometry)((Aggregate)geom).getPrimitiveAt(i), symbol, "");
                                            drawingStatus.addStatus((Geometry)((Aggregate)geom).getPrimitiveAt(i), previewSymbol, "");
                                        }
                                        continue;
                                    }
                                    drawingStatus.addStatus(geom, symbol, "");
                                    drawingStatus.addStatus(geom, previewSymbol, "");
                                }
                            }
                            catch (BaseException e) {
                                throw new DrawServiceException((Throwable)e);
                            }
                            finally {
                                DisposeUtils.disposeQuietly((Disposable)it);
                            }
                        }
                    }
                }
            }
        }
        return drawingStatus;
    }

    private AffineTransform getMoveAffineTransform(Point p1, Point p2) throws GeometryOperationNotSupportedException, GeometryOperationException {
        AffineTransform translate = AffineTransform.getTranslateInstance(p2.getX() - p1.getX(), p2.getY() - p1.getY());
        return translate;
    }

    private AffineTransform getRotateAffineTransform(Point p, double angle) throws GeometryOperationNotSupportedException, GeometryOperationException {
        AffineTransform rotate = AffineTransform.getRotateInstance(angle, p.getX(), p.getY());
        return rotate;
    }

    public void stop() throws StopServiceException {
        if (this.values != null) {
            this.values.clear();
        }
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.selection);
        parameters.add(this.insertionPointParameter);
        parameters.add(this.geometryBaseParameter);
        parameters.add(this.measureParameter);
        parameters.add(this.alignParameter);
        parameters.add(this.rotateFieldParameter);
        parameters.add(this.deleteOriginalGeometriesParameter);
        return parameters;
    }

    public boolean isEnabled(EditingServiceParameter parameter) {
        return true;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter parameter = this.next();
        this.validateAndInsertValue(parameter, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateAndInsertValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        if (parameter == this.selection) {
            if (!(value instanceof FeatureSelection) || ((FeatureSelection)value).getSelectedCount() <= 0L) return;
            this.values.put(this.selection, value);
            return;
        }
        if (parameter == this.insertionPointParameter) {
            if (!(value instanceof Point)) return;
            this.values.put(parameter, value);
            return;
        }
        if (parameter == this.geometryBaseParameter && value instanceof Point) {
            Point point;
            Geometry geometry;
            if (!(value instanceof Point) || (geometry = this.getGeometry(point = (Point)value)) == null) return;
            try {
                if (!(geometry instanceof Curve || geometry instanceof MultiCurve || geometry instanceof Surface || geometry instanceof MultiSurface)) {
                    throw new InvalidEntryException(null);
                }
                this.values.put(parameter, geometry.toLines());
                return;
            }
            catch (Exception ex) {
                throw new InvalidEntryException((Throwable)ex);
            }
        }
        if (parameter.equals(this.measureParameter)) {
            if (!(value instanceof Double)) throw new InvalidEntryException(null);
            this.values.put(parameter, value);
            return;
        } else if (parameter == this.rotateFieldParameter) {
            this.values.put(parameter, parameter.getOptions2().getValue(value, parameter.getDefaultValue()));
            return;
        } else if (parameter == this.alignParameter) {
            this.values.put(parameter, parameter.getOptions2().getValue(value, parameter.getDefaultValue()));
            return;
        } else {
            if (parameter != this.deleteOriginalGeometriesParameter) return;
            this.values.put(parameter, parameter.getOptions2().getValue(value, parameter.getDefaultValue()));
        }
    }

    private Geometry getGeometry(Point point) {
        EditingProviderServices editingProviderServices = this.getProviderServices();
        Geometry geometry = editingProviderServices.getGeometryOfVisibleLayers(point, this.featureStore, this.mapContext);
        return geometry;
    }

    public Geometry finish() throws FinishServiceException {
        return null;
    }

    public void finishAndStore() throws FinishServiceException {
        if (this.values != null) {
            Point insertionPointValue = (Point)this.values.get(this.insertionPointParameter);
            MultiLine geometryBaseValue = (MultiLine)this.values.get(this.geometryBaseParameter);
            Boolean alignValue = (Boolean)this.values.get(this.alignParameter);
            String rotateFieldValue = (String)this.values.get(this.rotateFieldParameter);
            Boolean deleteOriginalGeometriesValue = (Boolean)this.values.get(this.deleteOriginalGeometriesParameter);
            FeatureSelection featureSelection = (FeatureSelection)this.values.get(this.selection);
            ToolsLocator.getDisposableManager().bind((Disposable)featureSelection);
            try {
                for (Geometry geometry : geometryBaseValue) {
                    List<PointAndRotation> pointsAndRotations;
                    Line line = (Line)geometry;
                    try {
                        pointsAndRotations = this.getPointsAndRotations(line);
                    }
                    catch (Exception ex) {
                        throw new DrawServiceException((Throwable)ex);
                    }
                    if (pointsAndRotations == null) {
                        return;
                    }
                    for (PointAndRotation pointAndRotation : pointsAndRotations) {
                        Object it = null;
                        featureSelection.accept(obj -> {
                            Feature feature = (Feature)obj;
                            EditingProviderServices editingProviderServices = this.getProviderServices();
                            EditableFeature editable = editingProviderServices.getFeatureCopyWithoutUniqueIndex(this.featureStore, feature);
                            Geometry geom = feature.getDefaultGeometry().cloneGeometry();
                            AffineTransform at = this.getMoveAffineTransform(insertionPointValue, pointAndRotation.getPoint());
                            geom.transform(at);
                            if (alignValue != null && alignValue.equals(Boolean.TRUE)) {
                                FeatureAttributeDescriptor attr;
                                FeatureType featType;
                                AffineTransform rotateTransform = this.getRotateAffineTransform(pointAndRotation.getPoint(), pointAndRotation.getAngle());
                                geom.transform(rotateTransform);
                                if (rotateFieldValue != null && (featType = this.featureStore.getDefaultFeatureTypeQuietly()) != null && (attr = featType.getAttributeDescriptor(rotateFieldValue)) != null) {
                                    editable.set(rotateFieldValue, (Object)(-Math.toDegrees(pointAndRotation.getAngle() - 1.5707963267948966)));
                                }
                            }
                            editable.setDefaultGeometry(geom);
                            editingProviderServices.insertFeatureIntoFeatureStore((Feature)editable, this.featureStore);
                        });
                    }
                }
                if (deleteOriginalGeometriesValue.booleanValue()) {
                    for (Feature feature : this.featureStore.getFeatureSelection()) {
                        this.featureStore.delete(feature);
                    }
                }
                this.featureStore.getFeatureSelection().deselectAll();
                featureSelection.dispose();
            }
            catch (BaseException e) {
                throw new FinishServiceException((Throwable)e);
            }
        }
    }

    public void start() throws StartServiceException, InvalidEntryException {
        this.values = new HashMap<EditingServiceParameter, Object>();
        FeatureSelection selected = null;
        if (this.featureStore != null) {
            try {
                selected = this.featureStore.getFeatureSelection();
            }
            catch (DataException e) {
                throw new StartServiceException((Throwable)e);
            }
            try {
                this.setValue(selected);
            }
            catch (InvalidEntryException e) {
                throw new InvalidEntryException((Throwable)e);
            }
        }
    }

    public String getName() {
        return "modify-measure";
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }

    protected List<PointAndRotation> getPointsAndRotations(Line line) throws CreateGeometryException, GeometryOperationNotSupportedException, GeometryOperationException, CloneNotSupportedException {
        Double measureValue = (Double)this.values.get(this.measureParameter);
        if (measureValue == null) {
            return null;
        }
        return this.getPointsAndRotations(line, measureValue);
    }

    protected List<PointAndRotation> getPointsAndRotations(Line line, double measure) throws CreateGeometryException, GeometryOperationNotSupportedException, GeometryOperationException, CloneNotSupportedException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        ArrayList<PointAndRotation> res = new ArrayList<PointAndRotation>();
        if (line.getNumVertices() <= 1) {
            return res;
        }
        Point previousPoint = null;
        double previousLength = 0.0;
        if (line.isClosed()) {
            Point v0 = line.getVertex(0);
            boolean i = true;
            Point v1 = line.getVertex(1);
            PointAndRotation rotatedPoint = new PointAndRotation(line.getVertex(0), GeometryUtils.calculateAngle((Point)v0, (Point)v1));
            res.add(rotatedPoint);
        }
        boolean advanceToNext = true;
        Iterator it = line.iterator();
        Point currentPoint = null;
        while (it.hasNext() || !advanceToNext) {
            if (advanceToNext) {
                currentPoint = (Point)it.next();
            }
            if (previousPoint == null) {
                previousPoint = currentPoint.clone();
                advanceToNext = true;
                continue;
            }
            double distance = previousPoint.distance((Geometry)currentPoint);
            if (previousLength + distance < measure) {
                previousLength += distance;
                previousPoint = currentPoint.cloneGeometry();
                advanceToNext = true;
                continue;
            }
            Point point = GeometryUtils.calculateLambdaPoint((Point)previousPoint, (Point)currentPoint, (double)((measure - previousLength) / distance));
            PointAndRotation rotatedPoint = new PointAndRotation(point, GeometryUtils.calculateAngle((Point)previousPoint, (Point)currentPoint));
            res.add(rotatedPoint);
            previousPoint = point.clone();
            previousLength = 0.0;
            advanceToNext = false;
        }
        return res;
    }

    public static class PointAndRotation {
        private Point point;
        private double angle;

        public PointAndRotation(Point point, double angle) {
            this.point = point;
            this.angle = angle;
        }

        public void setPoint(Point point) {
            this.point = point;
        }

        public Point getPoint() {
            return this.point;
        }

        public void setAngle(double angle) {
            this.angle = angle;
        }

        public double getAngle() {
            return this.angle;
        }
    }
}

