/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts;

import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.geojson.GeoJsonReader;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryCoercionContext;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.InformationbuilderWithGeometrySupport;
import org.gvsig.fmap.geom.SpatialIndex;
import org.gvsig.fmap.geom.SpatialIndexFactory;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.fmap.geom.aggregate.MultiSurface;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.jts.BaseInformationBuilderWithGeometrySupport;
import org.gvsig.fmap.geom.jts.DefaultGeometryType;
import org.gvsig.fmap.geom.jts.coerce.DefaultGeometryCoercionContext;
import org.gvsig.fmap.geom.jts.gputils.DefaultGeneralPathX;
import org.gvsig.fmap.geom.jts.primitive.DefaultNullGeometry;
import org.gvsig.fmap.geom.jts.primitive.Envelope2D;
import org.gvsig.fmap.geom.jts.primitive.Envelope3D;
import org.gvsig.fmap.geom.jts.util.GMLUtils;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.operation.GeometryOperation;
import org.gvsig.fmap.geom.operation.GeometryOperationContext;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.IGeneralPathX;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.NullGeometry;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.geom.type.GeometryTypeNotSupportedException;
import org.gvsig.fmap.geom.type.GeometryTypeNotValidException;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.library.impl.DefaultLibrariesInitializer;
import org.gvsig.tools.service.Service;
import org.gvsig.tools.service.ServiceException;
import org.gvsig.tools.service.spi.ServiceFactory;
import org.gvsig.tools.service.spi.ServiceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGeometryManager
implements GeometryManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeometryManager.class);
    private final int GEOMETRY_TYPE_OFFSET = 1;
    private double flatness = 0.8;
    private final Map spatialIndexFactories = new HashMap();
    private final List geometryOperations = new ArrayList();
    private final Map<String, GeometryType> geometryTypeName = new HashMap<String, GeometryType>();
    private GeometryType[][] geometryTypes;
    private static final int DEFAULT_TYPES_SIZE = 27;
    private static final int DEFAULT_SUBTYPES_SIZE = 6;

    public DefaultGeometryManager() throws GeometryException {
        this(27, 6);
    }

    public DefaultGeometryManager(int initialTypesSize, int initialSubtypesSize) throws GeometryException {
        this.geometryTypes = new GeometryType[initialTypesSize][initialSubtypesSize];
    }

    public int registerGeometryOperation(String geomOpName, GeometryOperation geomOp, GeometryType geomType) {
        if (geomOp == null) {
            throw new IllegalArgumentException("geomOp cannot be null.");
        }
        if (geomType == null) {
            throw new IllegalArgumentException("geomType cannot be null.");
        }
        int index = this.getGeometryOperationCode(geomOpName);
        geomType.setGeometryOperation(index, geomOp);
        return index;
    }

    public int registerGeometryOperation(String geomOpName, GeometryOperation geomOp) {
        if (geomOpName == null) {
            throw new IllegalArgumentException("geomOpName cannot be null.");
        }
        if (geomOp == null) {
            throw new IllegalArgumentException("geomOp cannot be null.");
        }
        int index = this.getGeometryOperationCode(geomOpName);
        for (GeometryType geometryType : this.geometryTypeName.values()) {
            this.registerGeometryOperation(geomOpName, geomOp, geometryType);
        }
        return index;
    }

    public int registerGeometryOperation(String geomOpName, GeometryOperation geomOp, int type, int subType) throws GeometryTypeNotSupportedException, GeometryTypeNotValidException {
        GeometryType geometryType = this.getGeometryType(type, subType);
        return this.registerGeometryOperation(geomOpName, geomOp, geometryType);
    }

    public int registerGeometryOperation(String geomOpName, GeometryOperation geomOp, int type) {
        int code = -1;
        for (GeometryType geometryType : this.geometryTypeName.values()) {
            if (type != geometryType.getType()) continue;
            code = this.registerGeometryOperation(geomOpName, geomOp, geometryType);
        }
        return code;
    }

    public int registerGeometryOperationBySubtype(String geomOpName, GeometryOperation geomOp, int subType) {
        int code = -1;
        for (GeometryType geometryType : this.geometryTypeName.values()) {
            if (subType != geometryType.getSubType()) continue;
            code = this.registerGeometryOperation(geomOpName, geomOp, geometryType);
        }
        return code;
    }

    public int registerGeometryOperationBySuperType(String geomOpName, GeometryOperation geomOp, int superType) {
        int code = -1;
        for (GeometryType geometryType : this.geometryTypeName.values()) {
            if (!geometryType.isTypeOf(superType)) continue;
            code = this.registerGeometryOperation(geomOpName, geomOp, geometryType);
        }
        return code;
    }

    public int registerGeometryOperationBySuperSubType(String geomOpName, GeometryOperation geomOp, int superSubType) {
        int code = -1;
        for (GeometryType geometryType : this.geometryTypeName.values()) {
            if (!geometryType.isSubTypeOf(superSubType)) continue;
            code = this.registerGeometryOperation(geomOpName, geomOp, geometryType);
        }
        return code;
    }

    public GeometryType registerGeometryType(Class geomClass, String name, int type, int subType) {
        return this.registerGeometryType(geomClass, name, type, subType, new int[0], new int[0]);
    }

    public GeometryType registerGeometryType(Class geomClass, String name, int type, int subType, int superType, int superSubType) {
        return this.registerGeometryType(geomClass, name, type, subType, new int[]{superType}, new int[]{superSubType});
    }

    public GeometryType registerGeometryType(Class geomClass, String name, int type, int subType, int superType) {
        return this.registerGeometryType(geomClass, name, type, subType, new int[]{superType}, new int[0]);
    }

    public GeometryType registerGeometryType(Class geomClass, String name, int type, int subType, int[] superTypes) {
        return this.registerGeometryType(geomClass, name, type, subType, superTypes, new int[0]);
    }

    public GeometryType registerGeometryType(Class geomClass, String name, int type, int subType, int[] superTypes, int[] superSubTypes) {
        if (geomClass == null) {
            throw new IllegalArgumentException("geomClass cannot be null.");
        }
        if (!Geometry.class.isAssignableFrom(geomClass)) {
            throw new IllegalArgumentException(geomClass.getName() + " must implement the Geometry interface");
        }
        int offsettedType = type + 1;
        DefaultGeometryType geomType = null;
        if (offsettedType >= this.geometryTypes.length || subType >= this.geometryTypes[0].length || (geomType = this.geometryTypes[offsettedType][subType]) == null) {
            geomType = new DefaultGeometryType(geomClass, name, type, subType, superTypes, superSubTypes);
            this.registerGeometryType((GeometryType)geomType);
        }
        LOGGER.debug("Class {} registered with name {}", (Object)geomClass, (Object)geomType.getName());
        return geomType;
    }

    public GeometryType registerGeometryType(GeometryType geometryType) {
        int offsettedType = geometryType.getType() + 1;
        if (offsettedType >= this.geometryTypes.length || geometryType.getSubType() >= this.geometryTypes[0].length) {
            int newTypesSize = offsettedType < this.geometryTypes.length ? this.geometryTypes.length : offsettedType + 1;
            int newSubTypesSize = geometryType.getSubType() < this.geometryTypes[0].length ? this.geometryTypes[0].length : geometryType.getSubType() + 1;
            GeometryType[][] newMatrix = new GeometryType[newTypesSize][newSubTypesSize];
            for (int i = 0; i < this.geometryTypes.length; ++i) {
                System.arraycopy(this.geometryTypes[i], 0, newMatrix[i], 0, this.geometryTypes[i].length);
            }
            this.geometryTypes = newMatrix;
        }
        this.geometryTypes[offsettedType][geometryType.getSubType()] = geometryType;
        this.geometryTypeName.put(geometryType.getName(), geometryType);
        return geometryType;
    }

    public GeometryType registerGeometryType(Class geomClass, int type, int subType) {
        return this.registerGeometryType(geomClass, null, type, subType);
    }

    public GeometryType getGeometryType(String typeName) throws GeometryTypeNotSupportedException, GeometryTypeNotValidException {
        for (Map.Entry<String, GeometryType> entry : this.geometryTypeName.entrySet()) {
            String key = entry.getKey();
            GeometryType geomType = entry.getValue();
            if (StringUtils.equalsIgnoreCase((CharSequence)typeName, (CharSequence)key)) {
                return geomType;
            }
            if (geomType == null) continue;
            for (String alias : geomType.getAlias()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)typeName, (CharSequence)alias)) continue;
                return geomType;
            }
        }
        return null;
    }

    public GeometryType getGeometryType(int type, int subType) throws GeometryTypeNotSupportedException, GeometryTypeNotValidException {
        int offsettedType = type + 1;
        if (offsettedType >= this.geometryTypes.length || subType >= this.geometryTypes[0].length) {
            throw new GeometryTypeNotValidException(type, subType);
        }
        GeometryType gType = this.geometryTypes[offsettedType][subType];
        if (gType == null) {
            throw new GeometryTypeNotSupportedException(type, subType);
        }
        return gType;
    }

    public Geometry create(GeometryType geomType) throws CreateGeometryException {
        return geomType.create();
    }

    public Geometry create(String name) throws CreateGeometryException {
        if (!this.geometryTypeName.containsKey(name)) {
            throw new IllegalArgumentException(name + " has not been registered yet.");
        }
        return this.geometryTypeName.get(name).create();
    }

    public Geometry create(int type, int subType) throws CreateGeometryException {
        try {
            return this.getGeometryType(type, subType).create();
        }
        catch (GeometryException e) {
            throw new CreateGeometryException(type, subType, (Throwable)e);
        }
    }

    public Curve createCurve(GeneralPathX generalPathX, int subType) throws CreateGeometryException {
        Curve curve = (Curve)this.create(2, subType);
        curve.setGeneralPath(generalPathX);
        return curve;
    }

    public NullGeometry createNullGeometry(int subType) throws CreateGeometryException {
        NullGeometry nullGeom = (NullGeometry)this.create(16, subType);
        return nullGeom;
    }

    public Point createPoint(double x, double y, int subType) throws CreateGeometryException {
        Point point = (Point)this.create(1, subType);
        point.setX(x);
        point.setY(y);
        return point;
    }

    public Surface createSurface(GeneralPathX generalPathX, int subType) throws CreateGeometryException {
        Surface surface = (Surface)this.create(3, subType);
        surface.setGeneralPath(generalPathX);
        return surface;
    }

    public GeometryOperation getGeometryOperation(int opCode, int type, int subType) throws GeometryTypeNotSupportedException, GeometryOperationNotSupportedException, GeometryTypeNotValidException {
        GeometryType geometryType = this.getGeometryType(type, subType);
        return geometryType.getGeometryOperation(opCode);
    }

    public GeometryOperation getGeometryOperation(int opCode) throws GeometryOperationNotSupportedException {
        if (opCode < 0) {
            throw new GeometryOperationNotSupportedException(opCode);
        }
        GeometryType type = this.geometryTypeName.get(DefaultNullGeometry.class.getName());
        if (type == null) {
            throw new GeometryOperationNotSupportedException(opCode);
        }
        return type.getGeometryOperation(opCode);
    }

    public Object invokeOperation(int opCode, Geometry geom, GeometryOperationContext ctx) throws GeometryOperationNotSupportedException, GeometryOperationException {
        GeometryOperation geomOp = geom.getGeometryType().getGeometryOperation(opCode);
        if (geomOp != null) {
            return geomOp.invoke(geom, ctx);
        }
        throw new GeometryOperationNotSupportedException(opCode, geom.getGeometryType());
    }

    public Object invokeOperation(String geomOpName, Geometry geom, GeometryOperationContext ctx) throws GeometryOperationNotSupportedException, GeometryOperationException {
        int index = this.geometryOperations.indexOf(geomOpName);
        if (index == -1) {
            throw new GeometryOperationNotSupportedException(-1);
        }
        return this.invokeOperation(index, geom, ctx);
    }

    public Object invokeOperation(String geomOpName, GeometryOperationContext ctx) throws GeometryOperationNotSupportedException, GeometryOperationException {
        int index = this.geometryOperations.indexOf(geomOpName);
        GeometryOperation geomOp = this.getGeometryOperation(index);
        return geomOp.invoke(null, ctx);
    }

    public Envelope createEnvelope(int subType) {
        switch (subType) {
            case 1: {
                return new Envelope3D();
            }
        }
        return new Envelope2D();
    }

    public Envelope createEnvelope(double minX, double minY, double maxX, double maxY, int subType) throws CreateEnvelopeException {
        Point min = null;
        Point max = null;
        try {
            min = this.createPoint(minX, minY, subType);
            max = this.createPoint(maxX, maxY, subType);
        }
        catch (CreateGeometryException e) {
            throw new CreateEnvelopeException(subType, (Throwable)e);
        }
        switch (subType) {
            case 0: 
            case 2: {
                return new Envelope2D(min, max, null);
            }
        }
        Envelope envelope = this.createEnvelope(subType);
        envelope.setLowerCorner(min);
        envelope.setUpperCorner(max);
        return envelope;
    }

    public MultiCurve createMultiCurve(GeneralPathX generalPathX, int subType) throws CreateGeometryException {
        Curve tmpCurve;
        if (subType != 0) {
            throw new UnsupportedOperationException();
        }
        MultiCurve multiCurve = (MultiCurve)this.create(8, subType);
        PathIterator piter = generalPathX.getPathIterator(null);
        GeneralPathX tmpPath = null;
        double[] coords = new double[6];
        double[] first = new double[6];
        while (!piter.isDone()) {
            int type = piter.currentSegment(coords);
            switch (type) {
                case 0: {
                    if (tmpPath != null) {
                        tmpCurve = this.createCurve(tmpPath, subType);
                        multiCurve.addCurve(tmpCurve);
                    }
                    System.arraycopy(coords, 0, first, 0, 2);
                    tmpPath = new GeneralPathX(piter.getWindingRule());
                    tmpPath.moveTo(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    if (tmpPath == null) {
                        System.arraycopy(coords, 0, first, 0, 2);
                        tmpPath = new GeneralPathX(piter.getWindingRule());
                    }
                    tmpPath.lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    if (tmpPath == null) {
                        System.arraycopy(coords, 0, first, 0, 2);
                        tmpPath = new GeneralPathX(piter.getWindingRule());
                    }
                    tmpPath.quadTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    if (tmpPath == null) {
                        System.arraycopy(coords, 0, first, 0, 2);
                        tmpPath = new GeneralPathX(piter.getWindingRule());
                    }
                    tmpPath.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 4: {
                    tmpPath.lineTo(first[0], first[1]);
                }
            }
            piter.next();
        }
        if (tmpPath != null) {
            tmpCurve = this.createCurve(tmpPath, subType);
            multiCurve.addCurve(tmpCurve);
        }
        return multiCurve;
    }

    public MultiSurface createMultiSurface(GeneralPathX generalPathX, int subType) throws CreateGeometryException {
        Surface tmpSurface;
        if (subType != 0) {
            throw new UnsupportedOperationException();
        }
        MultiSurface multiSurface = (MultiSurface)this.create(9, subType);
        PathIterator piter = generalPathX.getPathIterator(null);
        GeneralPathX tmpPath = null;
        double[] coords = new double[6];
        double[] first = new double[6];
        while (!piter.isDone()) {
            int type = piter.currentSegment(coords);
            switch (type) {
                case 0: {
                    if (tmpPath != null) {
                        tmpSurface = this.createSurface(tmpPath, subType);
                        multiSurface.addSurface(tmpSurface);
                    }
                    System.arraycopy(coords, 0, first, 0, 2);
                    tmpPath = new GeneralPathX(piter.getWindingRule());
                    tmpPath.moveTo(coords[0], coords[1]);
                }
                case 1: {
                    if (tmpPath == null) {
                        System.arraycopy(coords, 0, first, 0, 2);
                        tmpPath = new GeneralPathX(piter.getWindingRule());
                    }
                    tmpPath.lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    if (tmpPath == null) {
                        System.arraycopy(coords, 0, first, 0, 2);
                        tmpPath = new GeneralPathX(piter.getWindingRule());
                    }
                    tmpPath.quadTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    if (tmpPath == null) {
                        System.arraycopy(coords, 0, first, 0, 2);
                        tmpPath = new GeneralPathX(piter.getWindingRule());
                    }
                    tmpPath.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 4: {
                    tmpPath.lineTo(first[0], first[1]);
                }
            }
            piter.next();
        }
        if (tmpPath != null) {
            tmpSurface = this.createSurface(tmpPath, subType);
            multiSurface.addSurface(tmpSurface);
        }
        return multiSurface;
    }

    public MultiPoint createMultiPoint(GeneralPathX generalPathX, int subType) throws CreateGeometryException {
        if (subType != 0) {
            throw new UnsupportedOperationException();
        }
        MultiPoint multiPoint = (MultiPoint)this.create(7, subType);
        PathIterator piter = generalPathX.getPathIterator(null);
        double[] coords = new double[6];
        while (!piter.isDone()) {
            int type = piter.currentSegment(coords);
            switch (type) {
                case 0: {
                    Point tmpPoint = this.createPoint(coords[0], coords[1], subType);
                    multiPoint.addPoint(tmpPoint);
                }
                case 1: {
                    throw new IllegalArgumentException("The general have a SEG_LINETO.");
                }
                case 2: {
                    throw new IllegalArgumentException("The general have a SEG_QUADTO.");
                }
                case 3: {
                    throw new IllegalArgumentException("The general have a SEG_CUBICTO.");
                }
                case 4: {
                    throw new IllegalArgumentException("The general have a SEG_CLOSE.");
                }
            }
            piter.next();
        }
        return multiPoint;
    }

    public int getGeometryOperationCode(String geomOpName) {
        if (geomOpName == null) {
            throw new IllegalArgumentException("geomOpName cannot be null.");
        }
        int index = this.geometryOperations.indexOf(geomOpName);
        if (index == -1) {
            this.geometryOperations.add(geomOpName);
            index = this.geometryOperations.indexOf(geomOpName);
        }
        return index;
    }

    public List getGeometryOperationNames() {
        ArrayList operations = new ArrayList();
        for (int i = 0; i < operations.size(); ++i) {
            operations.add(this.geometryOperations.get(i));
        }
        return operations;
    }

    public double getFlatness() {
        return this.flatness;
    }

    public void setFlatness(double flatness) {
        this.flatness = flatness;
    }

    public Geometry createFrom(Object data) throws CreateGeometryException, GeometryException {
        if (data == null) {
            throw new IllegalArgumentException("null data is not allowed");
        }
        if (data instanceof String) {
            Geometry geom = GMLUtils.GML2Geometry((String)data);
            if (geom != null) {
                return geom;
            }
            return this.createFrom((String)data);
        }
        if (data instanceof byte[]) {
            return this.createFrom((byte[])data);
        }
        if (data instanceof com.vividsolutions.jts.geom.Geometry) {
            return this.createFrom((com.vividsolutions.jts.geom.Geometry)data);
        }
        if (data instanceof Geometry) {
            return ((Geometry)data).cloneGeometry();
        }
        if (data instanceof JsonObject) {
            return this.createFrom((JsonObject)data, null);
        }
        throw new IllegalArgumentException("Type of data (" + data.getClass().getName() + ") not supported.");
    }

    public Geometry createFrom(JsonObject json, IProjection srs) throws CreateGeometryException, GeometryException {
        try {
            GeoJsonReader reader = new GeoJsonReader();
            com.vividsolutions.jts.geom.Geometry geom_jts = reader.read(json.toString());
            return JTSUtils.createGeometry(srs, geom_jts);
        }
        catch (ParseException ex) {
            throw new GeometryException((Throwable)ex);
        }
    }

    public Geometry createFrom(String wkt, String srs) throws GeometryException {
        GeometryOperationContext context = new GeometryOperationContext();
        context.setAttribute("text", (Object)wkt);
        context.setAttribute("srs", (Object)srs);
        try {
            return (Geometry)this.invokeOperation("FromWKT", context);
        }
        catch (Exception e) {
            throw new GeometryException((Throwable)e);
        }
    }

    private int firstNonBlank(String s) {
        int i = 0;
        while (i < s.length()) {
            char ch;
            if (Character.isWhitespace(ch = s.charAt(i++))) continue;
            return ch;
        }
        return -1;
    }

    private int firstNonBlank(Reader r) {
        try {
            int ch;
            boolean i = false;
            while ((ch = r.read()) != -1) {
                if (Character.isWhitespace(ch)) continue;
                return ch;
            }
            return -1;
        }
        catch (IOException ex) {
            return -1;
        }
    }

    /*
     * Exception decompiling
     */
    public Geometry createFrom(String geom, IProjection srs) throws GeometryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Geometry createFrom(Reader geom, IProjection srs) throws GeometryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Geometry createFrom(String wkt) throws GeometryException {
        return this.createFrom(wkt, (IProjection)null);
    }

    public Geometry createFromQuietly(String wkt) {
        try {
            return this.createFrom(wkt);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Geometry createFrom(byte[] wkb) throws GeometryException {
        GeometryOperationContext context = new GeometryOperationContext();
        context.setAttribute("data", (Object)wkb);
        try {
            return (Geometry)this.invokeOperation("FromWKB", context);
        }
        catch (GeometryOperationNotSupportedException e) {
            throw new GeometryException((Throwable)e);
        }
        catch (GeometryOperationException e) {
            throw new GeometryException((Throwable)e);
        }
    }

    public Geometry createFrom(byte[] wkb, IProjection srs) throws GeometryException {
        GeometryOperationContext context = new GeometryOperationContext();
        context.setAttribute("data", (Object)wkb);
        context.setAttribute("srs", (Object)srs);
        try {
            return (Geometry)this.invokeOperation("FromWKB", context);
        }
        catch (Exception e) {
            throw new GeometryException((Throwable)e);
        }
    }

    public IGeneralPathX createGeneralPath(int rule, PathIterator pathIterator) {
        if (pathIterator == null) {
            return new DefaultGeneralPathX(rule);
        }
        return new DefaultGeneralPathX(pathIterator, false, 0.0);
    }

    public MultiPoint createMultiPoint(int subType) throws CreateGeometryException {
        return (MultiPoint)this.create(7, subType);
    }

    public Line createLine(int subType) throws CreateGeometryException {
        return (Line)this.create(2, subType);
    }

    public Curve createCurve(int subType) throws CreateGeometryException {
        return (Curve)this.create(2, subType);
    }

    public MultiCurve createMultiCurve(int subType) throws CreateGeometryException {
        return (MultiCurve)this.create(8, subType);
    }

    public MultiLine createMultiLine(int subType) throws CreateGeometryException {
        return (MultiLine)this.create(21, subType);
    }

    public MultiSurface createMultiSurface(int subType) throws CreateGeometryException {
        return (MultiSurface)this.create(9, subType);
    }

    public MultiPolygon createMultiPolygon(int subType) throws CreateGeometryException {
        return (MultiPolygon)this.create(22, subType);
    }

    public Polygon createPolygon(int subType) throws CreateGeometryException {
        return (Polygon)this.create(3, subType);
    }

    public Surface createSurface(int subType) throws CreateGeometryException {
        return (Surface)this.create(3, subType);
    }

    public SpatialIndex createDefaultMemorySpatialIndex() throws ServiceException {
        return this.createSpatialIndex("JTSQuadtree", null);
    }

    public SpatialIndex createSpatialIndex(String name, DynObject parameters) throws ServiceException {
        SpatialIndexFactory factory = this.getSpatialIndexFactory(name);
        if (factory == null) {
            throw new CantExistsService(name);
        }
        return (SpatialIndex)factory.create(parameters, (ServiceManager)this);
    }

    public SpatialIndexFactory getSpatialIndexFactory(String name) {
        return (SpatialIndexFactory)this.spatialIndexFactories.get(name);
    }

    public void addServiceFactory(ServiceFactory serviceFactory) {
        serviceFactory.initialize();
        this.spatialIndexFactories.put(serviceFactory.getName(), serviceFactory);
    }

    public Service createService(DynObject serviceParameters) throws ServiceException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DynObject createServiceParameters(String serviceName) throws ServiceException {
        SpatialIndexFactory factory = this.getSpatialIndexFactory(serviceName);
        if (factory == null) {
            throw new CantExistsService(serviceName);
        }
        return factory.createParameters();
    }

    public Service getService(DynObject parameters) throws ServiceException {
        return this.createSpatialIndex((String)parameters.getDynValue("serviceName"), parameters);
    }

    public MultiPrimitive createMultiPrimitive(GeometryType geometryType) throws CreateGeometryException {
        int type = geometryType.getType();
        int subtype = geometryType.getSubType();
        if (this.isSubtype(1, type)) {
            return this.createMultiPoint(subtype);
        }
        if (this.isSubtype(2, type)) {
            return this.createMultiCurve(subtype);
        }
        if (this.isSubtype(3, type)) {
            return this.createMultiSurface(subtype);
        }
        throw new CreateGeometryException(type, subtype, null);
    }

    public InformationbuilderWithGeometrySupport createInformacionBuilder() {
        return new BaseInformationBuilderWithGeometrySupport();
    }

    public boolean isSubtype(int geomTypeParent, int geomTypeChild) {
        if (geomTypeParent == geomTypeChild) {
            return true;
        }
        if (geomTypeParent == 0) {
            return true;
        }
        switch (geomTypeParent) {
            case 8: {
                return geomTypeChild == 21;
            }
            case 9: {
                return geomTypeChild == 22;
            }
            case 7: {
                return geomTypeChild == 7;
            }
            case 2: {
                return geomTypeChild == 2 || geomTypeChild == 18 || geomTypeChild == 12 || geomTypeChild == 14 || geomTypeChild == 23 || geomTypeChild == 24;
            }
            case 3: {
                return geomTypeChild == 3 || geomTypeChild == 19 || geomTypeChild == 11 || geomTypeChild == 13 || geomTypeChild == 20 || geomTypeChild == 25 || geomTypeChild == 15;
            }
            case 1: {
                return geomTypeChild == 1;
            }
        }
        return false;
    }

    public boolean canAggregate(int geomTypeParent, int geomTypeChild) {
        switch (geomTypeParent) {
            case 8: 
            case 21: {
                return this.isSubtype(2, geomTypeChild);
            }
            case 9: 
            case 22: {
                return this.isSubtype(3, geomTypeChild);
            }
            case 7: {
                return this.isSubtype(1, geomTypeChild);
            }
        }
        return false;
    }

    public GeometryCoercionContext createGeometryCoercionContext() {
        return new DefaultGeometryCoercionContext();
    }

    public static void main(String[] args) throws GeometryException, GeometryOperationNotSupportedException, GeometryOperationException {
        new DefaultLibrariesInitializer().fullInitialize();
        Geometry g = GeometryUtils.createFrom((String)"0105000060E66400000100000001020000400D00000016A75AD380C3264156FBE56F7D7A5041000000008087C3C07D0393E386C326413D0E834F7D7A5041000000008087C3C0BDA607ED95C32641D575A8B07D7A5041000000008087C3C029098934A2C32641FF9595B97E7A5041000000008087C3C0740AF27BAAC326417EC68542807A5041000000008087C3C039471D85ADC32641B456B423827A5041000000008087C3C0740AF27BAAC326411CEBE204847A5041000000008087C3C029098934A2C326416A17D38D857A5041000000008087C3C0BDA607ED95C326419337C096867A5041000000008087C3C07D0393E386C326412C9FE5F7867A5041000000008087C3C0CB811EDA77C326419337C096867A5041000000008087C3C06518D01574C3264130507B45867A5041000000008087C3C02646E0756EC32641894CE5CE857A5041000000008087C3C0");
        String hexwkb = g.convertToHexWKB();
        String hexewkb = g.convertToHexEWKB();
        System.out.println(hexwkb);
        System.out.println(hexewkb);
    }

    public class CantExistsService
    extends ServiceException {
        public CantExistsService(String serviceName) {
            super("Can't existe service %(service).", "_Cant_existe_service_XserviceX", 100001L);
            this.setValue("service", serviceName);
        }
    }
}

