/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.type.AbstractGeometryType;
import org.gvsig.fmap.geom.type.GeometryType;

public class DefaultGeometryType
extends AbstractGeometryType {
    private String name;
    private Class geometryClass;
    private int type;
    private int subType;
    private int[] superTypes = null;
    private int[] superSubTypes = null;
    private Constructor constructorWithGeometryType = null;
    private Constructor constructorWithoutParameters = null;
    private final Object[] parameters = new Object[]{this};
    private Set<String> alias;

    public DefaultGeometryType(Class geomClass, String name, int type, int subType, int[] superTypes, int[] superSubTypes) {
        this.geometryClass = geomClass;
        this.name = name == null ? geomClass.getName() : name;
        this.type = type;
        this.subType = subType;
        this.superTypes = superTypes;
        this.superSubTypes = superSubTypes;
        Class[] parameterTypes = new Class[]{GeometryType.class};
        try {
            this.constructorWithGeometryType = this.geometryClass.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            try {
                this.constructorWithoutParameters = this.geometryClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                throw new RuntimeException("Error constructor of the geometry class " + geomClass + " with one parameter of type GeometryType not found", e);
            }
        }
    }

    public DefaultGeometryType(Class geomClass, String name, int type, int subType) {
        this(geomClass, name, type, subType, new int[0], new int[0]);
    }

    public Geometry create() throws CreateGeometryException {
        try {
            if (this.constructorWithGeometryType != null) {
                return (Geometry)this.constructorWithGeometryType.newInstance(this.parameters);
            }
            return (Geometry)this.constructorWithoutParameters.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new CreateGeometryException(this.type, this.subType, (Throwable)e);
        }
    }

    public Class getGeometryClass() {
        return this.geometryClass;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        String subtypename;
        switch (this.subType) {
            case 0: {
                subtypename = "2D";
                break;
            }
            case 2: {
                subtypename = "2DM";
                break;
            }
            case 1: {
                subtypename = "3D";
                break;
            }
            case 3: {
                subtypename = "3DM";
                break;
            }
            default: {
                subtypename = "subtype" + this.subType;
            }
        }
        if (this.name.endsWith(subtypename)) {
            try {
                return this.name.substring(0, this.name.length() - subtypename.length()) + ":" + subtypename;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.name + ":" + subtypename;
    }

    public int getType() {
        return this.type;
    }

    public int getSubType() {
        return this.subType;
    }

    public boolean isTypeOf(int geometryType) {
        if (this.type == geometryType) {
            return true;
        }
        for (int i = 0; i < this.superTypes.length; ++i) {
            if (this.superTypes[i] != geometryType) continue;
            return true;
        }
        return 0 == geometryType;
    }

    public boolean isSubTypeOf(int geometrySubType) {
        if (this.subType == geometrySubType) {
            return true;
        }
        for (int i = 0; i < this.superSubTypes.length; ++i) {
            if (this.superSubTypes[i] != geometrySubType) continue;
            return true;
        }
        return false;
    }

    public int getDimension() {
        switch (this.subType) {
            case 0: {
                return 2;
            }
            case 1: 
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GeometryType)) {
            return false;
        }
        GeometryType other = (GeometryType)obj;
        if (!this.name.equals(other.getName())) {
            return false;
        }
        if (!this.geometryClass.getName().equals(other.getGeometryClass().getName())) {
            return false;
        }
        if (this.type != other.getType()) {
            return false;
        }
        return this.subType == other.getSubType();
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.name);
        hash = 79 * hash + Objects.hashCode(this.geometryClass.getName());
        hash = 79 * hash + this.type;
        hash = 79 * hash + this.subType;
        return hash;
    }

    public GeometryType addAlias(String alias) {
        if (this.alias == null) {
            this.alias = new HashSet<String>();
        }
        this.alias.add(alias);
        return this;
    }

    public Collection<String> getAlias() {
        if (this.alias == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this.alias);
    }

    public int[] getSuperTypes() {
        return this.superTypes;
    }
}

