/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.aggregate;

import com.vividsolutions.jts.dissolve.LineDissolver;
import com.vividsolutions.jts.geom.MultiLineString;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.jts.aggregate.AbstractMultiPrimitive;
import org.gvsig.fmap.geom.jts.gputils.DefaultGeneralPathX;
import org.gvsig.fmap.geom.jts.gputils.GeneralPathXIterator;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.IGeneralPathX;
import org.gvsig.fmap.geom.primitive.Primitive;

public abstract class AbstractMultiCurve
extends AbstractMultiPrimitive
implements MultiCurve {
    private static final long serialVersionUID = 5498201227873886542L;

    public AbstractMultiCurve(int type, int subtype) {
        super(type, subtype);
    }

    public AbstractMultiCurve(int subtype) {
        super(8, subtype);
    }

    public Curve getCurveAt(int index) {
        return (Curve)this.primitives.get(index);
    }

    public void addCurve(Curve curve) {
        this.primitives.add((Primitive)this.fixPrimitive((Primitive)curve));
    }

    public PathIterator getPathIterator(AffineTransform at) {
        MultiCurveIterator pi = new MultiCurveIterator(at);
        return pi;
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    public GeneralPathX getGeneralPath() {
        return new DefaultGeneralPathX(this.getPathIterator(null), false, 0.0);
    }

    public Geometry dissolve() {
        LineDissolver dissolver = new LineDissolver();
        dissolver.add((com.vividsolutions.jts.geom.Geometry)((MultiLineString)this.getJTS()));
        return JTSUtils.createGeometry(this.getProjection(), dissolver.getResult());
    }

    protected class MultiCurveIterator
    extends GeneralPathXIterator {
        private AffineTransform at;
        private boolean done;
        private int index;
        private List<PathIterator> iterators;

        public MultiCurveIterator(AffineTransform at) {
            super((IGeneralPathX)new GeneralPathX());
            this.index = 0;
            this.iterators = new ArrayList<PathIterator>(AbstractMultiCurve.this.primitives.size());
            if (at == null) {
                at = new AffineTransform();
            }
            this.at = at;
            for (Primitive primitive : AbstractMultiCurve.this.primitives) {
                if (primitive.isEmpty()) continue;
                this.iterators.add(primitive.getPathIterator(at));
            }
            this.done = this.iterators.isEmpty();
        }

        @Override
        public int getWindingRule() {
            return 0;
        }

        @Override
        public void next() {
            PathIterator pathIteratorPrimitive = this.iterators.get(this.index);
            pathIteratorPrimitive.next();
            if (pathIteratorPrimitive.isDone()) {
                ++this.index;
                this.done = this.index == AbstractMultiCurve.this.primitives.size();
            }
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public int currentSegment(double[] coords) {
            return this.iterators.get(this.index).currentSegment(coords);
        }

        @Override
        public int currentSegment(float[] coords) {
            return this.iterators.get(this.index).currentSegment(coords);
        }
    }
}

