/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.aggregate;

import com.vividsolutions.jts.geom.LineString;
import java.util.Collections;
import java.util.Iterator;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.jts.GeometryJTS;
import org.gvsig.fmap.geom.jts.aggregate.AbstractMultiCurve;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine2D;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine2DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine3D;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine3DM;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;

public abstract class AbstractMultiLine
extends AbstractMultiCurve
implements MultiLine {
    private static final long serialVersionUID = 3585059833766514177L;

    public AbstractMultiLine(int subtype) {
        super(21, subtype);
    }

    @Override
    public com.vividsolutions.jts.geom.Geometry getJTS() {
        LineString[] lineStrings = new LineString[this.primitives.size()];
        for (int i = 0; i < this.primitives.size(); ++i) {
            lineStrings[i] = (LineString)((GeometryJTS)this.primitives.get(i)).getJTS();
        }
        return JTSUtils.createJTSMultiLineString(this.getProjection(), lineStrings);
    }

    public Geometry force2D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        MultiLine2D other = new MultiLine2D();
        other.setProjection(this.getProjection());
        other.ensureCapacity(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            other.addPrimitive((Primitive)primitive.forceSubtype(0));
        }
        return other;
    }

    @Override
    public Geometry force2DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        MultiLine2DM other = new MultiLine2DM();
        other.setProjection(this.getProjection());
        other.ensureCapacity(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            other.addPrimitive((Primitive)primitive.forceSubtype(2));
        }
        return other;
    }

    @Override
    public Geometry force3D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        MultiLine3D other = new MultiLine3D();
        other.setProjection(this.getProjection());
        other.ensureCapacity(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            other.addPrimitive((Primitive)primitive.forceSubtype(1));
        }
        return other;
    }

    @Override
    public Geometry force3DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        MultiLine3DM other = new MultiLine3DM();
        other.setProjection(this.getProjection());
        other.ensureCapacity(this.primitives.size());
        for (Primitive primitive : this.primitives) {
            other.addPrimitive((Primitive)primitive.forceSubtype(3));
        }
        return other;
    }

    public void flip() throws GeometryOperationNotSupportedException, GeometryOperationException {
        Iterator iterator = this.primitives.iterator();
        while (iterator.hasNext()) {
            ((GeometryJTS)iterator.next()).flip();
        }
        Collections.reverse(this.primitives);
    }

    public double getPathLength(Point point) {
        return JTSUtils.getPathLengthFromLine(this, point);
    }

    public Point extractPoint(double length) {
        return JTSUtils.extractPointFromLine(this, length);
    }
}

