/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.aggregate;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.aggregate.AbstractMultiLine;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint3D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon3D;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line3D;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Surface;

public class MultiLine3D
extends AbstractMultiLine {
    private static final long serialVersionUID = 4864883331083875719L;

    public MultiLine3D() {
        super(0);
    }

    public MultiPoint toPoints() throws GeometryException {
        MultiPoint3D multiPoint = new MultiPoint3D();
        for (Line3D line : this.primitives) {
            MultiPoint points = line.toPoints();
            multiPoint.ensureCapacity(multiPoint.getPrimitivesNumber() + points.getPrimitivesNumber());
            for (int i = 0; i < points.getPrimitivesNumber(); ++i) {
                multiPoint.addPoint(points.getPointAt(i));
            }
        }
        return multiPoint;
    }

    public MultiLine toLines() throws GeometryException {
        return this;
    }

    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon3D multiPolygon = new MultiPolygon3D();
        for (Line3D line : this.primitives) {
            MultiPolygon polygons = line.toPolygons();
            multiPolygon.ensureCapacity(multiPolygon.getPrimitivesNumber() + polygons.getPrimitivesNumber());
            for (int i = 0; i < polygons.getPrimitivesNumber(); ++i) {
                multiPolygon.addSurface((Surface)((Polygon)polygons.getPrimitiveAt(i)));
            }
        }
        return multiPolygon;
    }

    public Geometry cloneGeometry() {
        MultiLine3D clone = new MultiLine3D();
        clone.setProjection(this.getProjection());
        return this.clonePrimitives(clone);
    }

    public int getDimension() {
        return 3;
    }

    @Override
    public Shape getShape(AffineTransform affineTransform) {
        return null;
    }

    @Override
    public Shape getShape() {
        return null;
    }

    @Override
    public boolean is3D() {
        return true;
    }

    @Override
    protected Geometry fixPrimitive(Primitive primitive) {
        if (primitive instanceof Line3D) {
            return primitive;
        }
        if (primitive.getGeometryType().getSubType() == 1) {
            try {
                return primitive.toLines();
            }
            catch (GeometryException e) {
                String message = "Can't convert primitive to lines";
                LOGGER.warn(message);
                throw new RuntimeException(message);
            }
        }
        String message = "Only 3D primitives can be fixed to MultiLine3D";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public Geometry offset(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        MultiLine3D result = new MultiLine3D();
        for (Primitive primitive : this.primitives) {
            Geometry offset = primitive.offset(distance);
            if (offset instanceof MultiLine) {
                MultiLine multiOffset = (MultiLine)offset;
                for (int i = 0; i < multiOffset.getPrimitivesNumber(); ++i) {
                    result.addPrimitive(multiOffset.getPrimitiveAt(i));
                }
                continue;
            }
            Primitive offsetPrimitive = (Primitive)primitive.offset(distance);
            if (offsetPrimitive == null) continue;
            result.addPrimitive(offsetPrimitive);
        }
        return result;
    }

    public Geometry offset(int joinStyle, double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        MultiLine3D result = new MultiLine3D();
        for (Primitive primitive : this.primitives) {
            Geometry offset = primitive.offset(joinStyle, distance);
            if (offset instanceof MultiLine) {
                MultiLine multiOffset = (MultiLine)offset;
                for (int i = 0; i < multiOffset.getPrimitivesNumber(); ++i) {
                    result.addPrimitive(multiOffset.getPrimitiveAt(i));
                }
                continue;
            }
            Primitive offsetPrimitive = (Primitive)primitive.offset(joinStyle, distance);
            if (offsetPrimitive == null) continue;
            result.addPrimitive(offsetPrimitive);
        }
        return result;
    }
}

