/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.aggregate;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.aggregate.AbstractMultiPolygon;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine3DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint3DM;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line3DM;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon3DM;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Primitive;

public class MultiPolygon3DM
extends AbstractMultiPolygon {
    private static final long serialVersionUID = -2391997357144095125L;

    public MultiPolygon3DM() {
        super(3);
    }

    public MultiPoint toPoints() throws GeometryException {
        MultiPoint3DM multiPoint = new MultiPoint3DM();
        for (Polygon3DM polygon : this.primitives) {
            MultiPoint points = polygon.toPoints();
            multiPoint.ensureCapacity(multiPoint.getPrimitivesNumber() + points.getPrimitivesNumber());
            for (int i = 0; i < points.getPrimitivesNumber(); ++i) {
                multiPoint.addPoint(points.getPointAt(i));
            }
        }
        return multiPoint;
    }

    public MultiLine toLines() throws GeometryException {
        MultiLine3DM multiLine = new MultiLine3DM();
        for (Polygon3DM polygon : this.primitives) {
            MultiLine lines = polygon.toLines();
            multiLine.ensureCapacity(multiLine.getPrimitivesNumber() + lines.getPrimitivesNumber());
            for (int i = 0; i < lines.getPrimitivesNumber(); ++i) {
                multiLine.addPrimitive((Line3DM)lines.getPrimitiveAt(i));
            }
        }
        return multiLine;
    }

    public MultiPolygon toPolygons() throws GeometryException {
        return this;
    }

    public Geometry cloneGeometry() {
        MultiPolygon3DM clone = new MultiPolygon3DM();
        clone.setProjection(this.getProjection());
        return this.clonePrimitives(clone);
    }

    public int getDimension() {
        return 4;
    }

    @Override
    public Shape getShape(AffineTransform affineTransform) {
        return null;
    }

    @Override
    public Shape getShape() {
        return null;
    }

    @Override
    protected Geometry fixPrimitive(Primitive primitive) {
        if (primitive instanceof Polygon3DM) {
            return primitive;
        }
        if (primitive.getGeometryType().getSubType() == 3) {
            MultiPolygon polygons;
            try {
                polygons = primitive.toPolygons();
            }
            catch (GeometryException e) {
                String message = "Can't convert primitive to polygons";
                LOGGER.warn(message);
                throw new RuntimeException(message);
            }
            return polygons;
        }
        String message = "Only 3DM primitives can be fixed to MultiPolygon3DM";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public Geometry offset(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return JTSUtils.createGeometry(this.getProjection(), this.getJTS().buffer(distance));
    }

    public Geometry offset(int joinStyle, double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return JTSUtils.createGeometry(this.getProjection(), this.getJTS().buffer(distance, JTSUtils.calculateQuadrantSegments(joinStyle)));
    }
}

