/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.mgeom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import org.gvsig.fmap.geom.jts.mgeom.MGeometry;
import org.gvsig.fmap.geom.jts.mgeom.MGeometryException;
import org.gvsig.fmap.geom.jts.mgeom.MGeometryFactory;
import org.gvsig.fmap.geom.jts.mgeom.MLineString;
import org.gvsig.fmap.geom.jts.mgeom.MultiMLineString;

public class EventLocator {
    public static Point getPointGeometry(MGeometry lrs, double position) throws MGeometryException {
        if (lrs == null) {
            throw new MGeometryException("Non-null MGeometry parameter is required.");
        }
        Coordinate c = lrs.getCoordinateAtM(position);
        Point pnt = lrs.getFactory().createPoint(c);
        EventLocator.copySRID(lrs.asGeometry(), (Geometry)pnt);
        return pnt;
    }

    public static MultiMLineString getLinearGeometry(MGeometry lrs, double begin, double end) throws MGeometryException {
        if (lrs == null) {
            throw new MGeometryException("Non-null MGeometry parameter is required.");
        }
        MGeometryFactory factory = (MGeometryFactory)lrs.getFactory();
        CoordinateSequence[] cs = lrs.getCoordinatesBetween(begin, end);
        ArrayList<MLineString> linestrings = new ArrayList<MLineString>(cs.length);
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i].size() < 2) continue;
            MLineString ml = factory.createMLineString(cs[i]);
            linestrings.add(ml);
        }
        MultiMLineString result = factory.createMultiMLineString(linestrings.toArray(new MLineString[linestrings.size()]));
        EventLocator.copySRID(lrs.asGeometry(), result.asGeometry());
        return result;
    }

    public static void copySRID(Geometry source, Geometry target) {
        target.setSRID(source.getSRID());
    }
}

