/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.operation.towkb;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.EndianUtils;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.Aggregate;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.operation.towkb.WKBEncodingException;
import org.gvsig.fmap.geom.jts.operation.towkb.WKBPolygonNotClosedException;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Ring;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.geom.type.GeometryTypeNotSupportedException;

public class OGCWKBEncoder {
    private int byteOrder;

    public OGCWKBEncoder() {
        this(0);
    }

    public OGCWKBEncoder(int byteOrder) {
        this.byteOrder = byteOrder;
    }

    public byte[] encode(Geometry geometry) throws GeometryTypeNotSupportedException, WKBEncodingException, IOException {
        ByteArrayOutputStream stream = geometry.getType() == 1 ? new ByteArrayOutputStream(50) : new ByteArrayOutputStream(512);
        this.encode(geometry, stream);
        return stream.toByteArray();
    }

    public void encode(Geometry geometry, ByteArrayOutputStream stream) throws GeometryTypeNotSupportedException, WKBEncodingException, IOException {
        this.encode(geometry, new DataOutputStream(stream));
    }

    public void encode(Geometry geometry, DataOutputStream stream) throws GeometryTypeNotSupportedException, WKBEncodingException, IOException {
        if (geometry.getGeometryType().isTypeOf(1)) {
            this.encodePoint(geometry, stream);
        } else if (geometry.getGeometryType().isTypeOf(18)) {
            this.encodeLineString((Line)geometry, stream);
        } else if (geometry.getGeometryType().isTypeOf(2)) {
            try {
                MultiLine lines = geometry.toLines();
                if (lines.getPrimitivesNumber() == 1) {
                    this.encodeLineString((Line)lines.getPrimitiveAt(0), stream);
                }
                this.encodeMultiLineString(lines, stream);
            }
            catch (GeometryException ex) {
                throw new WKBEncodingException(ex);
            }
        } else if (geometry.getGeometryType().isTypeOf(19)) {
            this.encodePolygon((Polygon)geometry, stream);
        } else if (geometry.getGeometryType().isTypeOf(3)) {
            try {
                MultiPolygon pols = geometry.toPolygons();
                if (pols.getPrimitivesNumber() == 1) {
                    this.encodePolygon((Polygon)pols.getPrimitiveAt(0), stream);
                }
                this.encodeMultiPolygon(pols, stream);
            }
            catch (GeometryException ex) {
                throw new WKBEncodingException(ex);
            }
        } else if (geometry.getGeometryType().isTypeOf(6)) {
            switch (geometry.getType()) {
                case 7: {
                    this.encodeMultiPoint(geometry, stream);
                    break;
                }
                case 8: {
                    try {
                        this.encodeMultiLineString(geometry.toLines(), stream);
                        break;
                    }
                    catch (GeometryException ex) {
                        throw new WKBEncodingException(ex);
                    }
                }
                case 21: {
                    this.encodeMultiLineString((MultiLine)geometry, stream);
                    break;
                }
                case 9: {
                    try {
                        this.encodeMultiPolygon(geometry.toPolygons(), stream);
                        break;
                    }
                    catch (GeometryException ex) {
                        throw new WKBEncodingException(ex);
                    }
                }
                case 22: {
                    this.encodeMultiPolygon((MultiPolygon)geometry, stream);
                    break;
                }
                case 6: {
                    this.encodeCollection(geometry, stream);
                }
            }
        } else {
            throw new GeometryTypeNotSupportedException(geometry.getType(), geometry.getGeometryType().getSubType());
        }
    }

    private void encodeCollection(Geometry geometry, DataOutputStream stream) throws GeometryTypeNotSupportedException, WKBEncodingException, IOException {
        GeometryType geometryType = geometry.getGeometryType();
        this.encodeWKBGeomHead(7, geometryType, stream);
        Aggregate collection = (Aggregate)geometry;
        int nGeometries = collection.getPrimitivesNumber();
        this.encodeInteger(nGeometries, stream);
        for (int i = 0; i < nGeometries; ++i) {
            this.encode((Geometry)collection.getPrimitiveAt(i), stream);
        }
    }

    private void encodeMultiPolygon(MultiPolygon geometry, DataOutputStream stream) throws GeometryTypeNotSupportedException, WKBPolygonNotClosedException, IOException {
        GeometryType geometryType = geometry.getGeometryType();
        this.encodeWKBGeomHead(6, geometryType, stream);
        int nGeometries = geometry.getPrimitivesNumber();
        this.encodeInteger(nGeometries, stream);
        for (int i = 0; i < nGeometries; ++i) {
            this.encodePolygon((Polygon)geometry.getPrimitiveAt(i), stream);
        }
    }

    private void encodePolygon(Polygon geometry, DataOutputStream stream) throws GeometryTypeNotSupportedException, WKBPolygonNotClosedException, IOException {
        GeometryType geometryType = geometry.getGeometryType();
        this.encodeWKBGeomHead(3, geometryType, stream);
        this.encodeInteger(1 + geometry.getNumInteriorRings(), stream);
        this.encodeLinearRing((Ring)geometry, stream);
        for (int i = 0; i < geometry.getNumInteriorRings(); ++i) {
            Ring ring = geometry.getInteriorRing(i);
            this.encodeLinearRing(ring, stream);
        }
    }

    private void encodeLinearRing(Ring geom, DataOutputStream stream) throws IOException {
        this.encodeInteger(geom.getNumVertices(), stream);
        for (Point point : geom) {
            this.encodeCoordinates(point.getCoordinates(), stream);
        }
    }

    private void encodeMultiLineString(MultiLine geometry, DataOutputStream stream) throws GeometryTypeNotSupportedException, WKBPolygonNotClosedException, IOException {
        GeometryType geometryType = geometry.getGeometryType();
        this.encodeWKBGeomHead(5, geometryType, stream);
        int nGeometries = geometry.getPrimitivesNumber();
        this.encodeInteger(nGeometries, stream);
        for (int i = 0; i < nGeometries; ++i) {
            this.encodeLineString((Line)geometry.getPrimitiveAt(i), stream);
        }
    }

    private void encodeLineString(Line geometry, DataOutputStream stream) throws GeometryTypeNotSupportedException, WKBPolygonNotClosedException, IOException {
        GeometryType geometryType = geometry.getGeometryType();
        this.encodeWKBGeomHead(2, geometryType, stream);
        int nVertices = geometry.getNumVertices();
        this.encodeInteger(nVertices, stream);
        for (Point point : geometry) {
            this.encodeCoordinates(point.getCoordinates(), stream);
        }
    }

    private void encodeDouble(double data, DataOutputStream stream) throws IOException {
        if (this.byteOrder == 0) {
            stream.writeDouble(data);
        } else {
            EndianUtils.writeSwappedDouble((OutputStream)stream, (double)data);
        }
    }

    private void encodeInteger(int data, DataOutputStream stream) throws IOException {
        if (this.byteOrder == 0) {
            stream.writeInt(data);
        } else {
            EndianUtils.writeSwappedInteger((OutputStream)stream, (int)data);
        }
    }

    private void encodeCoordinates(double[] coordinates, DataOutputStream stream) throws IOException {
        for (int i = 0; i < coordinates.length; ++i) {
            this.encodeDouble(coordinates[i], stream);
        }
    }

    private void encodeWKBGeomHead(int wkbBaseType, GeometryType geometryType, DataOutputStream stream) throws GeometryTypeNotSupportedException, IOException {
        stream.writeByte(this.byteOrder);
        int finalType = wkbBaseType % 1000;
        switch (geometryType.getSubType()) {
            case 0: {
                break;
            }
            case 2: {
                finalType += 2000;
                break;
            }
            case 1: {
                finalType += 1000;
                break;
            }
            case 3: {
                finalType += 3000;
                break;
            }
            default: {
                throw new GeometryTypeNotSupportedException(geometryType.getType(), geometryType.getSubType());
            }
        }
        this.encodeInteger(finalType, stream);
    }

    private void encodePoint(Geometry geometry, DataOutputStream stream) throws GeometryTypeNotSupportedException, IOException {
        GeometryType geometryType = geometry.getGeometryType();
        this.encodeWKBGeomHead(1, geometryType, stream);
        Point point = (Point)geometry;
        this.encodeCoordinates(point.getCoordinates(), stream);
    }

    private void encodeMultiPoint(Geometry geometry, DataOutputStream stream) throws GeometryTypeNotSupportedException, IOException {
        GeometryType geometryType = geometry.getGeometryType();
        this.encodeWKBGeomHead(4, geometryType, stream);
        MultiPoint points = (MultiPoint)geometry;
        int nGeometries = points.getPrimitivesNumber();
        this.encodeInteger(nGeometries, stream);
        for (int i = 0; i < nGeometries; ++i) {
            this.encodePoint((Geometry)points.getPrimitiveAt(i), stream);
        }
    }

    public static interface wkbByteOrder {
        public static final byte wkbXDR = 0;
        public static final byte wkbNDR = 1;
    }

    public static interface wkbGeometryType {
        public static final int wkbPoint = 1;
        public static final int wkbLineString = 2;
        public static final int wkbPolygon = 3;
        public static final int wkbTriangle = 17;
        public static final int wkbMultiPoint = 4;
        public static final int wkbMultiLineString = 5;
        public static final int wkbMultiPolygon = 6;
        public static final int wkbGeometryCollection = 7;
        public static final int wkbPolyhedralSurface = 15;
        public static final int wkbTIN = 16;
        public static final int wkbPointZ = 1001;
        public static final int wkbLineStringZ = 1002;
        public static final int wkbPolygonZ = 1003;
        public static final int wkbTrianglez = 1017;
        public static final int wkbMultiPointZ = 1004;
        public static final int wkbMultiLineStringZ = 1005;
        public static final int wkbMultiPolygonZ = 1006;
        public static final int wkbGeometryCollectionZ = 1007;
        public static final int wkbPolyhedralSurfaceZ = 1015;
        public static final int wkbTINZ = 1016;
        public static final int wkbPointM = 2001;
        public static final int wkbLineStringM = 2002;
        public static final int wkbPolygonM = 2003;
        public static final int wkbTriangleM = 2017;
        public static final int wkbMultiPointM = 2004;
        public static final int wkbMultiLineStringM = 2005;
        public static final int wkbMultiPolygonM = 2006;
        public static final int wkbGeometryCollectionM = 2007;
        public static final int wkbPolyhedralSurfaceM = 2015;
        public static final int wkbTINM = 2016;
        public static final int wkbPointZM = 3001;
        public static final int wkbLineStringZM = 3002;
        public static final int wkbPolygonZM = 3003;
        public static final int wkbTriangleZM = 3017;
        public static final int wkbMultiPointZM = 3004;
        public static final int wkbMultiLineStringZM = 3005;
        public static final int wkbMultiPolygonZM = 3006;
        public static final int wkbGeometryCollectionZM = 3007;
        public static final int wkbPolyhedralSurfaceZM = 3015;
        public static final int wkbTinZM = 3016;
        public static final int wkb_baseToZ = 1000;
        public static final int wkb_baseToM = 2000;
        public static final int wkb_baseToZM = 3000;
    }
}

