/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.geom.Point2D;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.geom.jts.primitive.DefaultEnvelope;
import org.gvsig.fmap.geom.jts.primitive.point.Point2D;
import org.gvsig.fmap.geom.primitive.EnvelopeNotInitializedException;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.persistence.PersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Envelope2D
extends DefaultEnvelope
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(Envelope2D.class);
    public static final String PERSISTENCE_DEFINITION_NAME = "Envelope2Dimensions";

    public Envelope2D() {
    }

    public Envelope2D(IProjection projection) {
        super(projection);
    }

    public Envelope2D(Point min, Point max, IProjection projection) {
        super(min, max, projection);
    }

    public Envelope2D(double minX, double minY, double maxX, double maxY, IProjection projection) {
        this(new Point2D(minX, minY), new Point2D(maxX, maxY), projection);
    }

    public Envelope2D(Geometry bounds) {
        this();
        Envelope envelope = bounds.getEnvelope().getEnvelopeInternal();
        this.setLowerCorner(new Point2D(envelope.getMinX(), envelope.getMinY()));
        this.setUpperCorner(new Point2D(envelope.getMaxX(), envelope.getMaxY()));
    }

    public Envelope2D(Envelope envelope, IProjection projection) {
        this(new Point2D(envelope.getMinX(), envelope.getMinY()), new Point2D(envelope.getMaxX(), envelope.getMaxY()), projection);
    }

    public int getDimension() {
        return 2;
    }

    public org.gvsig.fmap.geom.primitive.Envelope convert(ICoordTrans trans) {
        if (this.isEmpty) {
            throw new EnvelopeNotInitializedException();
        }
        if (trans == null) {
            return new Envelope2D(this.getLowerCorner(), this.getUpperCorner(), this.projection);
        }
        if (this.getDimension() > 2) {
            return null;
        }
        double xmin = this.getMinimum(0);
        double ymin = this.getMinimum(1);
        double step_w = 0.0625 * (this.getMaximum(0) - xmin);
        double step_h = 0.125 * (this.getMaximum(1) - ymin);
        Point2D.Double sample = null;
        java.awt.geom.Point2D sample_trans = null;
        Point2D.Double res_min = new Point2D.Double(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        Point2D.Double res_max = new Point2D.Double(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        int added = 0;
        for (int i = 0; i <= 16; ++i) {
            for (int j = 0; j <= 8; ++j) {
                sample = new Point2D.Double(xmin + (double)i * step_w, ymin + (double)j * step_h);
                sample_trans = new Point2D.Double(0.0, 0.0);
                try {
                    sample_trans = trans.convert((java.awt.geom.Point2D)sample, sample_trans);
                }
                catch (Exception exc) {
                    continue;
                }
                if (!Double.isInfinite(sample_trans.getX()) && sample_trans.getX() > ((java.awt.geom.Point2D)res_max).getX()) {
                    ((java.awt.geom.Point2D)res_max).setLocation(sample_trans.getX(), ((java.awt.geom.Point2D)res_max).getY());
                    ++added;
                }
                if (!Double.isInfinite(sample_trans.getX()) && sample_trans.getX() < ((java.awt.geom.Point2D)res_min).getX()) {
                    ((java.awt.geom.Point2D)res_min).setLocation(sample_trans.getX(), ((java.awt.geom.Point2D)res_min).getY());
                    ++added;
                }
                if (!Double.isInfinite(sample_trans.getY()) && sample_trans.getY() > ((java.awt.geom.Point2D)res_max).getY()) {
                    ((java.awt.geom.Point2D)res_max).setLocation(((java.awt.geom.Point2D)res_max).getX(), sample_trans.getY());
                    ++added;
                }
                if (Double.isInfinite(sample_trans.getY()) || !(sample_trans.getY() < ((java.awt.geom.Point2D)res_min).getY())) continue;
                ((java.awt.geom.Point2D)res_min).setLocation(((java.awt.geom.Point2D)res_min).getX(), sample_trans.getY());
                ++added;
            }
        }
        if (added == 0) {
            logger.warn("Unable to reproject envelope with transf: " + trans.toString());
            Point min = this.getLowerCorner().cloneGeometry();
            Point max = this.getUpperCorner().cloneGeometry();
            min.reProject(trans);
            max.reProject(trans);
            return new Envelope2D(min, max, trans.getPDest());
        }
        return new Envelope2D(((java.awt.geom.Point2D)res_min).getX(), ((java.awt.geom.Point2D)res_min).getY(), ((java.awt.geom.Point2D)res_max).getX(), ((java.awt.geom.Point2D)res_max).getY(), trans.getPDest());
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(Envelope2D.class, PERSISTENCE_DEFINITION_NAME, "Envelope2D persistence definition", null, null);
            definition.extend(manager.getDefinition("Envelope"));
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void createPoints() {
        this.min = new Point2D(0.0, 0.0);
        this.max = new Point2D(0.0, 0.0);
    }

    public void add(org.gvsig.fmap.geom.primitive.Envelope envelope) {
        if (envelope == null || envelope.isEmpty()) {
            return;
        }
        if (this.isEmpty) {
            this.createPoints();
            for (int i = 0; i < this.getDimension(); ++i) {
                this.min.setCoordinateAt(i, envelope.getMinimum(i));
                this.max.setCoordinateAt(i, envelope.getMaximum(i));
            }
            this.isEmpty = false;
        } else {
            for (int i = 0; i < this.getDimension(); ++i) {
                this.min.setCoordinateAt(i, Math.min(this.min.getCoordinateAt(i), envelope.getMinimum(i)));
                this.max.setCoordinateAt(i, Math.max(this.max.getCoordinateAt(i), envelope.getMaximum(i)));
            }
        }
    }
}

