/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.curve.spline;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.ICoordTrans;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.jts.gputils.DefaultGeneralPathX;
import org.gvsig.fmap.geom.jts.gputils.GeneralPathXIterator;
import org.gvsig.fmap.geom.jts.mgeom.MCoordinate;
import org.gvsig.fmap.geom.jts.primitive.curve.AbstractCurve;
import org.gvsig.fmap.geom.jts.primitive.curve.spline.Spline2D;
import org.gvsig.fmap.geom.jts.primitive.curve.spline.Spline2DM;
import org.gvsig.fmap.geom.jts.primitive.curve.spline.Spline3D;
import org.gvsig.fmap.geom.jts.primitive.curve.spline.Spline3DM;
import org.gvsig.fmap.geom.jts.primitive.point.Point2D;
import org.gvsig.fmap.geom.jts.primitive.point.PointJTS;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.jts.util.ReadOnlyCoordinates;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.IGeneralPathX;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;

public abstract class AbstractSpline
extends AbstractCurve {
    private static final long serialVersionUID = -1562503359430991082L;
    protected ArrayListCoordinateSequence coordinates;
    protected PointJTS anyVertex;
    protected static final double SUBSEGMENTS = 30.0;

    public AbstractSpline(int type, int subtype) {
        super(type, subtype);
    }

    public AbstractSpline(int type, int subtype, Coordinate[] coordinates, PointJTS aVertex) {
        this(type, subtype);
        this.coordinates = new ArrayListCoordinateSequence(new ReadOnlyCoordinates(coordinates));
        this.anyVertex = aVertex;
    }

    @Override
    public com.vividsolutions.jts.geom.Geometry getJTS() {
        return JTSUtils.createJTSLineString(this.getProjection(), this.getSplineCoordinates());
    }

    protected abstract ArrayListCoordinateSequence getSplineCoordinates();

    public OrientablePrimitive addVertex(Point point) {
        point = this.fixPoint(point);
        this.coordinates.add(((PointJTS)point).getJTSCoordinate());
        this.anyVertex = (PointJTS)point;
        return this;
    }

    public void setPoints(Point initialPoint, Point endPoint) {
        initialPoint = this.fixPoint(initialPoint);
        endPoint = this.fixPoint(endPoint);
        this.coordinates.clear();
        this.addVertex(initialPoint);
        this.addVertex(endPoint);
        this.anyVertex = (PointJTS)endPoint;
    }

    protected abstract Point fixPoint(Point var1);

    public double getCoordinateAt(int index, int dimension) {
        return this.coordinates.getOrdinate(index, dimension);
    }

    public OrientablePrimitive setCoordinateAt(int index, int dimension, double value) {
        this.coordinates.setOrdinate(index, dimension, value);
        return this;
    }

    public void removeVertex(int index) {
        this.coordinates.remove(index);
    }

    public int getNumVertices() {
        return this.coordinates.size();
    }

    public OrientablePrimitive insertVertex(int index, Point p) {
        p = this.fixPoint(p);
        this.coordinates.add(index, ((PointJTS)p).getJTSCoordinate());
        return this;
    }

    public OrientablePrimitive setVertex(int index, Point p) {
        p = this.fixPoint(p);
        this.coordinates.set(index, ((PointJTS)p).getJTSCoordinate());
        return this;
    }

    public void setGeneralPath(GeneralPathX generalPathX) {
        PathIterator it = generalPathX.getPathIterator(null);
        double[] segment = new double[6];
        int i = 0;
        while (!it.isDone()) {
            Point2D p;
            int type = it.currentSegment(segment);
            if (i == 0) {
                switch (type) {
                    case 0: {
                        p = new Point2D(segment[0], segment[1]);
                        p = this.fixPoint(p);
                        this.coordinates.add(((PointJTS)p).getJTSCoordinate());
                        break;
                    }
                    default: {
                        String message = StringUtils.replace((String)"Type of segment %(segment)s isn't SEG_MOVETO.", (String)"%(segment)s", (String)String.valueOf(i));
                        LOGGER.warn(message);
                        throw new RuntimeException(message);
                    }
                }
            } else {
                switch (type) {
                    case 1: {
                        p = new Point2D(segment[0], segment[1]);
                        p = this.fixPoint(p);
                        this.coordinates.add(((PointJTS)p).getJTSCoordinate());
                        break;
                    }
                    case 2: {
                        int j;
                        for (j = 0; j <= 1; ++j) {
                            p = new Point2D(segment[i], segment[i + 1]);
                            p = this.fixPoint(p);
                            this.coordinates.add(((PointJTS)p).getJTSCoordinate());
                        }
                        break;
                    }
                    case 3: {
                        int j;
                        for (j = 0; j <= 2; ++j) {
                            p = new Point2D(segment[i], segment[i + 1]);
                            p = this.fixPoint(p);
                            this.coordinates.add(((PointJTS)p).getJTSCoordinate());
                        }
                        break;
                    }
                    case 4: {
                        this.coordinates.add(this.coordinates.get(0));
                        break;
                    }
                    default: {
                        String message = StringUtils.replace((String)"The general path has a gap in segment %(segment)s.", (String)"%(segment)s", (String)String.valueOf(i));
                        LOGGER.warn(message);
                        throw new RuntimeException(message);
                    }
                }
            }
            it.next();
            ++i;
        }
    }

    public void addMoveToVertex(Point point) {
        throw new UnsupportedOperationException();
    }

    public void closePrimitive() {
        if (!this.coordinates.isEmpty() && !this.isClosed()) {
            this.coordinates.add((Coordinate)((Coordinate)this.coordinates.get(0)).clone());
        }
    }

    public OrientablePrimitive ensureCapacity(int capacity) {
        this.coordinates.ensureCapacity(capacity);
        return this;
    }

    public void reProject(ICoordTrans ct) {
        if (ct == null) {
            return;
        }
        ArrayListCoordinateSequence tmpCoordinates = new ArrayListCoordinateSequence();
        tmpCoordinates.ensureCapacity(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            java.awt.geom.Point2D p = new Point2D.Double(coordinate.x, coordinate.y);
            try {
                p = ct.convert(p, p);
                coordinate.x = p.getX();
                coordinate.y = p.getY();
                tmpCoordinates.add(coordinate);
            }
            catch (Exception exception) {}
        }
        this.coordinates = tmpCoordinates;
        this.setProjection(ct.getPDest());
    }

    public void transform(AffineTransform at) {
        if (at == null) {
            return;
        }
        for (Coordinate coordinate : this.coordinates) {
            Point2D.Double p = new Point2D.Double(coordinate.x, coordinate.y);
            at.transform(p, p);
            coordinate.x = ((java.awt.geom.Point2D)p).getX();
            coordinate.y = ((java.awt.geom.Point2D)p).getY();
        }
    }

    public int getDimension() {
        return this.anyVertex.getDimension();
    }

    public Shape getShape(AffineTransform affineTransform) {
        if (this.isEmpty()) {
            return new GeneralPath();
        }
        return new DefaultGeneralPathX(new SplineIterator(affineTransform), false, 0.0);
    }

    public Shape getShape() {
        return this.getShape(null);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        SplineIterator pi = new SplineIterator(at);
        return pi;
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    public GeneralPathX getGeneralPath() {
        return (GeneralPathX)this.getShape(null);
    }

    @Override
    public boolean is3D() {
        return this.anyVertex.is3D();
    }

    public void flip() throws GeometryOperationNotSupportedException, GeometryOperationException {
        Collections.reverse(this.coordinates);
    }

    protected ArrayListCoordinateSequence cloneCoordinates() {
        ArrayListCoordinateSequence cloned = new ArrayListCoordinateSequence();
        cloned.ensureCapacity(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            cloned.add((Coordinate)coordinate.clone());
        }
        return cloned;
    }

    public Geometry force2D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates2D = new ArrayListCoordinateSequence();
        coordinates2D.ensureCapacity(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates2D.add(new Coordinate(coordinate.x, coordinate.y));
        }
        Spline2D s = new Spline2D(coordinates2D);
        s.setProjection(this.getProjection());
        return s;
    }

    @Override
    public Geometry force2DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates2DM = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates2DM.add(MCoordinate.create2dWithMeasure(coordinate.x, coordinate.y, coordinate instanceof MCoordinate ? coordinate.getOrdinate(3) : 0.0));
        }
        Spline2DM s = new Spline2DM(coordinates2DM);
        s.setProjection(this.getProjection());
        return s;
    }

    @Override
    public Geometry force3D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates3D = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates3D.add(new Coordinate(coordinate.x, coordinate.y, Double.isNaN(coordinate.z) ? 0.0 : coordinate.z));
        }
        Spline3D s = new Spline3D(coordinates3D);
        s.setProjection(this.getProjection());
        return s;
    }

    @Override
    public Geometry force3DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates3DM = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates3DM.add(MCoordinate.create3dWithMeasure(coordinate.x, coordinate.y, Double.isNaN(coordinate.z) ? 0.0 : coordinate.z, coordinate instanceof MCoordinate ? coordinate.getOrdinate(3) : 0.0));
        }
        Spline3DM s = new Spline3DM(coordinates3DM);
        s.setProjection(this.getProjection());
        return s;
    }

    protected boolean isClosed() {
        return ((Coordinate)this.coordinates.get(0)).equals(this.coordinates.get(this.coordinates.size() - 1));
    }

    public boolean canBeTransformed(AffineTransform at) {
        return true;
    }

    public boolean canBeReprojected(ICoordTrans ct) {
        return true;
    }

    public class SplineIterator
    extends GeneralPathXIterator {
        private final AffineTransform at;
        private boolean done;
        private int index;

        public SplineIterator(AffineTransform at) {
            super((IGeneralPathX)new GeneralPathX());
            this.index = 0;
            if (at == null) {
                at = new AffineTransform();
            }
            this.at = at;
            this.done = AbstractSpline.this.isEmpty();
        }

        @Override
        public int getWindingRule() {
            return 0;
        }

        @Override
        public void next() {
            this.done = AbstractSpline.this.getJTS().getCoordinates().length == ++this.index;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public int currentSegment(double[] coords) {
            Coordinate[] jtsCoordinates = AbstractSpline.this.getJTS().getCoordinates();
            coords[0] = jtsCoordinates[this.index].x;
            coords[1] = jtsCoordinates[this.index].y;
            this.at.transform(coords, 0, coords, 0, 1);
            if (this.index == 0) {
                return 0;
            }
            return 1;
        }

        @Override
        public int currentSegment(float[] coords) {
            Coordinate[] jtsCoordinates = AbstractSpline.this.getJTS().getCoordinates();
            coords[0] = (float)jtsCoordinates[this.index].x;
            coords[1] = (float)jtsCoordinates[this.index].y;
            this.at.transform(coords, 0, coords, 0, 1);
            if (this.index == 0) {
                return 0;
            }
            return 1;
        }
    }

    static class Spline {
        private final double[] y;
        private final double[] y2;

        public Spline(double[] y) {
            int i;
            this.y = y;
            int n = y.length;
            this.y2 = new double[n];
            double[] u = new double[n];
            for (i = 1; i < n - 1; ++i) {
                this.y2[i] = -1.0 / (4.0 + this.y2[i - 1]);
                u[i] = (6.0 * (y[i + 1] - 2.0 * y[i] + y[i - 1]) - u[i - 1]) / (4.0 + this.y2[i - 1]);
            }
            for (i = n - 2; i >= 0; --i) {
                this.y2[i] = this.y2[i] * this.y2[i + 1] + u[i];
            }
        }

        public double fn(int n, double t) {
            return t * this.y[n + 1] - (t - 1.0) * t * ((t - 2.0) * this.y2[n] - (t + 1.0) * this.y2[n + 1]) / 6.0 + this.y[n] - t * this.y[n];
        }
    }
}

