/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.curve.spline;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.ArrayList;
import java.util.Collection;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine2DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint2DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon2DM;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line2DM;
import org.gvsig.fmap.geom.jts.primitive.curve.spline.AbstractSpline;
import org.gvsig.fmap.geom.jts.primitive.point.Point2DM;
import org.gvsig.fmap.geom.jts.primitive.point.Point3D;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon2DM;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.jts.util.ReadOnlyCoordinates;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;

public abstract class BaseSpline2DM
extends AbstractSpline {
    private static final long serialVersionUID = 3466337030657231939L;

    public BaseSpline2DM(int type) {
        super(type, 2);
        this.coordinates = new ArrayListCoordinateSequence((Collection<Coordinate>)new ArrayList<Coordinate>());
    }

    public BaseSpline2DM(int type, Coordinate[] coordinates) {
        super(type, 2);
        this.coordinates = new ArrayListCoordinateSequence(new ReadOnlyCoordinates(coordinates));
        if (coordinates.length < 1) {
            this.anyVertex = new Point3D(0.0, 0.0, 0.0);
        } else {
            Coordinate coordinate = coordinates[0];
            this.anyVertex = new Point3D(coordinate.x, coordinate.y, coordinate.getOrdinate(3));
        }
    }

    public BaseSpline2DM(int type, ArrayListCoordinateSequence coordinates) {
        super(type, 2);
        this.coordinates = coordinates;
    }

    public OrientablePrimitive addVertex(double x, double y) {
        return this.addVertex(new Point2DM(x, y, 0.0));
    }

    public OrientablePrimitive addVertex(double x, double y, double z) {
        String message = "Can't add x,y,z coordinate to Polygon2DM.";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    @Override
    protected Point fixPoint(Point point) {
        if (point instanceof Point2DM) {
            return point;
        }
        return new Point2DM(point.getX(), point.getY(), 0.0);
    }

    @Override
    protected ArrayListCoordinateSequence getSplineCoordinates() {
        ArrayListCoordinateSequence splineCoordinates = new ArrayListCoordinateSequence();
        if (splineCoordinates == null || splineCoordinates.size() == 0) {
            int num = this.coordinates.size();
            double[] px = new double[num];
            double[] py = new double[num];
            double[] pm = new double[num];
            for (int i = 0; i < num; ++i) {
                Coordinate coord = (Coordinate)this.coordinates.get(i);
                px[i] = coord.x;
                py[i] = coord.y;
                pm[i] = coord.getOrdinate(3);
            }
            AbstractSpline.Spline splineX = new AbstractSpline.Spline(px);
            AbstractSpline.Spline splineY = new AbstractSpline.Spline(py);
            AbstractSpline.Spline splineM = new AbstractSpline.Spline(pm);
            splineCoordinates.add(this.coordinates.get(0));
            for (int i = 0; i < this.coordinates.size() - 1; ++i) {
                int t = 1;
                while ((double)t <= 30.0) {
                    if ((double)t == 30.0 && i == this.coordinates.size() - 2) {
                        splineCoordinates.add(JTSUtils.createMCoordinate(px[px.length - 1], py[px.length - 1], pm[px.length - 1]));
                    } else {
                        double x1 = splineX.fn(i, (double)t / 30.0);
                        double y1 = splineY.fn(i, (double)t / 30.0);
                        double m1 = splineM.fn(i, (double)t / 30.0);
                        splineCoordinates.add(JTSUtils.createMCoordinate(x1, y1, m1));
                    }
                    ++t;
                }
            }
        }
        return splineCoordinates;
    }

    public MultiPoint toPoints() throws GeometryException {
        MultiPoint2DM multiPoint = new MultiPoint2DM();
        Coordinate[] theCoordinates = this.getJTS().getCoordinates();
        multiPoint.ensureCapacity(theCoordinates.length);
        for (Coordinate theCoordinate : theCoordinates) {
            multiPoint.addPoint(new Point2DM(this.getProjection(), theCoordinate));
        }
        return multiPoint;
    }

    public MultiLine toLines() throws GeometryException {
        MultiLine2DM multiLine = new MultiLine2DM();
        Line2DM line = new Line2DM(this.getJTS().getCoordinates());
        multiLine.addPrimitive(line);
        return multiLine;
    }

    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon2DM multiPolygon = new MultiPolygon2DM();
        Polygon2DM polygon = new Polygon2DM(this.getJTS().getCoordinates());
        multiPolygon.addPrimitive(polygon);
        return multiPolygon;
    }

    public Point getVertex(int index) {
        Point2DM vertex = new Point2DM(this.getProjection(), (Coordinate)this.coordinates.get(index));
        this.anyVertex = vertex;
        return vertex;
    }
}

