/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.curve.spline;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.operation.buffer.BufferParameters;
import java.util.ArrayList;
import java.util.Collection;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.jts.primitive.curve.spline.BaseSpline3D;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.jts.util.OpenJUMPUtils;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Spline;

public class Spline3D
extends BaseSpline3D
implements Spline {
    private static final long serialVersionUID = 8377943996574176559L;

    public Spline3D() {
        super(14);
    }

    public Spline3D(Coordinate[] coordinates) {
        super(14, coordinates);
    }

    public Spline3D(ArrayListCoordinateSequence coordinates) {
        super(14, coordinates);
    }

    public Geometry cloneGeometry() {
        Spline3D clone = new Spline3D(this.cloneCoordinates().toCoordinateArray());
        clone.setProjection(this.getProjection());
        return clone;
    }

    public Geometry offset(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        Coordinate[] coords = this.getJTS().getCoordinates();
        ArrayListCoordinateSequence listCoordSequence = new ArrayListCoordinateSequence((Collection<Coordinate>)new ArrayList<Coordinate>());
        for (int i = 0; i < coords.length; ++i) {
            listCoordSequence.add(coords[i]);
        }
        if (this.isClosed()) {
            return JTSUtils.offsetClosedLine(this.getProjection(), listCoordSequence, distance);
        }
        return OpenJUMPUtils.offsetCleanOpenLine(this.getProjection(), listCoordSequence, distance);
    }

    public Geometry offset(int joinStyle, double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        Coordinate[] coords = this.getJTS().getCoordinates();
        ArrayListCoordinateSequence listCoordSequence = new ArrayListCoordinateSequence((Collection<Coordinate>)new ArrayList<Coordinate>());
        for (int i = 0; i < coords.length; ++i) {
            listCoordSequence.add(coords[i]);
        }
        if (this.isClosed()) {
            return JTSUtils.offsetClosedLine(this.getProjection(), listCoordSequence, joinStyle, distance);
        }
        BufferParameters bufParams = JTSUtils.getBufferParameters(joinStyle, 2);
        return OpenJUMPUtils.offsetCleanOpenLine(this.getProjection(), listCoordSequence, bufParams, distance);
    }

    @Override
    public boolean equals(Object obj) {
        boolean res = super.equals(obj);
        if (res && obj instanceof Spline3D) {
            Spline3D other = (Spline3D)obj;
            if (this.getNumVertices() != other.getNumVertices()) {
                return false;
            }
            for (int i = 0; i < this.getNumVertices(); ++i) {
                Coordinate coordinate = (Coordinate)this.coordinates.get(i);
                Coordinate otherCoordinate = (Coordinate)other.coordinates.get(i);
                if (otherCoordinate.getOrdinate(2) == coordinate.getOrdinate(2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Geometry force3D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        Geometry c = this.cloneGeometry();
        return c;
    }
}

