/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.surface.circle;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.geom.PathIterator;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine3D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint2DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon3D;
import org.gvsig.fmap.geom.jts.mgeom.MCoordinate;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line2DM;
import org.gvsig.fmap.geom.jts.primitive.point.Point2DM;
import org.gvsig.fmap.geom.jts.primitive.point.PointJTS;
import org.gvsig.fmap.geom.jts.primitive.surface.circle.AbstractCircle;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon2DM;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.primitive.Point;

public abstract class BaseCircle2DM
extends AbstractCircle {
    public BaseCircle2DM(int type, int subtype, Point center, double radius) {
        super(type, subtype, center, radius);
    }

    public BaseCircle2DM(int type, int subtype) {
        super(type, subtype);
    }

    public void setPoints(Point p1, Point p2, Point p3) {
        this.center = new Point2DM(p1.getProjection(), JTSUtils.getCircumcentre(p1, p2, p3));
        Point2DM aPoint = new Point2DM(p1.getX(), p1.getY(), ((Point2DM)this.center).getM());
        this.radius = ((PointJTS)this.center).getJTS().distance(aPoint.getJTS());
        this.setProjection(this.center.getProjection());
    }

    @Override
    protected Point fixPoint(Point point) {
        if (point instanceof Point2DM) {
            return point;
        }
        return new Point2DM(point.getX(), point.getY(), 0.0);
    }

    protected ArrayListCoordinateSequence getJTSCoordinates() {
        PathIterator pi = this.getPathIterator(null);
        ArrayListCoordinateSequence coordinates = new ArrayListCoordinateSequence();
        Point2DM c = (Point2DM)this.getCenter();
        double mValue = c.getM();
        double[] coords = new double[6];
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    coordinates.add(new MCoordinate(coords[0], coords[1], Double.NaN, mValue));
                    break;
                }
                case 1: {
                    coordinates.add(new MCoordinate(coords[0], coords[1], Double.NaN, mValue));
                    break;
                }
                case 2: {
                    coordinates.add(new MCoordinate(coords[0], coords[1], Double.NaN, mValue));
                    coordinates.add(new MCoordinate(coords[2], coords[3], Double.NaN, mValue));
                    break;
                }
                case 3: {
                    coordinates.add(new MCoordinate(coords[0], coords[1], Double.NaN, mValue));
                    coordinates.add(new MCoordinate(coords[2], coords[3], Double.NaN, mValue));
                    coordinates.add(new MCoordinate(coords[4], coords[5], Double.NaN, mValue));
                    break;
                }
                case 4: {
                    coordinates.add(coordinates.get(0));
                }
            }
            pi.next();
        }
        if (!((Coordinate)coordinates.get(0)).equals(coordinates.get(coordinates.size() - 1))) {
            coordinates.add((Coordinate)((Coordinate)coordinates.get(0)).clone());
        }
        return coordinates;
    }

    public MultiPoint toPoints() throws GeometryException {
        MultiPoint2DM multiPoint = new MultiPoint2DM();
        Coordinate[] coordinates = this.getJTS().getCoordinates();
        multiPoint.ensureCapacity(coordinates.length);
        for (int i = 0; i < coordinates.length; ++i) {
            multiPoint.addPoint(new Point2DM(this.getProjection(), coordinates[i].x, coordinates[i].y, ((Point2DM)this.getCenter()).getM()));
        }
        return multiPoint;
    }

    public MultiLine toLines() throws GeometryException {
        MultiLine3D multiLine = new MultiLine3D();
        Line2DM line = new Line2DM(this.getJTS().getCoordinates());
        multiLine.addPrimitive(line);
        return multiLine;
    }

    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon3D multiPolygon = new MultiPolygon3D();
        Polygon2DM polygon = new Polygon2DM(this.getJTS().getCoordinates());
        multiPolygon.addPrimitive(polygon);
        return multiPolygon;
    }
}

