/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.surface.filledspline;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.List;
import org.cresques.cts.ICoordTrans;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.jts.mgeom.MCoordinate;
import org.gvsig.fmap.geom.jts.primitive.curve.spline.BaseSpline3D;
import org.gvsig.fmap.geom.jts.primitive.surface.filledspline.FilledSpline2D;
import org.gvsig.fmap.geom.jts.primitive.surface.filledspline.FilledSpline2DM;
import org.gvsig.fmap.geom.jts.primitive.surface.filledspline.FilledSpline3DM;
import org.gvsig.fmap.geom.jts.primitive.surface.split.SurfaceSplitOperation;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.FilledSpline;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Ring;
import org.gvsig.fmap.geom.primitive.SurfaceAppearance;

public class FilledSpline3D
extends BaseSpline3D
implements FilledSpline {
    private static final long serialVersionUID = -8947796452807902242L;

    public FilledSpline3D() {
        super(25);
    }

    public FilledSpline3D(Coordinate[] coordinates) {
        super(25, coordinates);
        this.closePrimitive();
    }

    public FilledSpline3D(ArrayListCoordinateSequence coordinates) {
        super(25, coordinates);
        this.closePrimitive();
    }

    public void setSurfaceAppearance(SurfaceAppearance app) {
    }

    public SurfaceAppearance getSurfaceAppearance() {
        return null;
    }

    public int getNumInteriorRings() {
        String message = "Calling deprecated method getNumInteriorRings of a filled spline";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public Ring getInteriorRing(int index) {
        String message = "Calling deprecated method getInteriorRing of a filled spline";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void addInteriorRing(Ring ring) {
        String message = "Calling deprecated method addInteriorRing of a filled spline";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void addInteriorRing(Line line) {
        String message = "Calling deprecated method addInteriorRing of a filled spline";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void addInteriorRing(Polygon polygon) {
        String message = "Calling deprecated method addInteriorRing of a filled spline";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public void removeInteriorRing(int index) {
        String message = "Calling deprecated method removeInteriorRing of a filled spline";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public List<Ring> getInteriorRings() {
        String message = "Calling method getInteriorRings of a filled spline";
        this.notifyDeprecated(message);
        throw new UnsupportedOperationException(message);
    }

    public Geometry cloneGeometry() {
        FilledSpline3D clone = new FilledSpline3D(this.cloneCoordinates().toCoordinateArray());
        clone.setProjection(this.getProjection());
        return clone;
    }

    @Override
    public com.vividsolutions.jts.geom.Geometry getJTS() {
        return JTSUtils.createJTSPolygon(this.getProjection(), this.getSplineCoordinates());
    }

    public Geometry offset(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return JTSUtils.createGeometry(this.getProjection(), this.getJTS().buffer(distance));
    }

    public Geometry offset(int jointStyle, double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return JTSUtils.createGeometry(this.getProjection(), this.getJTS().buffer(distance, JTSUtils.calculateQuadrantSegments(jointStyle)));
    }

    @Override
    public void reProject(ICoordTrans ct) {
        super.reProject(ct);
        if (this.coordinates.size() >= 2 && !this.isClosed()) {
            this.closePrimitive();
        }
    }

    @Override
    public boolean equals(Object obj) {
        boolean res = super.equals(obj);
        if (res && obj instanceof FilledSpline3D) {
            FilledSpline3D other = (FilledSpline3D)obj;
            if (this.getNumVertices() != other.getNumVertices()) {
                return false;
            }
            for (int i = 0; i < this.getNumVertices(); ++i) {
                Coordinate coordinate = (Coordinate)this.coordinates.get(i);
                Coordinate otherCoordinate = (Coordinate)other.coordinates.get(i);
                if (otherCoordinate.getOrdinate(2) == coordinate.getOrdinate(2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Geometry split(Geometry splitter) {
        SurfaceSplitOperation op = new SurfaceSplitOperation();
        return op.split(this, splitter);
    }

    @Override
    public Geometry force2D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates2D = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates2D.add(new Coordinate(coordinate.x, coordinate.y));
        }
        FilledSpline2D s = new FilledSpline2D(coordinates2D);
        s.setProjection(this.getProjection());
        return s;
    }

    @Override
    public Geometry force2DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates2DM = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates2DM.add(MCoordinate.create2dWithMeasure(coordinate.x, coordinate.y, 0.0));
        }
        FilledSpline2DM s = new FilledSpline2DM(coordinates2DM);
        s.setProjection(this.getProjection());
        return s;
    }

    @Override
    public Geometry force3D() throws GeometryOperationNotSupportedException, GeometryOperationException {
        Geometry geom = this.cloneGeometry();
        return geom;
    }

    @Override
    public Geometry force3DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        ArrayListCoordinateSequence coordinates3DM = new ArrayListCoordinateSequence(this.coordinates.size());
        for (Coordinate coordinate : this.coordinates) {
            coordinates3DM.add(MCoordinate.create3dWithMeasure(coordinate.x, coordinate.y, coordinate.z, 0.0));
        }
        FilledSpline3DM s = new FilledSpline3DM(coordinates3DM);
        s.setProjection(this.getProjection());
        return s;
    }
}

