/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.surface.polygon;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Ring;

public class PolygonIterator
implements PathIterator {
    private final AffineTransform at;
    private boolean done;
    private int index = 0;
    private final Polygon polygon;
    private int currentRing = 0;
    private int currentRingIndex = 0;
    private int numVertices = -1;

    public PolygonIterator(Polygon polygon, AffineTransform at) {
        if (at == null) {
            at = new AffineTransform();
        }
        this.polygon = polygon;
        this.at = at;
        this.done = this.polygon.isEmpty();
    }

    @Override
    public int getWindingRule() {
        return 0;
    }

    @Override
    public void next() {
        if (this.numVertices < 0) {
            this.numVertices = this.polygon.getNumVertices();
            for (int i = 0; i < this.polygon.getNumInteriorRings(); ++i) {
                this.numVertices += this.polygon.getInteriorRing(i).getNumVertices();
            }
        }
        this.done = this.numVertices == ++this.index;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public int currentSegment(double[] coords) {
        if (this.index < this.polygon.getNumVertices()) {
            coords[0] = this.polygon.getCoordinateAt(this.index, 0);
            coords[1] = this.polygon.getCoordinateAt(this.index, 1);
            this.at.transform(coords, 0, coords, 0, 1);
            if (this.index == 0) {
                return 0;
            }
            return 1;
        }
        if (this.currentRing < this.polygon.getNumInteriorRings()) {
            Ring ring = this.polygon.getInteriorRing(this.currentRing);
            coords[0] = ring.getCoordinateAt(this.currentRingIndex, 0);
            coords[1] = ring.getCoordinateAt(this.currentRingIndex, 1);
            this.at.transform(coords, 0, coords, 0, 1);
            if (this.currentRingIndex == 0) {
                ++this.currentRingIndex;
                if (this.currentRingIndex >= ring.getNumVertices()) {
                    ++this.currentRing;
                    this.currentRingIndex = 0;
                }
                return 0;
            }
            ++this.currentRingIndex;
            if (this.currentRingIndex >= ring.getNumVertices()) {
                ++this.currentRing;
                this.currentRingIndex = 0;
            }
            return 1;
        }
        return 4;
    }

    @Override
    public int currentSegment(float[] coords) {
        if (this.index < this.polygon.getNumVertices()) {
            coords[0] = (float)this.polygon.getCoordinateAt(this.index, 0);
            coords[1] = (float)this.polygon.getCoordinateAt(this.index, 1);
            this.at.transform(coords, 0, coords, 0, 1);
            if (this.index == 0) {
                return 0;
            }
            return 1;
        }
        if (this.currentRing < this.polygon.getNumInteriorRings()) {
            Ring ring = this.polygon.getInteriorRing(this.currentRing);
            coords[0] = (float)ring.getCoordinateAt(this.currentRingIndex, 0);
            coords[1] = (float)ring.getCoordinateAt(this.currentRingIndex, 1);
            this.at.transform(coords, 0, coords, 0, 1);
            if (this.currentRingIndex == 0) {
                ++this.currentRingIndex;
                if (this.currentRingIndex >= ring.getNumVertices()) {
                    ++this.currentRing;
                    this.currentRingIndex = 0;
                }
                return 0;
            }
            ++this.currentRingIndex;
            if (this.currentRingIndex >= ring.getNumVertices()) {
                ++this.currentRing;
                this.currentRingIndex = 0;
            }
            return 1;
        }
        return 4;
    }
}

