/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.surface.split;

import com.vividsolutions.jts.algorithm.Angle;
import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.DirectedEdgeStar;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.List;

class SplitEdgeStar
extends DirectedEdgeStar {
    SplitEdgeStar() {
    }

    public void insert(DirectedEdge de) {
        if (de == null) {
            throw new NullPointerException();
        }
        this.insertEdgeEnd((EdgeEnd)de, de);
    }

    public void insert(EdgeEnd ee) {
        this.insert((DirectedEdge)ee);
    }

    public void remove(DirectedEdge edge) {
        if (edge == null) {
            throw new NullPointerException("edge");
        }
        int degree = this.getDegree();
        Object removed = this.edgeMap.remove(edge);
        int afterDegree = this.getDegree();
        Assert.isTrue((afterDegree == degree - 1 ? 1 : 0) != 0);
        if (edge != removed) {
            throw new IllegalArgumentException("Tried to remove an edge not registered in this edge star: " + edge);
        }
        this.edgeList = null;
    }

    private List getOutgoingEdges() {
        Coordinate nodeCoord = this.getCoordinate();
        List edges = this.getEdges();
        ArrayList<DirectedEdge> outgoingEdges = new ArrayList<DirectedEdge>(edges.size());
        for (DirectedEdge edge : edges) {
            if (!nodeCoord.equals2D(edge.getCoordinate())) {
                edge = edge.getSym();
            }
            assert (nodeCoord.equals2D(edge.getCoordinate()));
            outgoingEdges.add(edge);
        }
        return outgoingEdges;
    }

    public DirectedEdge findClosestEdgeInDirection(DirectedEdge edge, int searchDirection) {
        if (edge == null) {
            throw new NullPointerException("edge");
        }
        if (-1 != searchDirection && 1 != searchDirection) {
            throw new IllegalArgumentException("Allowed values for for searchDirection are CGAlgorithms.CLOCKWISE and CGAlgorithms.COUNTERCLOCKWISE: " + searchDirection);
        }
        if (super.findIndex((EdgeEnd)edge) == -1 && super.findIndex((EdgeEnd)(edge = edge.getSym())) == -1) {
            throw new IllegalArgumentException("Edge does not belongs to this edgestar");
        }
        int degree = this.getDegree();
        if (degree < 2) {
            throw new IllegalStateException("there must be at least two edges in the edge star");
        }
        Coordinate nodeCoord = this.getCoordinate();
        assert (nodeCoord.equals2D(edge.getCoordinate()));
        double acutestAngle = Double.MAX_VALUE;
        DirectedEdge acutest = null;
        DirectedEdge adjacentEdge2 = null;
        Coordinate tip1 = edge.getDirectedCoordinate();
        Coordinate tail = nodeCoord;
        List outgoingEdges = this.getOutgoingEdges();
        for (DirectedEdge adjacentEdge2 : outgoingEdges) {
            Coordinate tip2;
            double angle;
            if (adjacentEdge2 == edge || !((angle = this.computeAngleInDirection(tip1, tail, tip2 = adjacentEdge2.getDirectedCoordinate(), searchDirection)) < acutestAngle)) continue;
            acutestAngle = angle;
            acutest = adjacentEdge2;
        }
        return acutest;
    }

    public double computeAngleInDirection(Coordinate tip1, Coordinate tail, Coordinate tip2, int direction) {
        int orientation = CGAlgorithms.computeOrientation((Coordinate)tail, (Coordinate)tip1, (Coordinate)tip2);
        double angle = Angle.angleBetween((Coordinate)tip1, (Coordinate)tail, (Coordinate)tip2);
        if (orientation != direction) {
            angle = Math.PI * 2 - angle;
        }
        return angle;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SplitEdgeStar[degree: ");
        sb.append(this.getDegree()).append(", edges: ");
        for (DirectedEdge de : this.getEdges()) {
            sb.append("DirectedEdge[");
            sb.append(de.getEdge()).append(" ");
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }
}

