/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.surface.split;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.NodeFactory;
import com.vividsolutions.jts.geomgraph.PlanarGraph;
import com.vividsolutions.jts.geomgraph.Quadrant;
import java.util.ArrayList;
import org.gvsig.fmap.geom.jts.primitive.surface.split.SplitEdge;
import org.gvsig.fmap.geom.jts.primitive.surface.split.SplitGraphNode;
import org.gvsig.fmap.geom.jts.primitive.surface.split.SplitGraphNodeFactory;
import org.slf4j.LoggerFactory;

class SplitGraph
extends PlanarGraph {
    private static final NodeFactory NODE_FACTORY = new SplitGraphNodeFactory();
    private final Polygon polygon;
    private final LineString splitter;

    public SplitGraph(Polygon polygon, LineString splitter) {
        super(NODE_FACTORY);
        this.polygon = polygon;
        this.polygon.normalize();
        this.splitter = this.normalizeSplitter(splitter);
        this.buildGraph();
    }

    private LineString normalizeSplitter(LineString original) {
        boolean isCounterClockWise;
        Coordinate coord1;
        LineString normalizedSplitter = this.removeInteriorEndPoints(this.polygon, original);
        Coordinate[] splitterCoords = normalizedSplitter.getCoordinates();
        Coordinate coord0 = splitterCoords[0];
        int quadrant = Quadrant.quadrant((Coordinate)coord0, (Coordinate)(coord1 = splitterCoords[1]));
        boolean bl = isCounterClockWise = 1 == quadrant || 2 == quadrant;
        if (isCounterClockWise) {
            CoordinateArrays.reverse((Coordinate[])splitterCoords);
            GeometryFactory gf = original.getFactory();
            normalizedSplitter = gf.createLineString(splitterCoords);
        }
        return normalizedSplitter;
    }

    public void remove(SplitEdge edge) {
        DirectedEdge edgeEnd = (DirectedEdge)this.findEdgeEnd(edge);
        if (edgeEnd == null) {
            throw new IllegalArgumentException("No enclosing edge end found for " + (Object)((Object)edge));
        }
        this.remove(edgeEnd);
    }

    public void remove(DirectedEdge edgeEnd) {
        if (edgeEnd == null) {
            throw new NullPointerException();
        }
        if (this.edgeEndList.remove(edgeEnd)) {
            DirectedEdge sym = edgeEnd.getSym();
            this.edgeEndList.remove(sym);
            Edge edge = edgeEnd.getEdge();
            this.edges.remove(edge);
            SplitGraphNode node = (SplitGraphNode)edgeEnd.getNode();
            SplitGraphNode endNode = (SplitGraphNode)sym.getNode();
            node.remove(edgeEnd);
            endNode.remove(sym);
        }
    }

    private LineString removeInteriorEndPoints(Polygon polygon, LineString splitter) {
        int useTo;
        Point p;
        int useFrom;
        Coordinate[] coords = splitter.getCoordinates();
        GeometryFactory gf = splitter.getFactory();
        for (useFrom = 0; useFrom < coords.length && polygon.contains((Geometry)(p = gf.createPoint(coords[useFrom]))); ++useFrom) {
        }
        for (useTo = coords.length - 1; useTo >= useFrom && polygon.contains((Geometry)(p = gf.createPoint(coords[useTo]))); --useTo) {
        }
        if (useFrom == useTo) {
            throw new IllegalArgumentException("Line lies completely inside polygon");
        }
        int length = 1 + (useTo - useFrom);
        Coordinate[] crossingLineCoords = new Coordinate[length];
        System.arraycopy(coords, useFrom, crossingLineCoords, 0, length);
        LineString surelyCrossingLine = gf.createLineString(crossingLineCoords);
        return surelyCrossingLine;
    }

    private void buildGraph() {
        Geometry intersectingLineStrings = this.polygon.intersection((Geometry)this.splitter);
        Geometry nodedShell = this.polygon.getExteriorRing().difference((Geometry)this.splitter);
        LineString[] interiorRings = new LineString[this.polygon.getNumInteriorRing()];
        for (int i = 0; i < this.polygon.getNumInteriorRing(); ++i) {
            LineString interiorRingN;
            interiorRings[i] = interiorRingN = this.polygon.getInteriorRingN(i);
        }
        GeometryFactory factory = this.polygon.getFactory();
        MultiLineString interiorRingCollection = factory.createMultiLineString(interiorRings);
        Geometry nodedHoles = interiorRingCollection.difference((Geometry)this.splitter);
        this.addEdges(nodedShell, 1, 2, 0);
        this.addEdges(nodedHoles, 1, 0, 2);
        this.addEdges(intersectingLineStrings, 1, 0, 0);
    }

    private void addEdges(Geometry linearGeom, int onLoc, int leftLoc, int rightLoc) {
        int nParts = linearGeom.getNumGeometries();
        ArrayList<SplitEdge> edgesToAdd = new ArrayList<SplitEdge>();
        for (int i = 0; i < nParts; ++i) {
            Geometry currGeom = linearGeom.getGeometryN(i);
            Coordinate[] coords = currGeom.getCoordinates();
            if (coords.length < 2) continue;
            Label label = new Label(onLoc, leftLoc, rightLoc);
            SplitEdge edge = new SplitEdge(coords, label);
            edgesToAdd.add(edge);
        }
        try {
            super.addEdges(edgesToAdd);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

