/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.util;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.jts.GeometryJTS2;
import org.gvsig.fmap.geom.jts.aggregate.AbstractMultiPrimitive;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine2D;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine2DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine3D;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine3DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint2D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint2DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint3D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint3DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon2D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon2DM;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon3D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon3DM;
import org.gvsig.fmap.geom.jts.complex.DefaultComplex;
import org.gvsig.fmap.geom.jts.mgeom.MCoordinate;
import org.gvsig.fmap.geom.jts.primitive.curve.line.AbstractLine;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line2D;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line2DM;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line3D;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line3DM;
import org.gvsig.fmap.geom.jts.primitive.point.Point2D;
import org.gvsig.fmap.geom.jts.primitive.point.Point3D;
import org.gvsig.fmap.geom.jts.primitive.ring.Ring2D;
import org.gvsig.fmap.geom.jts.primitive.ring.Ring2DM;
import org.gvsig.fmap.geom.jts.primitive.ring.Ring3D;
import org.gvsig.fmap.geom.jts.primitive.ring.Ring3DM;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon2D;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon2DM;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon3D;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon3DM;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Ring;
import org.gvsig.fmap.geom.type.GeometryType;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JTSUtils2 {
    public static final Logger logger = LoggerFactory.getLogger(JTSUtils2.class);
    private static final GeometryFactory factory = new GeometryFactory();

    public static GeometryFactory getFactory() {
        GeometryFactory theFactory = factory;
        return theFactory;
    }

    public static Polygon createJTSPolygon(IProjection proj, ArrayListCoordinateSequence coordinates, List<Ring> interiorRings) {
        Coordinate[] coordinates2 = JTSUtils2.createCoordinate2(coordinates);
        GeometryFactory theFactory = JTSUtils2.getFactory();
        LinearRing shell = theFactory.createLinearRing(coordinates2);
        LinearRing[] holes = new LinearRing[interiorRings.size()];
        for (int i = 0; i < interiorRings.size(); ++i) {
            Ring ring = interiorRings.get(i);
            holes[i] = (LinearRing)((GeometryJTS2)ring).getJTS2();
        }
        return (Polygon)JTSUtils2.setSRID(proj, (org.locationtech.jts.geom.Geometry)theFactory.createPolygon(shell, holes));
    }

    public static GeometryCollection createJTSCollection(MultiPolygon aggregate) {
        GeometryFactory theFactory = JTSUtils2.getFactory();
        org.locationtech.jts.geom.Geometry[] geoms2 = new org.locationtech.jts.geom.Geometry[aggregate.size()];
        int i = 0;
        for (Geometry geometry : aggregate) {
            geoms2[i] = JTSUtils2.createJTSPolygon((org.gvsig.fmap.geom.primitive.Polygon)geometry);
        }
        GeometryCollection collection = theFactory.createGeometryCollection(geoms2);
        return collection;
    }

    public static Polygon createJTSPolygon(org.gvsig.fmap.geom.primitive.Polygon polygon) {
        return JTSUtils2.createJTSPolygon(polygon.getProjection(), (OrientablePrimitive)polygon.getExteriorRing(), polygon.getInteriorRings());
    }

    public static Polygon createJTSPolygon(IProjection proj, OrientablePrimitive ring, List<? extends OrientablePrimitive> interiorRings) {
        Coordinate[] coordinates2 = JTSUtils2.createCoordinate2(ring);
        GeometryFactory theFactory = JTSUtils2.getFactory();
        LinearRing shell = theFactory.createLinearRing(coordinates2);
        LinearRing[] holes = new LinearRing[interiorRings.size()];
        for (int i = 0; i < interiorRings.size(); ++i) {
            OrientablePrimitive interiorRing = interiorRings.get(i);
            holes[i] = (LinearRing)((GeometryJTS2)interiorRing).getJTS2();
        }
        return (Polygon)JTSUtils2.setSRID(proj, (org.locationtech.jts.geom.Geometry)theFactory.createPolygon(shell, holes));
    }

    public static LinearRing createJTSLinearRing(IProjection proj, com.vividsolutions.jts.geom.CoordinateSequence coordinates) {
        CoordinateSequence coordinates2 = JTSUtils2.createCoordinateSequence2(coordinates);
        GeometryFactory fact = JTSUtils2.getFactory();
        return (LinearRing)JTSUtils2.setSRID(proj, (org.locationtech.jts.geom.Geometry)fact.createLinearRing(CoordinateSequences.ensureValidRing((CoordinateSequenceFactory)fact.getCoordinateSequenceFactory(), (CoordinateSequence)coordinates2)));
    }

    public static org.locationtech.jts.geom.Geometry setSRID(IProjection proj, org.locationtech.jts.geom.Geometry g) {
        try {
            String x = StringUtils.split((String)proj.getAbrev(), (char)':')[1];
            g.setSRID(Integer.valueOf(x).intValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return g;
    }

    public static Coordinate[] createCoordinate2(ArrayListCoordinateSequence coordinates) {
        Coordinate[] coordinates2 = new Coordinate[coordinates.size()];
        int i = 0;
        for (com.vividsolutions.jts.geom.Coordinate coordinate : coordinates) {
            coordinates2[i++] = new Coordinate(coordinate.getOrdinate(0), coordinate.getOrdinate(1));
        }
        return coordinates2;
    }

    public static CoordinateSequence createCoordinateSequence2(com.vividsolutions.jts.geom.CoordinateSequence coordinates) {
        CoordinateSequence coordinates2 = JTSUtils2.getFactory().getCoordinateSequenceFactory().create(coordinates.size(), 2);
        for (int i = 0; i < coordinates.size(); ++i) {
            com.vividsolutions.jts.geom.Coordinate coordinate = coordinates.getCoordinate(i);
            coordinates2.setOrdinate(i, 0, coordinate.getOrdinate(0));
            coordinates2.setOrdinate(i, 1, coordinate.getOrdinate(1));
        }
        return coordinates2;
    }

    private static Coordinate[] createCoordinate2(OrientablePrimitive ring) {
        Coordinate[] coordinates2 = new Coordinate[ring.size()];
        for (int i = 0; i < ring.size(); ++i) {
            org.gvsig.fmap.geom.primitive.Point vertex = ring.getVertex(i);
            coordinates2[i] = new Coordinate(vertex.getX(), vertex.getY());
        }
        return coordinates2;
    }

    private static com.vividsolutions.jts.geom.Coordinate createCoordinate1(Coordinate coordinate) {
        if (Double.isNaN(coordinate.getM())) {
            com.vividsolutions.jts.geom.Coordinate x = new com.vividsolutions.jts.geom.Coordinate(coordinate.getX(), coordinate.getY());
            x.setOrdinate(2, coordinate.getZ());
            return x;
        }
        MCoordinate x = new MCoordinate(coordinate.getX(), coordinate.getY(), coordinate.getZ(), coordinate.getM());
        return x;
    }

    private static com.vividsolutions.jts.geom.Coordinate[] createCoordinates1(Coordinate[] coordinates2) {
        com.vividsolutions.jts.geom.Coordinate[] coordinates = new com.vividsolutions.jts.geom.Coordinate[coordinates2.length];
        for (int i = 0; i < coordinates2.length; ++i) {
            coordinates[i] = JTSUtils2.createCoordinate1(coordinates2[i]);
        }
        return coordinates;
    }

    public static Geometry createGeometry(IProjection proj, org.locationtech.jts.geom.Geometry jtsGeom) {
        return JTSUtils2.createGeometry(proj, jtsGeom, null);
    }

    public static Geometry createGeometry(IProjection proj, org.locationtech.jts.geom.Geometry jtsGeom, GeometryType typeWhenEmpty) {
        if (jtsGeom.isEmpty()) {
            if (typeWhenEmpty == null) {
                return null;
            }
            try {
                return typeWhenEmpty.create();
            }
            catch (CreateGeometryException ex) {
                return null;
            }
        }
        if (jtsGeom instanceof Point) {
            com.vividsolutions.jts.geom.Coordinate coordinate = JTSUtils2.createCoordinate1(jtsGeom.getCoordinate());
            if (Double.isNaN(coordinate.z)) {
                return new Point2D(proj, coordinate);
            }
            return new Point3D(proj, coordinate);
        }
        if (jtsGeom instanceof LineString) {
            com.vividsolutions.jts.geom.Coordinate[] coordinates = JTSUtils2.createCoordinates1(jtsGeom.getCoordinates());
            Coordinate coordinate = jtsGeom.getCoordinate();
            LineString lineString = (LineString)jtsGeom;
            AbstractLine line = coordinate == null ? new Line3DM(coordinates) : (Double.isNaN(coordinate.getM()) ? (Double.isNaN(coordinate.getZ()) ? new Line2D(coordinates) : new Line3D(coordinates)) : (Double.isNaN(coordinate.getZ()) ? new Line2DM(coordinates) : new Line3DM(coordinates)));
            line.setProjection(proj);
            return line;
        }
        if (jtsGeom instanceof Polygon) {
            Polygon polygonJTS = (Polygon)jtsGeom;
            com.vividsolutions.jts.geom.Coordinate[] coordinates = JTSUtils2.createCoordinates1(jtsGeom.getCoordinates());
            Coordinate coordinate = polygonJTS.getExteriorRing().getCoordinate();
            AbstractLine polygon = coordinate == null ? new Polygon3DM(coordinates) : (Double.isNaN(coordinate.getM()) ? (Double.isNaN(coordinate.getZ()) ? new Polygon2D(coordinates) : new Polygon3D(coordinates)) : (Double.isNaN(coordinate.getZ()) ? new Polygon2DM(coordinates) : new Polygon3DM(coordinates)));
            polygon.setProjection(proj);
            for (int i = 0; i < polygonJTS.getNumInteriorRing(); ++i) {
                LinearRing ringJTS = polygonJTS.getInteriorRingN(i);
                coordinates = JTSUtils2.createCoordinates1(ringJTS.getCoordinates());
                coordinate = ringJTS.getCoordinate();
                AbstractLine ring = coordinate == null ? new Ring3DM(coordinates) : (Double.isNaN(coordinate.getM()) ? (Double.isNaN(coordinate.getZ()) ? new Ring2D(coordinates) : new Ring3D(coordinates)) : (Double.isNaN(coordinate.getZ()) ? new Ring2DM(coordinates) : new Ring3DM(coordinates)));
                ring.setProjection(proj);
                polygon.addInteriorRing((Ring)ring);
            }
            return polygon;
        }
        if (jtsGeom instanceof GeometryCollection) {
            GeometryCollection collection = (GeometryCollection)jtsGeom;
            Coordinate coordinate = collection.getCoordinate();
            AbstractMultiPrimitive multiprimitive = null;
            if (jtsGeom instanceof MultiLineString) {
                multiprimitive = coordinate == null ? new MultiLine3DM() : (Double.isNaN(coordinate.getM()) ? (Double.isNaN(coordinate.getZ()) ? new MultiLine2D() : new MultiLine3D()) : (Double.isNaN(coordinate.getZ()) ? new MultiLine2DM() : new MultiLine3DM()));
            } else if (jtsGeom instanceof org.locationtech.jts.geom.MultiPolygon) {
                multiprimitive = coordinate == null ? new MultiPolygon3DM() : (Double.isNaN(coordinate.getM()) ? (Double.isNaN(coordinate.getZ()) ? new MultiPolygon2D() : new MultiPolygon3D()) : (Double.isNaN(coordinate.getZ()) ? new MultiPolygon2DM() : new MultiPolygon3DM()));
            } else if (jtsGeom instanceof MultiPoint) {
                multiprimitive = coordinate == null ? new MultiPoint3DM() : (Double.isNaN(coordinate.getM()) ? (Double.isNaN(coordinate.getZ()) ? new MultiPoint2D() : new MultiPoint3D()) : (Double.isNaN(coordinate.getZ()) ? new MultiPoint2DM() : new MultiPoint3DM()));
            }
            if (multiprimitive != null) {
                for (int i = 0; i < collection.getNumGeometries(); ++i) {
                    org.locationtech.jts.geom.Geometry geometry = collection.getGeometryN(i);
                    multiprimitive.addPrimitive((Primitive)JTSUtils2.createGeometry(proj, geometry));
                }
                multiprimitive.setProjection(proj);
                return multiprimitive;
            }
            int subtype = coordinate == null ? 3 : (Double.isNaN(coordinate.getM()) ? (Double.isNaN(coordinate.getZ()) ? 0 : 1) : (Double.isNaN(coordinate.getZ()) ? 2 : 3));
            DefaultComplex complex = new DefaultComplex(subtype);
            for (int i = 0; i < collection.getNumGeometries(); ++i) {
                org.locationtech.jts.geom.Geometry geometry = collection.getGeometryN(i);
                complex.addPrimitive((Primitive)JTSUtils2.createGeometry(proj, geometry));
            }
            complex.setProjection(proj);
            return complex;
        }
        return null;
    }
}

