/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.raster.swing.impl.bands;

import java.awt.Component;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.gvsig.tools.ToolsLocator;

public class ColorInterpretationCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 8964406967059115883L;
    private List<String> colorSpace;
    private JComboBox<ItemColor> comboBox;

    public ColorInterpretationCellEditor(List<String> colorSpace) {
        this.colorSpace = colorSpace;
    }

    @Override
    public Object getCellEditorValue() {
        return ((ItemColor)this.comboBox.getSelectedItem()).key;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        int i;
        this.comboBox = new JComboBox();
        int selected = i = 0;
        this.comboBox.addItem(new ItemColor("Undefined"));
        if ("Undefined".equalsIgnoreCase((String)value)) {
            selected = i;
        }
        ++i;
        for (String string : this.colorSpace) {
            this.comboBox.addItem(new ItemColor(string));
            if (string.equalsIgnoreCase((String)value)) {
                selected = i;
            }
            ++i;
        }
        this.comboBox.addItem(new ItemColor("Gray"));
        if ("Gray".equalsIgnoreCase((String)value)) {
            selected = i;
        }
        ++i;
        this.comboBox.addItem(new ItemColor("Palette"));
        if ("Palette".equalsIgnoreCase((String)value)) {
            selected = i;
        }
        ++i;
        this.comboBox.setSelectedItem(selected);
        return this.comboBox;
    }

    class ItemColor {
        private String key;

        public ItemColor(String key) {
            this.key = key;
        }

        public String toString() {
            return ToolsLocator.getI18nManager().getTranslation(this.key);
        }
    }
}

