/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.raster.swing.impl.bands;

import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.raster.RasterStore;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.exception.BaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RasterStoreBand
extends AbstractDisposable {
    private static final Logger LOG = LoggerFactory.getLogger(RasterStoreBand.class);
    private RasterStore store;
    private int band;
    private String bandName;
    private Number noDataNumber;
    private String bandColorInterpretation;
    private int dataType;

    public RasterStoreBand(RasterStore store) {
        this.store = store;
        DisposeUtils.bind((Disposable)this.store);
        this.setBand(0);
        this.initializeNoData();
    }

    public RasterStoreBand(RasterStore store, int band) {
        this.store = store;
        DisposeUtils.bind((Disposable)this.store);
        this.setBand(band);
    }

    private void initializeNoData() {
        try {
            NoData noData = this.store.getRasterSet().getBand(this.band).getNoData();
            if (noData != null) {
                this.noDataNumber = noData.getValue();
            }
        }
        catch (DataException e) {
            LOG.warn("Can't get raster set of the store '" + this.store + "'", (Throwable)e);
        }
    }

    public RasterStore getStore() {
        return this.store;
    }

    public int getBand() {
        return this.band;
    }

    public void setBand(int band) {
        if (band < 0 || band >= this.store.getBands()) {
            throw new IllegalArgumentException("Out of bounds. Band ='" + band + "' but store has " + this.store.getBands() + " bands.");
        }
        this.band = band;
    }

    public String getBandColorInterpretation() {
        return this.bandColorInterpretation;
    }

    public void setBandColorInterpretation(String bandColorInterpretation) {
        this.bandColorInterpretation = bandColorInterpretation;
    }

    public Number getNoDataNumber() {
        return this.noDataNumber;
    }

    public void setNoDataNumber(Number noDataNumber) {
        this.noDataNumber = noDataNumber;
    }

    public String getBandName() {
        return this.bandName;
    }

    public void setBandName(String bandName) {
        this.bandName = bandName;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    protected void doDispose() throws BaseException {
        DisposeUtils.dispose((Disposable)this.store);
    }
}

