/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.jdbc.service;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.export.jdbc.service.ExportJDBCParameters;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.namestranslator.BaseNamesTranslator;
import org.gvsig.tools.namestranslator.NamesTranslator;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class ExportJDBCAttributeNamesTranslator
extends BaseNamesTranslator {
    private ExportJDBCParameters parameters;

    public ExportJDBCAttributeNamesTranslator(ExportJDBCParameters parameters) {
        this.parameters = parameters;
    }

    public ExportJDBCAttributeNamesTranslator() {
    }

    public void setParameters(ExportJDBCParameters parameters) {
        this.parameters = parameters;
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition("ExportJDBCAttributeNamesTranslator") == null) {
            DynStruct definition = manager.addDefinition(ExportJDBCAttributeNamesTranslator.class, "ExportJDBCAttributeNamesTranslator", "ExportJDBCAttributeNamesTranslator persistence definition", null, null);
            definition.extend(manager.getDefinition("BaseNamesTranslator"));
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
    }

    public NamesTranslator clone() throws CloneNotSupportedException {
        ExportJDBCAttributeNamesTranslator clone = (ExportJDBCAttributeNamesTranslator)super.clone();
        return clone;
    }

    protected String fixSyntax(String name) {
        String target_name = name;
        if (StringUtils.isBlank((CharSequence)target_name)) {
            target_name = "field";
        }
        target_name = this.parameters.fixIdentifier(target_name);
        return target_name;
    }

    public String getSuggestion(String name) {
        String target_name = this.fixSyntax(name);
        if (this.isValid(target_name)) {
            return target_name;
        }
        for (int i = 0; i < 255; ++i) {
            String new_target_name = target_name + i;
            if (!this.isValid(new_target_name)) continue;
            return new_target_name;
        }
        return target_name.substring(0, 5) + System.currentTimeMillis() % 1000000L;
    }

    public boolean isValid(String name) {
        String s;
        if (!super.isValid(name)) {
            return false;
        }
        if (name.isEmpty()) {
            name = "field";
        }
        if (this.parameters.getRemoveSpacesInIdentifiers() && !name.equals(s = StringUtils.normalizeSpace((String)name).replace(" ", "_"))) {
            return false;
        }
        if (this.parameters.getTranslateHyphens() && name.contains("-")) {
            return false;
        }
        switch (this.parameters.getCaseIdentifiersMode()) {
            case 1: {
                if (StringUtils.equals((CharSequence)name.toUpperCase(), (CharSequence)name)) break;
                return false;
            }
            case 2: {
                if (StringUtils.equals((CharSequence)name.toLowerCase(), (CharSequence)name)) break;
                return false;
            }
        }
        return true;
    }

    public int setTranslation(String sourceName, String translatedName) {
        String target_name = this.fixSyntax(translatedName);
        return super.setTranslation(sourceName, target_name);
    }
}

